/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.spi.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.eclipse.vorto.model.IModel;
import org.eclipse.vorto.model.IPropertyAttribute;
import org.eclipse.vorto.model.IReferenceType;
import org.eclipse.vorto.plugin.generator.adapter.ObjectMapperFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SerializationConfiguration {
    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(IPropertyAttribute.class, (JsonDeserializer)new ObjectMapperFactory.PropertyAttributeDeserializer());
        module.addDeserializer(IReferenceType.class, (JsonDeserializer)new ObjectMapperFactory.ModelReferenceDeserializer());
        module.addDeserializer(IModel.class, (JsonDeserializer)new ObjectMapperFactory.ModelDeserializer());
        module.addDeserializer(Map.class, (JsonDeserializer)new ObjectMapperFactory.ModelMapDeserializer());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)module);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));
        return mapper;
    }
}

