/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.spi.config;

import com.google.common.base.Strings;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.vorto.codegen.spi.config.IGeneratorConfiguration;
import org.eclipse.vorto.codegen.spi.model.Generator;
import org.eclipse.vorto.codegen.spi.repository.GeneratorRepository;
import org.eclipse.vorto.codegen.spi.utils.GatewayUtils;
import org.eclipse.vorto.repository.client.IRepositoryClient;
import org.eclipse.vorto.repository.client.RepositoryClientBuilder;
import org.eclipse.vorto.utilities.reader.ModelWorkspaceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

public abstract class AbstractGeneratorConfiguration
implements ApplicationRunner,
EnvironmentAware,
IGeneratorConfiguration {
    private static final String LOCALHOST = "localhost";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGeneratorConfiguration.class);
    @Autowired
    private Environment env;
    @Autowired
    private GeneratorRepository generatorRepo;

    @PostConstruct
    public void init() {
        ModelWorkspaceReader.init();
        this.ignoreHostnameVerification();
        this.ignoreSSLCertificateVerification();
    }

    public void ignoreHostnameVerification() {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return hostname.equals(AbstractGeneratorConfiguration.LOCALHOST);
            }
        });
    }

    public void ignoreSSLCertificateVerification() {
        SSLContext ctx = null;
        TrustManager[] trustAllCerts = new X509TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            ctx = SSLContext.getInstance("SSL");
            ctx.init(null, trustAllCerts, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            LOGGER.error("Error in ignoring SSL Ceritificate Verification", (Throwable)e);
        }
        SSLContext.setDefault(ctx);
    }

    @Override
    public String getVortoRepoUrl() {
        String vortoRepoUrl = System.getenv("VORTO_REPO_URL");
        if (!Strings.nullToEmpty((String)vortoRepoUrl).trim().isEmpty()) {
            return vortoRepoUrl;
        }
        String vortoServerUrl = this.env.getProperty("vorto.serverUrl");
        if (!Strings.nullToEmpty((String)vortoServerUrl).trim().isEmpty()) {
            return vortoServerUrl;
        }
        throw GatewayUtils.notFound("Not able to get the Vorto Server URL both from the Environment variable VORTO_REPO_URL or the config setting 'vorto.serverUrl'").get();
    }

    @Override
    public String getAppServiceUrl() {
        String serviceoUrl = System.getenv("APP_SERVICE_URL");
        if (!Strings.nullToEmpty((String)serviceoUrl).trim().isEmpty()) {
            return serviceoUrl;
        }
        String applicationServiceUrl = this.env.getProperty("server.serviceUrl");
        if (!Strings.nullToEmpty((String)applicationServiceUrl).trim().isEmpty()) {
            return applicationServiceUrl;
        }
        throw GatewayUtils.notFound("Not able to get the Application Service URL both from the Environment variable APP_SERVICE_URL or the config setting 'server.serviceUrl'").get();
    }

    public void setEnvironment(Environment env) {
        this.env = env;
    }

    protected abstract void doSetup();

    public void run(ApplicationArguments args) throws Exception {
        try {
            this.doSetup();
            this.generatorRepo.list().stream().forEach(GatewayUtils.checkEnvModifications(this.env));
        }
        catch (RuntimeException e) {
            LOGGER.error("Error registering generators", (Throwable)e);
        }
    }

    protected void addGenerator(Generator generator) {
        this.generatorRepo.add(generator);
    }

    @Bean
    public IRepositoryClient modelRepository() {
        return RepositoryClientBuilder.newBuilder().setBaseUrl(this.getVortoRepoUrl()).build();
    }
}

