/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.spi.controllers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.vorto.codegen.api.GeneratorServiceInfo;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.spi.model.Generator;
import org.eclipse.vorto.codegen.spi.repository.GeneratorRepository;
import org.eclipse.vorto.codegen.spi.service.VortoService;
import org.eclipse.vorto.codegen.spi.utils.GatewayUtils;
import org.eclipse.vorto.model.ModelContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/plugins/generators"})
public class GeneratorControllerV2 {
    @Autowired
    private VortoService vorto;
    @Autowired
    private GeneratorRepository repo;

    @RequestMapping(value={"/{pluginkey}/info"}, method={RequestMethod.GET}, produces={"application/json"})
    public GeneratorServiceInfo info(@PathVariable String pluginkey) {
        Generator generator = this.repo.get(pluginkey).orElseThrow(GatewayUtils.notFound(String.format("[Generator %s]", pluginkey)));
        return generator.getFullInfo();
    }

    @RequestMapping(value={"/{pluginkey}"}, method={RequestMethod.POST, RequestMethod.PUT, RequestMethod.GET})
    public ResponseEntity<InputStreamResource> generate(@PathVariable String pluginkey, @RequestBody ModelContent model, HttpServletRequest request) {
        return this.responseFromResult(this.vorto.generate(model, pluginkey, GatewayUtils.mapFromRequest(request)));
    }

    private ResponseEntity<InputStreamResource> responseFromResult(IGenerationResult result) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentLength((long)result.getContent().length).header("content-disposition", new String[]{"attachment; filename = " + result.getFileName()})).contentType(MediaType.parseMediaType((String)result.getMediatype())).body((Object)new InputStreamResource((InputStream)new ByteArrayInputStream(result.getContent())));
    }
}

