/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.spi.service;

import java.util.List;
import org.eclipse.vorto.codegen.api.GeneratorInfo;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IGeneratorLookup;
import org.eclipse.vorto.codegen.api.IVortoCodeGenProgressMonitor;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.api.VortoCodeGeneratorException;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ServerGeneratorLookup
implements IGeneratorLookup {
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${vorto.serverUrl}")
    private String basePath;

    public IVortoCodeGenerator lookupByKey(String key) {
        return new VortoCodeGeneratorProxy(key);
    }

    class VortoCodeGeneratorProxy
    implements IVortoCodeGenerator {
        private String key;

        public VortoCodeGeneratorProxy(String key) {
            this.key = key;
        }

        private String extractFileNameFromHeader(ResponseEntity<byte[]> entity) {
            List values = entity.getHeaders().get((Object)"content-disposition");
            if (values.size() > 0) {
                int indexOfFileNameStart = ((String)values.get(0)).indexOf("=");
                return ((String)values.get(0)).substring(indexOfFileNameStart + 1);
            }
            return "generated.output";
        }

        public String getServiceKey() {
            return this.key;
        }

        public IGenerationResult generate(InformationModel model, InvocationContext context, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
            ServerGeneratorLookup.this.restTemplate.getMessageConverters().add(new ByteArrayHttpMessageConverter());
            final ResponseEntity entity = ServerGeneratorLookup.this.restTemplate.getForEntity(ServerGeneratorLookup.this.basePath + "/rest/generation-router/{namespace}/{name}/{version}/{serviceKey}", byte[].class, new Object[]{model.getNamespace(), model.getName(), model.getVersion(), this.key});
            return new IGenerationResult(){

                public String getMediatype() {
                    return "application/zip";
                }

                public String getFileName() {
                    return VortoCodeGeneratorProxy.this.extractFileNameFromHeader((ResponseEntity<byte[]>)entity);
                }

                public byte[] getContent() {
                    return (byte[])entity.getBody();
                }
            };
        }

        public GeneratorInfo getInfo() {
            return null;
        }
    }
}

