/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.spi.model;

import java.util.Objects;
import org.eclipse.vorto.codegen.api.GeneratorServiceInfo;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.spi.exception.GeneratorCreationException;
import org.eclipse.vorto.codegen.spi.templates.DefaultGeneratorConfigUI;
import org.eclipse.vorto.codegen.spi.templates.IGeneratorConfigUITemplate;
import org.eclipse.vorto.codegen.spi.utils.GatewayUtils;

public class Generator {
    private GeneratorServiceInfo info;
    private IVortoCodeGenerator instance;
    private IGeneratorConfigUITemplate configUi = null;

    public static Generator create(String configFile, Class<? extends IVortoCodeGenerator> generatorClass, IGeneratorConfigUITemplate configTemplate) {
        Objects.requireNonNull(configFile);
        Objects.requireNonNull(generatorClass);
        Objects.requireNonNull(configTemplate);
        try {
            IVortoCodeGenerator instance = generatorClass.newInstance();
            Generator generator = new Generator(GatewayUtils.generatorInfoFromFile(configFile, instance), instance, configTemplate);
            generator.info.setDescription(instance.getInfo().getDescription());
            generator.info.setCreator(instance.getInfo().getOrganisation());
            generator.info.setName(instance.getInfo().getName());
            generator.info.setTags(instance.getInfo().getTags().toArray(new String[instance.getInfo().getTags().size()]));
            return generator;
        }
        catch (Exception e) {
            throw new GeneratorCreationException("Error in instantiating Generator", e);
        }
    }

    public static Generator create(String configFile, Class<? extends IVortoCodeGenerator> generatorClass) {
        Objects.requireNonNull(configFile);
        Objects.requireNonNull(generatorClass);
        try {
            IVortoCodeGenerator instance = generatorClass.newInstance();
            Generator generator = new Generator(GatewayUtils.generatorInfoFromFile(configFile, instance), instance, Generator.createConfigUI(instance));
            generator.info.setDescription(instance.getInfo().getDescription());
            generator.info.setCreator(instance.getInfo().getOrganisation());
            generator.info.setName(instance.getInfo().getName());
            generator.info.setTags(instance.getInfo().getTags().toArray(new String[instance.getInfo().getTags().size()]));
            return generator;
        }
        catch (Exception e) {
            throw new GeneratorCreationException("Error in instantiating Generator", e);
        }
    }

    private static IGeneratorConfigUITemplate createConfigUI(IVortoCodeGenerator generator) {
        return new DefaultGeneratorConfigUI(generator.getInfo());
    }

    private Generator(GeneratorServiceInfo info, IVortoCodeGenerator instance, IGeneratorConfigUITemplate configTemplate) {
        this.info = Objects.requireNonNull(info);
        this.instance = Objects.requireNonNull(instance);
        this.configUi = Objects.requireNonNull(configTemplate);
    }

    public GeneratorServiceInfo getInfo() {
        return this.info;
    }

    public void setInfo(GeneratorServiceInfo info) {
        this.info = info;
    }

    public IVortoCodeGenerator getInstance() {
        return this.instance;
    }

    public void setInstance(IVortoCodeGenerator instance) {
        this.instance = instance;
    }

    public GeneratorServiceInfo getFullInfo() {
        this.info.setConfigTemplate(this.configUi.getContent(this.info));
        this.info.setConfigKeys(this.configUi.getKeys());
        return this.info;
    }
}

