/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.spi.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.vorto.model.BooleanAttributeProperty;
import org.eclipse.vorto.model.EntityModel;
import org.eclipse.vorto.model.EnumAttributeProperty;
import org.eclipse.vorto.model.EnumModel;
import org.eclipse.vorto.model.FunctionblockModel;
import org.eclipse.vorto.model.IModel;
import org.eclipse.vorto.model.IPropertyAttribute;
import org.eclipse.vorto.model.IReferenceType;
import org.eclipse.vorto.model.Infomodel;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelType;
import org.eclipse.vorto.model.PrimitiveType;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
public class SerializationConfiguration {
    @Bean
    public Jackson2ObjectMapperBuilder objectMapperBuilder() {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        builder.deserializerByType(IReferenceType.class, (JsonDeserializer)new JsonDeserializer<IReferenceType>(){

            public IReferenceType deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
                try {
                    return (IReferenceType)parser.readValueAs(ModelId.class);
                }
                catch (IOException ioEx) {
                    try {
                        return (IReferenceType)parser.readValueAs(PrimitiveType.class);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }
            }
        });
        builder.deserializerByType(IPropertyAttribute.class, (JsonDeserializer)new JsonDeserializer<IPropertyAttribute>(){

            public IPropertyAttribute deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
                try {
                    return (IPropertyAttribute)parser.readValueAs(BooleanAttributeProperty.class);
                }
                catch (IOException ioEx) {
                    try {
                        return (IPropertyAttribute)parser.readValueAs(EnumAttributeProperty.class);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }
            }
        });
        builder.deserializerByType(Map.class, (JsonDeserializer)new JsonDeserializer<HashMap<ModelId, IModel>>(){

            public HashMap<ModelId, IModel> deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
                try {
                    HashMap<ModelId, IModel> deserialized = new HashMap<ModelId, IModel>();
                    ObjectCodec oc = parser.getCodec();
                    JsonNode node = (JsonNode)oc.readTree(parser);
                    Iterator iterator = node.elements();
                    while (iterator.hasNext()) {
                        JsonNode childNode = (JsonNode)iterator.next();
                        JsonNode type = childNode.get("type");
                        IModel value = null;
                        value = ModelType.valueOf((String)type.asText()).equals((Object)ModelType.InformationModel) ? (IModel)oc.treeToValue((TreeNode)childNode, Infomodel.class) : (ModelType.valueOf((String)type.asText()).equals((Object)ModelType.Functionblock) ? (IModel)oc.treeToValue((TreeNode)childNode, FunctionblockModel.class) : (ModelType.valueOf((String)type.asText()).equals((Object)ModelType.Datatype) && childNode.has("literals") ? (IModel)oc.treeToValue((TreeNode)childNode, EnumModel.class) : (IModel)oc.treeToValue((TreeNode)childNode, EntityModel.class)));
                        if (value == null) continue;
                        deserialized.put(this.getModelId(childNode.get("id").get("prettyFormat").asText()), value);
                    }
                    return deserialized;
                }
                catch (IOException ioEx) {
                    throw new RuntimeException(ioEx);
                }
            }

            private ModelId getModelId(String modelId) {
                try {
                    return ModelId.fromPrettyFormat((String)modelId);
                }
                catch (IllegalArgumentException ex) {
                    int versionIndex = modelId.indexOf(":");
                    return ModelId.fromReference((String)modelId.substring(0, versionIndex), (String)modelId.substring(versionIndex + 1));
                }
            }
        });
        return builder;
    }
}

