/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.spi.controllers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.vorto.codegen.api.GeneratorServiceInfo;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.spi.config.IGeneratorConfiguration;
import org.eclipse.vorto.codegen.spi.model.Generator;
import org.eclipse.vorto.codegen.spi.repository.GeneratorRepository;
import org.eclipse.vorto.codegen.spi.service.VortoService;
import org.eclipse.vorto.codegen.spi.utils.GatewayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest"})
public class Generators {
    private static final String AUTHORIZATION = "Authorization";
    @Autowired
    private IGeneratorConfiguration env;
    @Autowired
    private VortoService vorto;
    @Autowired
    private GeneratorRepository repo;

    @RequestMapping(value={"/generators"}, method={RequestMethod.GET}, produces={"application/json"})
    public Collection<GeneratorServiceInfo> list() {
        return this.repo.list().stream().map(generator -> generator.getInfo()).collect(Collectors.toList());
    }

    @RequestMapping(value={"/generators/{key}/generate/info"}, method={RequestMethod.GET}, produces={"application/json"})
    public GeneratorServiceInfo info(@PathVariable String key, @RequestParam boolean includeConfigUI) {
        Generator generator = this.repo.get(key).orElseThrow(GatewayUtils.notFound(String.format("[Generator %s]", key)));
        return includeConfigUI ? generator.getFullInfo() : generator.getInfo();
    }

    @RequestMapping(value={"/generators/{key}/generate/{namespace}/{name}/{version:.+}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<InputStreamResource> generate(@PathVariable String key, @PathVariable String namespace, @PathVariable String name, @PathVariable String version, HttpServletRequest request) {
        return this.responseFromResult(this.vorto.generate(key, namespace, name, version, GatewayUtils.mapFromRequest(request), this.getAuthorization(request)));
    }

    @RequestMapping(value={"/generators/{key}/generate"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<InputStreamResource> generateInfra(@PathVariable String key, HttpServletRequest request) {
        return this.responseFromResult(this.vorto.generate(key, GatewayUtils.mapFromRequest(request), this.getAuthorization(request)));
    }

    private Optional<String> getAuthorization(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader(AUTHORIZATION));
    }

    private ResponseEntity<InputStreamResource> responseFromResult(IGenerationResult result) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentLength((long)result.getContent().length).header("content-disposition", new String[]{"attachment; filename = " + result.getFileName()})).contentType(MediaType.parseMediaType((String)result.getMediatype())).body((Object)new InputStreamResource((InputStream)new ByteArrayInputStream(result.getContent())));
    }

    @RequestMapping(value={"/reset"}, method={RequestMethod.GET}, produces={"application/json"})
    public Map<String, String> reRegister() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.repo.list().stream().forEach(this.vorto::register);
            map.put("result", "OK");
        }
        catch (Exception e) {
            map.put("result", "ERROR");
            map.put("errorMessage", e.getMessage());
        }
        map.put("vortoServerUrl", this.env.getVortoRepoUrl());
        map.put("applicationServiceUrl", this.env.getAppServiceUrl());
        map.put("numGenerators", Integer.toString(this.repo.list().size()));
        return map;
    }
}

