/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.openapi;

import org.eclipse.vorto.codegen.openapi.templates.OpenAPITemplate;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.plugin.generator.GeneratorException;
import org.eclipse.vorto.plugin.generator.GeneratorPluginInfo;
import org.eclipse.vorto.plugin.generator.ICodeGenerator;
import org.eclipse.vorto.plugin.generator.IGenerationResult;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.config.ConfigTemplateBuilder;
import org.eclipse.vorto.plugin.generator.utils.GeneratorTaskFromFileTemplate;
import org.eclipse.vorto.plugin.generator.utils.IFileTemplate;
import org.eclipse.vorto.plugin.generator.utils.IGeneratedWriter;
import org.eclipse.vorto.plugin.generator.utils.SingleGenerationResult;

public class OpenAPIGenerator
implements ICodeGenerator {
    private static final String KEY = "openapi";
    private final String version = this.loadVersionFromResources();

    public IGenerationResult generate(InformationModel infomodel, InvocationContext context) throws GeneratorException {
        SingleGenerationResult output = new SingleGenerationResult("application/vnd.oai.openapi;version=3.0");
        OpenAPITemplate openAPITemplate = new OpenAPITemplate();
        new GeneratorTaskFromFileTemplate((IFileTemplate)openAPITemplate).generate((Object)infomodel, context, (IGeneratedWriter)output);
        return output;
    }

    public GeneratorPluginInfo getMeta() {
        return (GeneratorPluginInfo)GeneratorPluginInfo.Builder((String)KEY).withConfigurationKey(new String[]{"digitaltwin"}).withConfigurationTemplate(ConfigTemplateBuilder.builder().withChoiceConfigurationItem("digitaltwin", "Digital Twin API", new ConfigTemplateBuilder.ChoiceItem[]{ConfigTemplateBuilder.ChoiceItem.of((String)"Bosch IoT Things", (String)"boschiotthings")}).build()).withDescription("Generates device specific OpenAPI - Swagger descriptors for Digital Twin Service APIs").withName("OpenAPI").withDocumentationUrl("https://swagger.io/docs/specification/about/").withVendor("Eclipse Vorto Team").withPluginVersion(this.version).build();
    }
}

