/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.openapi.templates;

import com.google.common.base.Objects;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.openapi.Utils;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.ConstraintRule;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Event;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.PrimitiveParam;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.IFileTemplate;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class OpenAPITemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel model) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = model.getName();
        _builder.append(_name);
        _builder.append("-openapi-v3.yml");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        return null;
    }

    public String getContent(InformationModel infomodel, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("### Generated by Eclipse Vorto OpenAPI Generator from Model '");
        String _namespace = infomodel.getNamespace();
        _builder.append(_namespace);
        _builder.append(":");
        String _name = infomodel.getName();
        _builder.append(_name);
        _builder.append(":");
        String _version = infomodel.getVersion();
        _builder.append(_version);
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("openapi: 3.0.0");
        _builder.newLine();
        _builder.append("info:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("title: Bosch IoT Things HTTP API for ");
        String _name_1 = infomodel.getName();
        _builder.append(_name_1, "  ");
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("description: JSON-based, REST-like API for <a href=\"https://vorto.eclipse.org/#/details/");
        String _namespace_1 = infomodel.getNamespace();
        _builder.append(_namespace_1, "  ");
        _builder.append(":");
        String _name_2 = infomodel.getName();
        _builder.append(_name_2, "  ");
        _builder.append(":");
        String _version_1 = infomodel.getVersion();
        _builder.append(_version_1, "  ");
        _builder.append("\">");
        String _name_3 = infomodel.getName();
        _builder.append(_name_3, "  ");
        _builder.append(" Vorto Model</a>");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("version: \"");
        String _version_2 = infomodel.getVersion();
        _builder.append(_version_2, "  ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("servers:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("- url: https://things.eu-1.bosch-iot-suite.com/api/2");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("description: \"Bosch IoT Things Service\"");
        _builder.newLine();
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("- name: Things");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("description: List every Thing");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("- name: Features");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("description: Features of your ");
        String _name_4 = infomodel.getName();
        _builder.append(_name_4, "    ");
        _builder.append(" things");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("- name: Messages");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("description: Send messages to / Receive event messages from ");
        String _name_5 = infomodel.getName();
        _builder.append(_name_5, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("security:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("- bearerAuth: []");
        _builder.newLine();
        _builder.append("paths:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("###");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("### Things");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("###");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("'/things':");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("get:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("summary: List all available Things");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Returns all Things passed in by the required parameter `ids`. Optionally");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("you can use field selectors (see parameter `fields`) to only get the");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("specified fields.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- Things");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'200':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The successfully completed request contains as its result the first");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("200 for the user available Things, sorted by their `thingId`.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("type: array");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("items:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/Thing'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'400':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed. At least one of the defined");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("query parameters was invalid.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'401':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: The request could not be completed due to missing authentication.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'403':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed due to a missing or invalid API");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("Token.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'414':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed due to an URI length exceeding 8k");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("characters.");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("'/things/{thingId}':");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("get:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("summary: Retrieve a specific Thing");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Returns the Thing identified by the `thingId` path parameter. The");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("response includes details about the Thing. Note that the Thing's Policy");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("is not included in the response per default. Optionally you can use");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("field selectors (see parameter `fields`) to only get the specified");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("fields. E.g., you can get the Thing's Policy by using a field selector.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- Things");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("parameters:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'200':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: The request successfully returned the specific Thing.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/Thing'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'304':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '#/components/responses/notModified'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'400':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed. The `thingId` either");
        _builder.newLine();
        _builder.newLine();
        _builder.append("              ");
        _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("* does not conform to RFC-2396 (URI)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("              ");
        _builder.append("Or one of the defined query parameters was invalid.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'401':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: The request could not be completed due to missing authentication.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'403':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed due to a missing or invalid API");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("Token.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'404':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed. The Thing with the given ID was");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("not found.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'412':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '#/components/responses/preconditionFailed'");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("###");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("### ");
        String _name_6 = infomodel.getName();
        _builder.append(_name_6, "  ");
        _builder.append(" Features");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("###");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("'/things/{thingId}/features':");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("get:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("summary: List all features of a ");
        String _name_7 = infomodel.getName();
        _builder.append(_name_7, "      ");
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Returns all features of the ");
        String _name_8 = infomodel.getName();
        _builder.append(_name_8, "        ");
        _builder.append(" thing identified by the `thingId` path parameter.");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- Features");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("parameters:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'200':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The list of features of the ");
        String _name_9 = infomodel.getName();
        _builder.append(_name_9, "            ");
        _builder.append(" were successfully retrieved.");
        _builder.newLineIfNotEmpty();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/");
        String _name_10 = infomodel.getName();
        _builder.append(_name_10, "                ");
        _builder.append("Features'");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("'304':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("$ref: '#/components/responses/notModified'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'400':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The request could not be completed. The `thingId` either");
        _builder.newLine();
        _builder.newLine();
        _builder.append("              ");
        _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("* does not conform to RFC-2396 (URI)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("            ");
        _builder.append("Or at least one of the defined query parameters was invalid.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'401':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The request could not be completed due to missing authentication.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'404':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The request could not be completed. The Thing with the given ID was not found or the Features have not");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("been defined.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'412':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("$ref: '#/components/responses/preconditionFailed'");
        _builder.newLine();
        EList _properties = infomodel.getProperties();
        for (Object fbProperty : _properties) {
            _builder.append("  ");
            _builder.append("'/things/{thingId}/features/");
            String _name_11 = fbProperty.getName();
            _builder.append(_name_11, "  ");
            _builder.append("':");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("  ");
            _builder.append("get:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("summary: Retrieve the ");
            String _name_12 = fbProperty.getName();
            _builder.append(_name_12, "      ");
            _builder.append(" of the ");
            String _name_13 = infomodel.getName();
            _builder.append(_name_13, "      ");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("description: >-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("Returns the ");
            String _name_14 = fbProperty.getName();
            _builder.append(_name_14, "        ");
            _builder.append(" feature of the ");
            String _name_15 = infomodel.getName();
            _builder.append(_name_15, "        ");
            _builder.append(" thing identified by the");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("`thingId` path parameter.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("tags:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- Features");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("parameters:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("responses:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'200':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: The ");
            String _name_16 = fbProperty.getName();
            _builder.append(_name_16, "          ");
            _builder.append(" was successfully retrieved.");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/");
            String _name_17 = fbProperty.getType().getName();
            _builder.append(_name_17, "                ");
            _builder.append("Feature'");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'304':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("$ref: '#/components/responses/notModified'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'400':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: >-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("The request could not be completed. The `thingId` either");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("* does not conform to RFC-2396 (URI)");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("Or at least one of the defined query parameters was invalid.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'401':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: The request could not be completed due to missing authentication.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'404':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: >-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("The request could not be completed. The Thing with the given ID or the Feature with the specified");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("`featureId` was not found.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'412':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("$ref: '#/components/responses/preconditionFailed'");
            _builder.newLine();
            if (fbProperty.getType().getFunctionblock().getConfiguration() != null && !fbProperty.getType().getFunctionblock().getConfiguration().getProperties().isEmpty()) {
                EList _properties_1 = fbProperty.getType().getFunctionblock().getConfiguration().getProperties();
                for (Property configurationProperty : _properties_1) {
                    _builder.append("  ");
                    _builder.append("'/things/{thingId}/features/");
                    String _name_18 = fbProperty.getName();
                    _builder.append(_name_18, "  ");
                    _builder.append("/properties/configuration/");
                    String _name_19 = configurationProperty.getName();
                    _builder.append(_name_19, "  ");
                    _builder.append("':");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("  ");
                    _builder.append("put:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("summary: Sets the device configuration property ");
                    String _name_20 = configurationProperty.getName();
                    _builder.append(_name_20, "      ");
                    _builder.append(" of the ");
                    String _name_21 = fbProperty.getName();
                    _builder.append(_name_21, "      ");
                    _builder.append(" feature");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("description: |-");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("Sets the ");
                    String _name_22 = configurationProperty.getName();
                    _builder.append(_name_22, "        ");
                    _builder.append(" of the ");
                    String _name_23 = fbProperty.getName();
                    _builder.append(_name_23, "        ");
                    _builder.append(" feature, identified by the");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("`thingId` path parameter. The set configuration property is transmitted to the device, once the device is connected.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("tags:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("- Features");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("parameters:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("responses:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'204':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: The Property was successfully updated.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'400':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: |-");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("The request could not be completed. The `thingId` either");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("* does not conform to RFC-2396 (URI)");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("Or the JSON was invalid.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("schema:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("              ");
                    _builder.append("$ref: '#/components/schemas/AdvancedError'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'401':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: The request could not be completed due to missing authentication.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("schema:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("              ");
                    _builder.append("$ref: '#/components/schemas/AdvancedError'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'402':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: The request could not be completed due to exceeded data volume.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("schema:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("              ");
                    _builder.append("$ref: '#/components/schemas/AdvancedError'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'403':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: |-");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("The request could not be completed. Either");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("* due to a missing or invalid API Token.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("* as the caller had insufficient permissions.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("For creating/updating a Property of an existing Feature `WRITE` permission is required.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("schema:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("              ");
                    _builder.append("$ref: '#/components/schemas/AdvancedError'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'404':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: |-");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("The request could not be completed. The Thing or the Feature with");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("the given ID was not found.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("schema:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("              ");
                    _builder.append("$ref: '#/components/schemas/AdvancedError'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'412':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("$ref: '#/components/responses/preconditionFailed'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'413':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("$ref: '#/components/responses/entityTooLarge'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("requestBody:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("$ref: '#/components/requestBodies/");
                    String _name_24 = fbProperty.getType().getName();
                    _builder.append(_name_24, "        ");
                    String _firstUpper = StringExtensions.toFirstUpper((String)configurationProperty.getName());
                    _builder.append(_firstUpper, "        ");
                    _builder.append("ConfigurationValue'");
                    _builder.newLineIfNotEmpty();
                }
            }
            EList _events = fbProperty.getType().getFunctionblock().getEvents();
            for (Event event : _events) {
                _builder.append("  ");
                _builder.append("'/things/{thingId}/features/");
                String _name_25 = fbProperty.getName();
                _builder.append(_name_25, "  ");
                _builder.append("/outbox/messages/");
                String _name_26 = event.getName();
                _builder.append(_name_26, "  ");
                _builder.append("':");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("post:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("summary: Receive ");
                String _name_27 = event.getName();
                _builder.append(_name_27, "      ");
                _builder.append(" emitted by the device");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("Send a message with the subject `");
                String _name_28 = event.getName();
                _builder.append(_name_28, "        ");
                _builder.append("` `FROM` the Thing");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("identified by the `thingId` path parameter. The request body contains");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("the device event payload and the `Content-Type` header defines its type.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("In order to send a message, the user needs `WRITE` permission at the");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("Thing level.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("The HTTP request blocks until a response to the message is available");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("or until the `timeout` is expired. If many clients respond to");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("the issued message, the first response will complete the HTTP request.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("In order to handle the message in a fire and forget manner, add");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("a query-parameter `timeout=0` to the request.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("tags:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("- Messages");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("parameters:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("- $ref: '#/components/parameters/messageTimeoutParam'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("responses:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'202':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: The message was sent (fire and forget).");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'400':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("The request could not be completed. The `thingId` either");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* does not conform to RFC-2396 (URI)");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("Or at least one of the defined path parameters was invalid.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'401':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: The request could not be completed due to missing authentication.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'403':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("The request could not be completed. Either");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* due to a missing or invalid API Token.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* as the caller does not have `WRITE` permission on the resource message:/outbox/messages/`messageSubject`.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'413':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("$ref: '#/components/responses/messageTooLarge'");
                _builder.newLine();
                boolean _isEmpty = event.getProperties().isEmpty();
                boolean _not = !_isEmpty;
                if (!_not) continue;
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("requestBody:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("$ref: '#/components/requestBodies/");
                String _name_29 = fbProperty.getType().getName();
                _builder.append(_name_29, "        ");
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)event.getName());
                _builder.append(_firstUpper_1, "        ");
                _builder.append("EventPayload'");
                _builder.newLineIfNotEmpty();
            }
            EList _operations = fbProperty.getType().getFunctionblock().getOperations();
            for (Operation operation : _operations) {
                boolean _tripleNotEquals_1;
                boolean _tripleNotEquals;
                _builder.append("  ");
                _builder.append("'/things/{thingId}/features/");
                String _name_30 = fbProperty.getName();
                _builder.append(_name_30, "  ");
                _builder.append("/inbox/messages/");
                String _name_31 = operation.getName();
                _builder.append(_name_31, "  ");
                _builder.append("':");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("post:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("summary: Executes the ");
                String _name_32 = operation.getName();
                _builder.append(_name_32, "      ");
                _builder.append(" on the device");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                String _description = operation.getDescription();
                boolean bl = _tripleNotEquals = _description != null;
                if (_tripleNotEquals) {
                    String _description_1 = operation.getDescription();
                    _builder.append(_description_1, "        ");
                } else {
                    _builder.append("Executes the ");
                    String _name_33 = operation.getName();
                    _builder.append(_name_33, "        ");
                    _builder.append(" on the device.");
                }
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("    ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("The API does not provide any kind of acknowledgement that the");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("message was received by the Feature. In order to send a message, the user needs `WRITE` permission at the Thing level.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("The HTTP request blocks until a response to the message is available");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("or until the `timeout` is expired. If many clients respond to");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("the issued message, the first response will complete the HTTP request.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("In order to handle the message in a fire and forget manner, add");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("a query-parameter `timeout=0` to the request.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("tags:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("- Messages");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("parameters:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("- $ref: '#/components/parameters/messageTimeoutParam'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("responses:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'202':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("The message was sent but not necessarily received by the Feature");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("(fire and forget).");
                _builder.newLine();
                ReturnType _returnType = operation.getReturnType();
                boolean bl2 = _tripleNotEquals_1 = _returnType != null;
                if (_tripleNotEquals_1) {
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("  ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("schema:");
                    _builder.newLine();
                    ReturnType _returnType_1 = operation.getReturnType();
                    if (_returnType_1 instanceof ReturnPrimitiveType) {
                        _builder.append("  ");
                        _builder.append("        ");
                        _builder.append("      ");
                        ReturnType _returnType_2 = operation.getReturnType();
                        ReturnType _returnType_3 = operation.getReturnType();
                        CharSequence _wrapIfMultiple = this.wrapIfMultiple(this.getPrimitive(((ReturnPrimitiveType)_returnType_2).getReturnType()).toString(), ((ReturnPrimitiveType)_returnType_3).isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple, "                ");
                        _builder.newLineIfNotEmpty();
                    } else {
                        ReturnType _returnType_4 = operation.getReturnType();
                        if (_returnType_4 instanceof ReturnObjectType) {
                            _builder.append("  ");
                            _builder.append("        ");
                            _builder.append("      ");
                            ReturnType _returnType_5 = operation.getReturnType();
                            String _name_34 = ((ReturnObjectType)_returnType_5).getReturnType().getName();
                            String _plus = "$ref: '#/components/schemas/" + _name_34;
                            String _plus_1 = _plus + "'";
                            ReturnType _returnType_6 = operation.getReturnType();
                            CharSequence _wrapIfMultiple_1 = this.wrapIfMultiple(_plus_1, ((ReturnObjectType)_returnType_6).isMultiplicity());
                            _builder.append((Object)_wrapIfMultiple_1, "                ");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'400':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("The request could not be completed. The `thingId` either");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("* does not conform to RFC-2396 (URI)");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("Or at least one of the defined path parameters was invalid.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'401':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: The request could not be completed due to missing authentication.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'403':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("The request could not be completed. Either");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* due to a missing or invalid API Token.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* as the caller does not have `WRITE` permission on the resource message:/features/`featureId`/inbox/messages/`messageSubject`.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'413':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("$ref: '#/components/responses/messageTooLarge'");
                _builder.newLine();
                boolean _isEmpty_1 = operation.getParams().isEmpty();
                boolean _not_1 = !_isEmpty_1;
                if (!_not_1) continue;
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("requestBody:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("$ref: '#/components/requestBodies/");
                String _name_35 = fbProperty.getType().getName();
                _builder.append(_name_35, "        ");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)operation.getName());
                _builder.append(_firstUpper_2, "        ");
                _builder.append("Payload'");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("components:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("schemas:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("AdvancedError:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("properties:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("status:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: integer");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The HTTP status of the error");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("error:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The error code of the occurred exception");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("message:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The message of the error - what went wrong");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("description:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: A description how to fix the error or more details");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("href:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: A link to further information about the error and how to fix it");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- status");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- error");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- message");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Thing:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("type: object");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- thingId");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- policyId");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- attributes");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- features");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("properties:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("thingId:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: Unique identifier representing the thing");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("policyId:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The policy ID used for controlling access to this thing, managed by resource `/policies/{policyId}`");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("attributes:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("$ref: '#/components/schemas/Attributes'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("features:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("$ref: '#/components/schemas/");
        String _name_36 = infomodel.getName();
        _builder.append(_name_36, "          ");
        _builder.append("Features'");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("Attributes:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("type: object");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: An arbitrary JSON object describing the attributes of a Thing.");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("FeatureDefinition:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("type: array");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("minItems: 1");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("uniqueItems: true");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("items:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("description: \"A single fully qualified identifier of a Feature Definition in the form 'namespace:name:version'\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("pattern: ([_a-zA-Z0-9\\-.]+):([_a-zA-Z0-9\\-.]+):([_a-zA-Z0-9\\-.]+)");
        _builder.newLine();
        EList<FunctionblockModel> _referencedFunctionBlocks = Utils.getReferencedFunctionBlocks(infomodel);
        for (FunctionblockModel fb : _referencedFunctionBlocks) {
            boolean _tripleNotEquals_2;
            Configuration _configuration = fb.getFunctionblock().getConfiguration();
            boolean bl = _tripleNotEquals_2 = _configuration != null;
            if (_tripleNotEquals_2) {
                EList _properties_2 = fb.getFunctionblock().getConfiguration().getProperties();
                for (Property configurationProperty_1 : _properties_2) {
                    _builder.append("    ");
                    String _name_37 = fb.getName();
                    _builder.append(_name_37, "    ");
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)configurationProperty_1.getName());
                    _builder.append(_firstUpper_3, "    ");
                    _builder.append("ConfigurationValue:");
                    _builder.newLineIfNotEmpty();
                    PropertyType _type = configurationProperty_1.getType();
                    if (_type instanceof PrimitivePropertyType) {
                        _builder.append("    ");
                        _builder.append("  ");
                        PropertyType _type_1 = configurationProperty_1.getType();
                        CharSequence _wrapIfMultiple_2 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_1).getType()).toString(), configurationProperty_1.isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_2, "      ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule = configurationProperty_1.getConstraintRule();
                        boolean _tripleNotEquals_3 = _constraintRule != null;
                        if (!_tripleNotEquals_3) continue;
                        _builder.append("    ");
                        _builder.append("  ");
                        CharSequence _handleConstraints = this.handleConstraints(configurationProperty_1.getConstraintRule());
                        _builder.append((Object)_handleConstraints, "      ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_2 = configurationProperty_1.getType();
                    if (!(_type_2 instanceof ObjectPropertyType)) continue;
                    _builder.append("    ");
                    _builder.append("  ");
                    PropertyType _type_3 = configurationProperty_1.getType();
                    String _name_38 = ((ObjectPropertyType)_type_3).getType().getName();
                    String _plus_2 = "$ref: '#/components/schemas/" + _name_38;
                    String _plus_3 = _plus_2 + "'";
                    CharSequence _wrapIfMultiple_3 = this.wrapIfMultiple(_plus_3, configurationProperty_1.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_3, "      ");
                    _builder.newLineIfNotEmpty();
                }
            }
            EList _operations_1 = fb.getFunctionblock().getOperations();
            for (Operation operation_1 : _operations_1) {
                boolean _isEmpty_2 = operation_1.getParams().isEmpty();
                boolean _not_2 = !_isEmpty_2;
                if (!_not_2) continue;
                _builder.append("    ");
                String _name_39 = fb.getName();
                _builder.append(_name_39, "    ");
                String _firstUpper_4 = StringExtensions.toFirstUpper((String)operation_1.getName());
                _builder.append(_firstUpper_4, "    ");
                _builder.append("Payload:");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("properties:");
                _builder.newLine();
                EList _params = operation_1.getParams();
                for (Param param : _params) {
                    boolean _tripleNotEquals_4;
                    _builder.append("    ");
                    _builder.append("    ");
                    String _name_40 = param.getName();
                    _builder.append(_name_40, "        ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    String _description_2 = param.getDescription();
                    boolean bl3 = _tripleNotEquals_4 = _description_2 != null;
                    if (_tripleNotEquals_4) {
                        _builder.append("description: ");
                        String _description_3 = param.getDescription();
                        _builder.append(_description_3, "          ");
                    }
                    _builder.newLineIfNotEmpty();
                    if (param instanceof PrimitiveParam) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        CharSequence _wrapIfMultiple_4 = this.wrapIfMultiple(this.getPrimitive(((PrimitiveParam)param).getType()).toString(), ((PrimitiveParam)param).isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_4, "          ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_1 = ((PrimitiveParam)param).getConstraintRule();
                        boolean _tripleNotEquals_5 = _constraintRule_1 != null;
                        if (!_tripleNotEquals_5) continue;
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        CharSequence _handleConstraints_1 = this.handleConstraints(((PrimitiveParam)param).getConstraintRule());
                        _builder.append((Object)_handleConstraints_1, "          ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    if (!(param instanceof RefParam)) continue;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    String _name_41 = ((RefParam)param).getType().getName();
                    String _plus_4 = "$ref: '#/components/schemas/" + _name_41;
                    String _plus_5 = _plus_4 + "'";
                    CharSequence _wrapIfMultiple_5 = this.wrapIfMultiple(_plus_5, ((RefParam)param).isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_5, "          ");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("    ");
            String _name_42 = fb.getName();
            _builder.append(_name_42, "    ");
            _builder.append("Properties:");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("type: object");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("description: ");
            String _name_43 = fb.getName();
            _builder.append(_name_43, "      ");
            _builder.append(" properties of ");
            String _name_44 = infomodel.getName();
            _builder.append(_name_44, "      ");
            _builder.newLineIfNotEmpty();
            if (fb.getFunctionblock().getStatus() != null && !fb.getFunctionblock().getStatus().getProperties().isEmpty() || fb.getFunctionblock().getConfiguration() != null && !fb.getFunctionblock().getConfiguration().getProperties().isEmpty()) {
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("properties:");
                _builder.newLine();
            }
            if (fb.getFunctionblock().getStatus() != null && !fb.getFunctionblock().getStatus().getProperties().isEmpty()) {
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("status:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("properties:");
                _builder.newLine();
                EList _properties_3 = fb.getFunctionblock().getStatus().getProperties();
                for (Property statusProperty : _properties_3) {
                    boolean _tripleNotEquals_6;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    String _name_45 = statusProperty.getName();
                    _builder.append(_name_45, "            ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    String _description_4 = statusProperty.getDescription();
                    boolean bl4 = _tripleNotEquals_6 = _description_4 != null;
                    if (_tripleNotEquals_6) {
                        _builder.append("description: ");
                        String _description_5 = statusProperty.getDescription();
                        _builder.append(_description_5, "              ");
                    }
                    _builder.newLineIfNotEmpty();
                    PropertyType _type_4 = statusProperty.getType();
                    if (_type_4 instanceof PrimitivePropertyType) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        PropertyType _type_5 = statusProperty.getType();
                        CharSequence _wrapIfMultiple_6 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_5).getType()).toString(), statusProperty.isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_6, "              ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_2 = statusProperty.getConstraintRule();
                        boolean _tripleNotEquals_7 = _constraintRule_2 != null;
                        if (!_tripleNotEquals_7) continue;
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        CharSequence _handleConstraints_2 = this.handleConstraints(statusProperty.getConstraintRule());
                        _builder.append((Object)_handleConstraints_2, "              ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_6 = statusProperty.getType();
                    if (!(_type_6 instanceof ObjectPropertyType)) continue;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    PropertyType _type_7 = statusProperty.getType();
                    String _name_46 = ((ObjectPropertyType)_type_7).getType().getName();
                    String _plus_6 = "$ref: '#/components/schemas/" + _name_46;
                    String _plus_7 = _plus_6 + "'";
                    CharSequence _wrapIfMultiple_7 = this.wrapIfMultiple(_plus_7, statusProperty.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_7, "              ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                CharSequence _calculateRequired = Utils.calculateRequired((List<Property>)fb.getFunctionblock().getStatus().getProperties());
                _builder.append((Object)_calculateRequired, "          ");
                _builder.newLineIfNotEmpty();
            }
            if (fb.getFunctionblock().getConfiguration() != null && !fb.getFunctionblock().getConfiguration().getProperties().isEmpty()) {
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("configuration:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("properties:");
                _builder.newLine();
                EList _properties_4 = fb.getFunctionblock().getConfiguration().getProperties();
                for (Property configProperty : _properties_4) {
                    boolean _tripleNotEquals_8;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    String _name_47 = configProperty.getName();
                    _builder.append(_name_47, "            ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    String _description_6 = configProperty.getDescription();
                    boolean bl5 = _tripleNotEquals_8 = _description_6 != null;
                    if (_tripleNotEquals_8) {
                        _builder.append("description: ");
                        String _description_7 = configProperty.getDescription();
                        _builder.append(_description_7, "              ");
                    }
                    _builder.newLineIfNotEmpty();
                    PropertyType _type_8 = configProperty.getType();
                    if (_type_8 instanceof PrimitivePropertyType) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        PropertyType _type_9 = configProperty.getType();
                        CharSequence _wrapIfMultiple_8 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_9).getType()).toString(), configProperty.isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_8, "              ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_3 = configProperty.getConstraintRule();
                        boolean _tripleNotEquals_9 = _constraintRule_3 != null;
                        if (!_tripleNotEquals_9) continue;
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        CharSequence _handleConstraints_3 = this.handleConstraints(configProperty.getConstraintRule());
                        _builder.append((Object)_handleConstraints_3, "              ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_10 = configProperty.getType();
                    if (!(_type_10 instanceof ObjectPropertyType)) continue;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    PropertyType _type_11 = configProperty.getType();
                    String _name_48 = ((ObjectPropertyType)_type_11).getType().getName();
                    String _plus_8 = "$ref: '#/components/schemas/" + _name_48;
                    String _plus_9 = _plus_8 + "'";
                    CharSequence _wrapIfMultiple_9 = this.wrapIfMultiple(_plus_9, configProperty.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_9, "              ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                CharSequence _calculateRequired_1 = Utils.calculateRequired((List<Property>)fb.getFunctionblock().getConfiguration().getProperties());
                _builder.append((Object)_calculateRequired_1, "          ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            String _name_49 = fb.getName();
            _builder.append(_name_49, "    ");
            _builder.append("Feature:");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("type: object");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("properties:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("definition:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("      ");
            _builder.append("$ref: '#/components/schemas/FeatureDefinition'");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("      ");
            _builder.append("description: The Definition of this ");
            String _name_50 = fb.getName();
            _builder.append(_name_50, "          ");
            _builder.append(" Feature");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("properties:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("      ");
            _builder.append("$ref: '#/components/schemas/");
            String _name_51 = fb.getName();
            _builder.append(_name_51, "          ");
            _builder.append("Properties'");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("      ");
            _builder.append("description: The Properties of this ");
            String _name_52 = fb.getName();
            _builder.append(_name_52, "          ");
            _builder.append(" feature");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        String _name_53 = infomodel.getName();
        _builder.append(_name_53, "    ");
        _builder.append("Features:");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("type: object");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("List all Features of the ");
        String _name_54 = infomodel.getName();
        _builder.append(_name_54, "        ");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("properties:");
        _builder.newLine();
        EList _properties_5 = infomodel.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_5) {
            boolean _tripleNotEquals_10;
            _builder.append("        ");
            String _name_55 = fbProperty_1.getName();
            _builder.append(_name_55, "        ");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("  ");
            String _description_8 = fbProperty_1.getDescription();
            boolean bl = _tripleNotEquals_10 = _description_8 != null;
            if (_tripleNotEquals_10) {
                _builder.append("description: ");
                String _description_9 = fbProperty_1.getDescription();
                _builder.append(_description_9, "          ");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("  ");
            _builder.append("allOf:");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/schemas/");
            String _name_56 = fbProperty_1.getType().getName();
            _builder.append(_name_56, "            ");
            _builder.append("Feature'");
            _builder.newLineIfNotEmpty();
        }
        Set<Entity> _referencedEntities = Utils.getReferencedEntities(infomodel);
        for (Entity entity : _referencedEntities) {
            _builder.append("    ");
            String _name_57 = entity.getName();
            _builder.append(_name_57, "    ");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("type: object");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("properties:");
            _builder.newLine();
            EList _properties_6 = entity.getProperties();
            for (Object property : _properties_6) {
                boolean _tripleNotEquals_11;
                _builder.append("    ");
                _builder.append("    ");
                String _name_58 = property.getName();
                _builder.append(_name_58, "        ");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                String _description_10 = property.getDescription();
                boolean bl = _tripleNotEquals_11 = _description_10 != null;
                if (_tripleNotEquals_11) {
                    _builder.append("description: ");
                    String _description_11 = property.getDescription();
                    _builder.append(_description_11, "          ");
                }
                _builder.newLineIfNotEmpty();
                PropertyType _type_12 = property.getType();
                if (_type_12 instanceof PrimitivePropertyType) {
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    PropertyType _type_13 = property.getType();
                    CharSequence _wrapIfMultiple_10 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_13).getType()).toString(), property.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_10, "          ");
                    _builder.newLineIfNotEmpty();
                    ConstraintRule _constraintRule_4 = property.getConstraintRule();
                    boolean _tripleNotEquals_12 = _constraintRule_4 != null;
                    if (!_tripleNotEquals_12) continue;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    CharSequence _handleConstraints_4 = this.handleConstraints(property.getConstraintRule());
                    _builder.append((Object)_handleConstraints_4, "          ");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                PropertyType _type_14 = property.getType();
                if (!(_type_14 instanceof ObjectPropertyType)) continue;
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                PropertyType _type_15 = property.getType();
                String _name_59 = ((ObjectPropertyType)_type_15).getType().getName();
                String _plus_10 = "$ref: '#/components/schemas/" + (String)_name_59;
                String _plus_11 = _plus_10 + "'";
                CharSequence _wrapIfMultiple_11 = this.wrapIfMultiple(_plus_11, property.isMultiplicity());
                _builder.append((Object)_wrapIfMultiple_11, "          ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            _builder.append("  ");
            CharSequence _calculateRequired_2 = Utils.calculateRequired((List<Property>)entity.getProperties());
            _builder.append((Object)_calculateRequired_2, "      ");
            _builder.newLineIfNotEmpty();
        }
        EList<Enum> _referencedEnums = Utils.getReferencedEnums(infomodel);
        for (Enum enumeration : _referencedEnums) {
            Object property;
            _builder.append("    ");
            String _name_60 = enumeration.getName();
            _builder.append(_name_60, "    ");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("type: string");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("enum: [");
            Iterator _enums = enumeration.getEnums();
            boolean _hasElements = false;
            property = _enums.iterator();
            while (property.hasNext()) {
                EnumLiteral literal = (EnumLiteral)property.next();
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "      ");
                }
                String _name_61 = literal.getName();
                _builder.append(_name_61, "      ");
            }
            _builder.append("]");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("  ");
        _builder.newLine();
        _builder.append("  ");
        boolean _hasRequestBodiesContent = this.hasRequestBodiesContent(infomodel);
        if (_hasRequestBodiesContent) {
            _builder.append("requestBodies:");
        }
        _builder.newLineIfNotEmpty();
        EList<FunctionblockModel> _referencedFunctionBlocks_1 = Utils.getReferencedFunctionBlocks(infomodel);
        for (FunctionblockModel fb_1 : _referencedFunctionBlocks_1) {
            boolean _tripleNotEquals_15;
            EList _events_1 = fb_1.getFunctionblock().getEvents();
            for (Event event_1 : _events_1) {
                boolean _isEmpty_3 = event_1.getProperties().isEmpty();
                boolean _not_3 = !_isEmpty_3;
                if (!_not_3) continue;
                _builder.append("    ");
                String _name_62 = fb_1.getName();
                _builder.append(_name_62, "    ");
                String _firstUpper_5 = StringExtensions.toFirstUpper((String)event_1.getName());
                _builder.append(_firstUpper_5, "    ");
                _builder.append("EventPayload:");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("      ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("properties:");
                _builder.newLine();
                EList _properties_7 = event_1.getProperties();
                for (Property eventProperty : _properties_7) {
                    boolean _tripleNotEquals_13;
                    _builder.append("    ");
                    _builder.append("          ");
                    String _name_63 = eventProperty.getName();
                    _builder.append(_name_63, "              ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("          ");
                    _builder.append("  ");
                    String _description_12 = eventProperty.getDescription();
                    boolean bl = _tripleNotEquals_13 = _description_12 != null;
                    if (_tripleNotEquals_13) {
                        _builder.append("description: ");
                        String _description_13 = eventProperty.getDescription();
                        _builder.append(_description_13, "                ");
                    }
                    _builder.newLineIfNotEmpty();
                    PropertyType _type_16 = eventProperty.getType();
                    if (_type_16 instanceof PrimitivePropertyType) {
                        _builder.append("    ");
                        _builder.append("          ");
                        _builder.append("  ");
                        PropertyType _type_17 = eventProperty.getType();
                        CharSequence _wrapIfMultiple_12 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_17).getType()).toString(), eventProperty.isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_12, "                ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_5 = eventProperty.getConstraintRule();
                        boolean _tripleNotEquals_14 = _constraintRule_5 != null;
                        if (!_tripleNotEquals_14) continue;
                        _builder.append("    ");
                        _builder.append("          ");
                        _builder.append("  ");
                        CharSequence _handleConstraints_5 = this.handleConstraints(eventProperty.getConstraintRule());
                        _builder.append((Object)_handleConstraints_5, "                ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_18 = eventProperty.getType();
                    if (!(_type_18 instanceof ObjectPropertyType)) continue;
                    _builder.append("    ");
                    _builder.append("          ");
                    _builder.append("  ");
                    PropertyType _type_19 = eventProperty.getType();
                    String _name_64 = ((ObjectPropertyType)_type_19).getType().getName();
                    String _plus_12 = "$ref: '#/components/schemas/" + _name_64;
                    String _plus_13 = _plus_12 + "'";
                    CharSequence _wrapIfMultiple_13 = this.wrapIfMultiple(_plus_13, eventProperty.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_13, "                ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("        ");
                CharSequence _calculateRequired_3 = Utils.calculateRequired((List<Property>)event_1.getProperties());
                _builder.append((Object)_calculateRequired_3, "            ");
                _builder.newLineIfNotEmpty();
            }
            Configuration _configuration_1 = fb_1.getFunctionblock().getConfiguration();
            boolean bl = _tripleNotEquals_15 = _configuration_1 != null;
            if (_tripleNotEquals_15) {
                EList _properties_8 = fb_1.getFunctionblock().getConfiguration().getProperties();
                for (Property configurationProperty_2 : _properties_8) {
                    _builder.append("    ");
                    String _name_65 = fb_1.getName();
                    _builder.append(_name_65, "    ");
                    String _firstUpper_6 = StringExtensions.toFirstUpper((String)configurationProperty_2.getName());
                    _builder.append(_firstUpper_6, "    ");
                    _builder.append("ConfigurationValue:");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("  ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("    ");
                    _builder.append("      ");
                    _builder.append("schema:");
                    _builder.newLine();
                    PropertyType _type_20 = configurationProperty_2.getType();
                    if (_type_20 instanceof PrimitivePropertyType) {
                        _builder.append("    ");
                        _builder.append("        ");
                        PropertyType _type_21 = configurationProperty_2.getType();
                        CharSequence _wrapIfMultiple_14 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_21).getType()).toString(), configurationProperty_2.isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_14, "            ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_6 = configurationProperty_2.getConstraintRule();
                        boolean _tripleNotEquals_16 = _constraintRule_6 != null;
                        if (!_tripleNotEquals_16) continue;
                        _builder.append("    ");
                        _builder.append("        ");
                        CharSequence _handleConstraints_6 = this.handleConstraints(configurationProperty_2.getConstraintRule());
                        _builder.append((Object)_handleConstraints_6, "            ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_22 = configurationProperty_2.getType();
                    if (!(_type_22 instanceof ObjectPropertyType)) continue;
                    _builder.append("    ");
                    _builder.append("        ");
                    PropertyType _type_23 = configurationProperty_2.getType();
                    String _name_66 = ((ObjectPropertyType)_type_23).getType().getName();
                    String _plus_14 = "$ref: '#/components/schemas/" + _name_66;
                    String _plus_15 = _plus_14 + "'";
                    CharSequence _wrapIfMultiple_15 = this.wrapIfMultiple(_plus_15, configurationProperty_2.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_15, "            ");
                    _builder.newLineIfNotEmpty();
                }
            }
            EList _operations_2 = fb_1.getFunctionblock().getOperations();
            for (Operation operation_2 : _operations_2) {
                boolean _isEmpty_4 = operation_2.getParams().isEmpty();
                boolean _not_4 = !_isEmpty_4;
                if (!_not_4) continue;
                _builder.append("    ");
                String _name_67 = fb_1.getName();
                _builder.append(_name_67, "    ");
                String _firstUpper_7 = StringExtensions.toFirstUpper((String)operation_2.getName());
                _builder.append(_firstUpper_7, "    ");
                _builder.append("Payload:");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("      ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("properties:");
                _builder.newLine();
                EList _params_1 = operation_2.getParams();
                for (Param param_1 : _params_1) {
                    boolean _tripleNotEquals_17;
                    _builder.append("    ");
                    _builder.append("          ");
                    String _name_68 = param_1.getName();
                    _builder.append(_name_68, "              ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("          ");
                    _builder.append("  ");
                    String _description_14 = param_1.getDescription();
                    boolean bl6 = _tripleNotEquals_17 = _description_14 != null;
                    if (_tripleNotEquals_17) {
                        _builder.append("description: ");
                        String _description_15 = param_1.getDescription();
                        _builder.append(_description_15, "                ");
                    }
                    _builder.newLineIfNotEmpty();
                    if (param_1 instanceof PrimitiveParam) {
                        _builder.append("    ");
                        _builder.append("          ");
                        _builder.append("  ");
                        CharSequence _wrapIfMultiple_16 = this.wrapIfMultiple(this.getPrimitive(((PrimitiveParam)param_1).getType()).toString(), ((PrimitiveParam)param_1).isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_16, "                ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_7 = ((PrimitiveParam)param_1).getConstraintRule();
                        boolean _tripleNotEquals_18 = _constraintRule_7 != null;
                        if (!_tripleNotEquals_18) continue;
                        _builder.append("    ");
                        _builder.append("          ");
                        _builder.append("  ");
                        CharSequence _handleConstraints_7 = this.handleConstraints(((PrimitiveParam)param_1).getConstraintRule());
                        _builder.append((Object)_handleConstraints_7, "                ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    if (!(param_1 instanceof RefParam)) continue;
                    _builder.append("    ");
                    _builder.append("          ");
                    _builder.append("  ");
                    String _name_69 = ((RefParam)param_1).getType().getName();
                    String _plus_16 = "$ref: '#/components/schemas/" + _name_69;
                    String _plus_17 = _plus_16 + "'";
                    CharSequence _wrapIfMultiple_17 = this.wrapIfMultiple(_plus_17, ((RefParam)param_1).isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_17, "                ");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.append("  ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("entityTooLarge:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The created or modified entity is larger than the accepted limit of 100 kB.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("messageTooLarge:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The size of the send message is larger than the accepted limit of 250 kB.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("notModified:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The (sub-)resource has not been modified. This happens when you specified a If-None-Match header which");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("matches the current ETag of the (sub-)resource.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("headers:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("ETag:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The (current server-side) ETag for this (sub-)resource. For top-level resources it is in the format");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("\"rev:[revision]\", for sub-resources it has the format \"hash:[calculated-hash]\".");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("preconditionFailed:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("A precondition for reading or writing the (sub-)resource failed. This will happen for write requests, when you");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("specified an If-Match or If-None-Match header which fails the precondition check against the current ETag of");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("the (sub-)resource. For read requests, this error may only happen for a failing If-Match header. In case of a");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("failing If-None-Match header for a read request, status 304 will be returned instead.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("headers:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("ETag:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: >-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The (current server-side) ETag for this (sub-)resource. For top-level resources it is in the format");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("\"rev:[revision]\", for sub-resources it has the format \"hash:[calculated-hash]\".");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("parameters:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("messageTimeoutParam:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: timeout");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: query");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Contains an optional timeout (in seconds) of how long to wait for the message response and therefore block the");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("HTTP request. Default value (if omitted): 10 seconds. Maximum value: 60 seconds. A value of 0 seconds applies");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("fire and forget semantics for the message.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: false");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: integer");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("thingIdPathParam:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: thingId");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: path");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The ID of the Thing - has to:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* contain the mandatory namespace prefix (java package notation + `:` colon)");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* conform to RFC-2396 (URI)");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: true");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("securitySchemes:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("bearerAuth:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("type: http");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("scheme: bearer");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("bearerFormat: JWT");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("A JSON Web Token issued by a supported OAuth 2.0 Identity Provider.");
        _builder.newLine();
        return _builder.toString();
    }

    public boolean hasRequestBodiesContent(InformationModel infomodel) {
        boolean flag = false;
        EList<FunctionblockModel> _referencedFunctionBlocks = Utils.getReferencedFunctionBlocks(infomodel);
        for (FunctionblockModel fb : _referencedFunctionBlocks) {
            EList _events = fb.getFunctionblock().getEvents();
            for (Event event : _events) {
                boolean _isEmpty = event.getProperties().isEmpty();
                boolean _not = !_isEmpty;
                if (!_not) continue;
                flag = true;
            }
            if (fb.getFunctionblock().getConfiguration() != null && !fb.getFunctionblock().getConfiguration().getProperties().isEmpty()) {
                flag = true;
            }
            EList _operations = fb.getFunctionblock().getOperations();
            for (Operation operation : _operations) {
                boolean _isEmpty_1 = operation.getParams().isEmpty();
                boolean _not_1 = !_isEmpty_1;
                if (!_not_1) continue;
                flag = true;
            }
        }
        return flag;
    }

    public CharSequence handleConstraints(ConstraintRule rule) {
        StringConcatenation _builder = new StringConcatenation();
        EList _constraints = rule.getConstraints();
        for (Constraint constraint : _constraints) {
            String _constraint = this.getConstraint(constraint.getType());
            _builder.append(_constraint);
            String _constraintValues = constraint.getConstraintValues();
            _builder.append(_constraintValues);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence wrapIfMultiple(String type, boolean isArray) {
        StringConcatenation _builder = new StringConcatenation();
        if (isArray) {
            _builder.append("type: array");
            _builder.newLine();
            _builder.append("items:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append(type, "  ");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(type);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence getPrimitive(PrimitiveType primitiveType) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _equals = Objects.equal((Object)primitiveType, (Object)PrimitiveType.BASE64_BINARY);
        if (_equals) {
            _builder.append("type: string");
            _builder.newLine();
        } else {
            boolean _equals_1 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.BOOLEAN);
            if (_equals_1) {
                _builder.append("type: boolean");
                _builder.newLine();
            } else {
                boolean _equals_2 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.BYTE);
                if (_equals_2) {
                    _builder.append("type: string");
                    _builder.newLine();
                } else {
                    boolean _equals_3 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.DATETIME);
                    if (_equals_3) {
                        _builder.append("type: string");
                        _builder.newLine();
                    } else {
                        boolean _equals_4 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.DOUBLE);
                        if (_equals_4) {
                            _builder.append("type: number");
                            _builder.newLine();
                        } else {
                            boolean _equals_5 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.FLOAT);
                            if (_equals_5) {
                                _builder.append("type: number");
                                _builder.newLine();
                            } else {
                                boolean _equals_6 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.INT);
                                if (_equals_6) {
                                    _builder.append("type: integer");
                                    _builder.newLine();
                                } else {
                                    boolean _equals_7 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.LONG);
                                    if (_equals_7) {
                                        _builder.append("type: number");
                                        _builder.newLine();
                                    } else {
                                        boolean _equals_8 = Objects.equal((Object)primitiveType, (Object)PrimitiveType.SHORT);
                                        if (_equals_8) {
                                            _builder.append("type: integer");
                                            _builder.newLine();
                                        } else {
                                            _builder.append("type: string");
                                            _builder.newLine();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return _builder;
    }

    public String getConstraint(ConstraintIntervalType type) {
        boolean _equals = Objects.equal((Object)type, (Object)ConstraintIntervalType.STRLEN);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("maxLength: ");
            return _builder.toString();
        }
        boolean _equals_1 = Objects.equal((Object)type, (Object)ConstraintIntervalType.REGEX);
        if (_equals_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("pattern: ");
            return _builder_1.toString();
        }
        boolean _equals_2 = Objects.equal((Object)type, (Object)ConstraintIntervalType.MIN);
        if (_equals_2) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("minimum: ");
            return _builder_2.toString();
        }
        boolean _equals_3 = Objects.equal((Object)type, (Object)ConstraintIntervalType.MAX);
        if (_equals_3) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("maximum: ");
            return _builder_3.toString();
        }
        boolean _equals_4 = Objects.equal((Object)type, (Object)ConstraintIntervalType.SCALING);
        if (_equals_4) {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("multipleOf: ");
            return _builder_4.toString();
        }
        boolean _equals_5 = Objects.equal((Object)type, (Object)ConstraintIntervalType.DEFAULT);
        if (_equals_5) {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("default: ");
            return _builder_5.toString();
        }
        return null;
    }
}

