/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.InnerFunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReferenceResolver;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typing.IJvmTypeReferenceProvider;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.util.AbstractXtypeReferenceVisitor;

public class LightweightTypeReferenceFactory
extends AbstractXtypeReferenceVisitor<LightweightTypeReference> {
    private final ITypeReferenceOwner owner;
    private final boolean keepUnboundWildcards;

    public LightweightTypeReferenceFactory(ITypeReferenceOwner owner) {
        this(owner, false);
    }

    public LightweightTypeReferenceFactory(ITypeReferenceOwner owner, boolean keepUnboundWildcards) {
        this.keepUnboundWildcards = keepUnboundWildcards;
        this.owner = Preconditions.checkNotNull(owner, "owner");
    }

    public ITypeReferenceOwner getOwner() {
        return this.owner;
    }

    public LightweightTypeReference toLightweightReference(JvmTypeReference reference) {
        return (LightweightTypeReference)this.visit(reference);
    }

    public LightweightTypeReference toLightweightReference(JvmType type) {
        if (type.eClass() == TypesPackage.Literals.JVM_ARRAY_TYPE) {
            JvmComponentType componentType = ((JvmArrayType)type).getComponentType();
            LightweightTypeReference componentTypeReference = this.toLightweightReference(componentType);
            return this.owner.newArrayTypeReference(componentTypeReference);
        }
        ParameterizedTypeReference result = this.owner.newParameterizedTypeReference(type);
        if (type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            result.accept(new TypeReferenceVisitor(){

                @Override
                protected void doVisitInnerTypeReference(InnerTypeReference reference) {
                    reference.getOuter().accept(this);
                    super.doVisitInnerTypeReference(reference);
                }

                @Override
                protected void doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
                    JvmType rawType = reference.getType();
                    if (rawType.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
                        EList<JvmTypeParameter> typeParameters = ((JvmTypeParameterDeclarator)((Object)rawType)).getTypeParameters();
                        int size = typeParameters.size();
                        for (int i = 0; i < size; ++i) {
                            JvmTypeParameter typeParameter = (JvmTypeParameter)typeParameters.get(i);
                            reference.addTypeArgument(LightweightTypeReferenceFactory.this.owner.newParameterizedTypeReference(typeParameter));
                        }
                    }
                }
            });
        }
        return result;
    }

    public LightweightTypeReference toPlainTypeReference(JvmType type) {
        if (type.eClass() == TypesPackage.Literals.JVM_ARRAY_TYPE) {
            JvmComponentType componentType = ((JvmArrayType)type).getComponentType();
            LightweightTypeReference componentTypeReference = this.toPlainTypeReference(componentType);
            return this.owner.newArrayTypeReference(componentTypeReference);
        }
        return this.owner.newParameterizedTypeReference(type);
    }

    @Override
    public LightweightTypeReference doVisitAnyTypeReference(JvmAnyTypeReference reference) {
        return this.owner.newAnyTypeReference();
    }

    @Override
    public LightweightTypeReference doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference) {
        JvmTypeReference originalComponentType = reference.getComponentType();
        LightweightTypeReference lightweightComponentType = null;
        if (originalComponentType != null) {
            lightweightComponentType = (LightweightTypeReference)this.visit(originalComponentType);
            if (lightweightComponentType.isAny()) {
                return lightweightComponentType;
            }
        } else {
            lightweightComponentType = this.getObjectReference();
        }
        return this.owner.newArrayTypeReference(lightweightComponentType);
    }

    @Override
    public LightweightTypeReference doVisitMultiTypeReference(JvmMultiTypeReference reference) {
        return this.doVisitCompoundReference(reference, false);
    }

    protected LightweightTypeReference doVisitCompoundReference(JvmCompoundTypeReference reference, boolean synonym) {
        CompoundTypeReference result = this.owner.newCompoundTypeReference(synonym);
        for (JvmTypeReference component : reference.getReferences()) {
            result.addComponent((LightweightTypeReference)this.visit(component));
        }
        return result;
    }

    @Override
    public LightweightTypeReference doVisitComputedTypeReference(XComputedTypeReference reference) {
        IJvmTypeReferenceProvider typeProvider = reference.getTypeProvider();
        if (typeProvider instanceof UnboundTypeReferenceResolver) {
            UnboundTypeReference typeReference = ((UnboundTypeReferenceResolver)typeProvider).getUnboundTypeReference();
            return typeReference.copyInto(this.owner);
        }
        JvmTypeReference equivalent = reference.getEquivalent();
        if (equivalent == null) {
            return this.owner.newUnknownTypeReference();
        }
        return (LightweightTypeReference)super.doVisitComputedTypeReference(reference);
    }

    @Override
    public LightweightTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
        JvmType type = this.getType(reference);
        if (type == null || type.eIsProxy()) {
            return this.createUnknownTypeReference(reference);
        }
        ParameterizedTypeReference result = this.owner.newParameterizedTypeReference(type);
        for (JvmTypeReference argument : reference.getArguments()) {
            result.addTypeArgument(((LightweightTypeReference)this.visit(argument)).getWrapperTypeIfPrimitive());
        }
        return result;
    }

    protected boolean isInner(JvmType type) {
        if (type != null && type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && type.eContainer() instanceof JvmDeclaredType) {
            return !((JvmGenericType)type).isStatic();
        }
        return false;
    }

    private LightweightTypeReference createUnknownTypeReference(JvmParameterizedTypeReference reference) {
        String name;
        Set<EObject> sourceElements;
        EObject firstSource;
        List<INode> nodes = NodeModelUtils.findNodesForFeature(reference, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        if (nodes.isEmpty() && (firstSource = (EObject)Iterables.getFirst(sourceElements = this.owner.getServices().getJvmModelAssociations().getSourceElements(reference), null)) instanceof JvmParameterizedTypeReference) {
            nodes = NodeModelUtils.findNodesForFeature(firstSource, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        }
        if (nodes.size() == 1 && (name = nodes.get(0).getText().trim()) != null && name.length() != 0) {
            String shortName;
            int lastDollar;
            int lastDot = name.lastIndexOf(46);
            int lastDotOrDollar = Math.max(lastDot, lastDollar = name.lastIndexOf(36));
            if (lastDotOrDollar != -1 && lastDotOrDollar != name.length() - 1 && (shortName = name.substring(lastDotOrDollar + 1)).length() != 0) {
                name = shortName;
            }
            return this.owner.newUnknownTypeReference(name);
        }
        return this.owner.newUnknownTypeReference();
    }

    @Override
    public LightweightTypeReference doVisitInnerTypeReference(JvmInnerTypeReference reference) {
        JvmType type = this.getType(reference);
        if (type == null || type.eIsProxy()) {
            return this.createUnknownTypeReference(reference);
        }
        if (!this.isInner(type)) {
            return this.doVisitParameterizedTypeReference(reference);
        }
        JvmParameterizedTypeReference outer = reference.getOuter();
        if (outer == null) {
            return this.doVisitParameterizedTypeReference(reference);
        }
        ParameterizedTypeReference lightweightOuter = (ParameterizedTypeReference)outer.accept(this);
        InnerTypeReference result = new InnerTypeReference(this.owner, lightweightOuter, type);
        for (JvmTypeReference argument : reference.getArguments()) {
            result.addTypeArgument(((LightweightTypeReference)this.visit(argument)).getWrapperTypeIfPrimitive());
        }
        return result;
    }

    protected JvmType getType(JvmTypeReference reference) {
        return reference.getType();
    }

    @Override
    public LightweightTypeReference doVisitSynonymTypeReference(JvmSynonymTypeReference reference) {
        return this.doVisitCompoundReference(reference, true);
    }

    @Override
    public LightweightTypeReference doVisitWildcardTypeReference(JvmWildcardTypeReference reference) {
        LightweightTypeReference upperBound;
        WildcardTypeReference result = this.owner.newWildcardTypeReference();
        boolean upperBoundSeen = false;
        for (JvmTypeConstraint constraint : reference.getConstraints()) {
            if (constraint.getTypeReference() == null) continue;
            if (constraint instanceof JvmUpperBound) {
                upperBoundSeen = true;
                result.addUpperBound(((LightweightTypeReference)this.visit(constraint.getTypeReference())).getWrapperTypeIfPrimitive());
                continue;
            }
            if (result.getLowerBound() != null) continue;
            result.setLowerBound(((LightweightTypeReference)this.visit(constraint.getTypeReference())).getWrapperTypeIfPrimitive());
        }
        if (!this.keepUnboundWildcards) {
            if (!upperBoundSeen) {
                upperBound = this.getObjectReference();
                result.addUpperBound(upperBound);
            }
            if (result.getUpperBounds().isEmpty()) {
                throw new IllegalStateException("UpperBounds may not be empty");
            }
        } else if (!upperBoundSeen && result.getLowerBound() != null) {
            upperBound = this.getObjectReference();
            result.addUpperBound(upperBound);
        }
        return result;
    }

    @Override
    public LightweightTypeReference doVisitFunctionTypeReference(XFunctionTypeRef reference) {
        FunctionTypeReference result;
        JvmTypeReference equivalent = reference.getEquivalent();
        if (equivalent == null) {
            return (LightweightTypeReference)super.doVisitFunctionTypeReference(reference);
        }
        if (equivalent.eClass() == TypesPackage.Literals.JVM_INNER_TYPE_REFERENCE) {
            JvmParameterizedTypeReference outer = ((JvmInnerTypeReference)equivalent).getOuter();
            LightweightTypeReference outerEquivalent = outer.accept(this);
            result = new InnerFunctionTypeReference(this.owner, outerEquivalent, reference.getType());
        } else {
            result = new FunctionTypeReference(this.owner, reference.getType());
        }
        if (equivalent instanceof JvmParameterizedTypeReference) {
            for (JvmTypeReference argument : ((JvmParameterizedTypeReference)equivalent).getArguments()) {
                result.addTypeArgument((LightweightTypeReference)this.visit(argument));
            }
        }
        for (JvmTypeReference parameter : reference.getParamTypes()) {
            result.addParameterType((LightweightTypeReference)this.visit(parameter));
        }
        if (reference.getReturnType() != null) {
            result.setReturnType((LightweightTypeReference)this.visit(reference.getReturnType()));
        }
        return result;
    }

    @Override
    public LightweightTypeReference doVisitUnknownTypeReference(JvmUnknownTypeReference reference) {
        if (reference.eIsSet(TypesPackage.Literals.JVM_UNKNOWN_TYPE_REFERENCE__QUALIFIED_NAME)) {
            return this.owner.newUnknownTypeReference(reference.getQualifiedName());
        }
        return this.owner.newUnknownTypeReference();
    }

    @Override
    protected LightweightTypeReference handleNullReference() {
        return this.owner.newUnknownTypeReference();
    }

    protected LightweightTypeReference getObjectReference() {
        return this.owner.newReferenceToObject();
    }

    protected JvmType getObjectType() {
        return this.owner.getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)this.owner.getContextResourceSet());
    }

    @Override
    public LightweightTypeReference doVisitTypeReference(JvmTypeReference reference) {
        throw new IllegalStateException("Did not expect: " + reference);
    }
}

