/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Function;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;

public class InnerTypeReference
extends ParameterizedTypeReference {
    private final LightweightTypeReference outer;

    public InnerTypeReference(ITypeReferenceOwner owner, LightweightTypeReference outer, JvmType type) {
        super(owner, type);
        if (outer == null) {
            throw new NullPointerException("outer type may not be null");
        }
        if (outer.getKind() != 5 && outer.getKind() != 10) {
            throw new NullPointerException("outer type must be a parameterized type reference");
        }
        this.outer = outer;
    }

    @Override
    protected void checkStaticFlag(JvmDeclaredType type) {
        if (type.isStatic()) {
            throw new IllegalArgumentException("type must be an inner class");
        }
    }

    @Override
    public int getKind() {
        return 10;
    }

    @Override
    public LightweightTypeReference getOuter() {
        return this.outer;
    }

    @Override
    public boolean hasTypeArguments() {
        return this.outer.hasTypeArguments() || super.hasTypeArguments();
    }

    @Override
    public boolean isResolved() {
        return super.isResolved() && this.outer.isResolved();
    }

    @Override
    public LightweightTypeReference getRawTypeReference() {
        if (this.isRawType()) {
            return this;
        }
        LightweightTypeReference rawOuter = this.outer.getRawTypeReference();
        JvmType type = this.getType();
        if (type.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            return this.getOwner().newParameterizedTypeReference(rawOuter, type);
        }
        return this.getServices().getRawTypeHelper().getRawTypeReference(this, this.getOwner().getContextResourceSet());
    }

    @Override
    public JvmTypeReference toTypeReference() {
        JvmInnerTypeReference result = this.getTypesFactory().createJvmInnerTypeReference();
        result.setType(this.getType());
        result.setOuter((JvmParameterizedTypeReference)this.outer.toTypeReference());
        for (LightweightTypeReference typeArgument : this.getTypeArguments()) {
            result.getArguments().add(typeArgument.toTypeReference());
        }
        return result;
    }

    @Override
    public JvmTypeReference toJavaCompliantTypeReference(IVisibilityHelper visibilityHelper) {
        if (this.isTypeVisible(visibilityHelper)) {
            JvmInnerTypeReference result = this.getTypesFactory().createJvmInnerTypeReference();
            result.setType(this.getType());
            result.setOuter((JvmParameterizedTypeReference)this.outer.toJavaCompliantTypeReference());
            for (LightweightTypeReference typeArgument : this.getTypeArguments()) {
                result.getArguments().add(typeArgument.toJavaCompliantTypeReference());
            }
            return result;
        }
        return this.toJavaCompliantTypeReference(this.getSuperTypes(), visibilityHelper);
    }

    @Override
    public boolean isRawType() {
        return super.isRawType() || this.outer.isRawType();
    }

    @Override
    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        if (super.isOwnedBy(owner)) {
            boolean result = this.outer.isOwnedBy(owner);
            return result;
        }
        return false;
    }

    @Override
    public boolean isVisible(IVisibilityHelper visibilityHelper) {
        if (super.isVisible(visibilityHelper)) {
            boolean result = this.outer.isVisible(visibilityHelper);
            return result;
        }
        return false;
    }

    @Override
    protected ParameterizedTypeReference doCopyInto(ITypeReferenceOwner owner) {
        LightweightTypeReference copiedOuter = this.outer.copyInto(owner);
        InnerTypeReference result = new InnerTypeReference(owner, copiedOuter, this.getType());
        this.copyTypeArguments(result, owner);
        return result;
    }

    @Override
    protected String getAsString(String type, Function<LightweightTypeReference, String> format) {
        type = format.apply(this.outer) + "$" + this.getType().getSimpleName();
        return super.getAsString(type, format);
    }

    @Override
    public void accept(TypeReferenceVisitor visitor) {
        visitor.doVisitInnerTypeReference(this);
    }

    @Override
    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        visitor.doVisitInnerTypeReference(this, param);
    }

    @Override
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        return visitor.doVisitInnerTypeReference(this);
    }

    @Override
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        return visitor.doVisitInnerTypeReference(this, param);
    }

    @Override
    public ParameterizedTypeReference toInstanceTypeReference() {
        ParameterizedTypeReference outerInstanceTypeReference = ((ParameterizedTypeReference)this.outer).toInstanceTypeReference();
        InnerTypeReference result = this.getOwner().newParameterizedTypeReference(outerInstanceTypeReference, this.getType());
        for (LightweightTypeReference typeArgument : this.getTypeArguments()) {
            result.addTypeArgument(typeArgument.getInvariantBoundSubstitute());
        }
        return result;
    }
}

