/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.AbstractStaticOrInstanceFeatureScope;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.InstanceFeatureDescriptionWithoutReceiver;
import org.eclipse.xtext.xbase.scoping.batch.StaticFeatureDescription;
import org.eclipse.xtext.xbase.scoping.batch.StaticFeatureDescriptionWithImplicitReceiver;
import org.eclipse.xtext.xbase.scoping.batch.StaticFeatureDescriptionWithSyntacticReceiver;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class StaticFeatureScope
extends AbstractStaticOrInstanceFeatureScope {
    private final TypeBucket bucket;
    private final XExpression receiver;
    private final LightweightTypeReference receiverType;

    public StaticFeatureScope(IScope parent, IFeatureScopeSession session, XAbstractFeatureCall featureCall, XExpression receiver, LightweightTypeReference receiverType, TypeBucket bucket, OperatorMapping operatorMapping) {
        super(parent, session, featureCall, operatorMapping);
        this.receiver = receiver;
        this.receiverType = receiverType;
        this.bucket = bucket;
    }

    @Override
    protected List<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        final LinkedHashSet<JvmFeature> allFeatures = Sets.newLinkedHashSet();
        this.processFeatureNames(name, new AbstractSessionBasedScope.NameAcceptor(){

            @Override
            public void accept(String simpleName, int order) {
                for (JvmType jvmType : StaticFeatureScope.this.bucket.getTypes()) {
                    if (!(jvmType instanceof JvmDeclaredType)) continue;
                    List<JvmFeature> features = StaticFeatureScope.this.findAllFeaturesByName(jvmType, simpleName, StaticFeatureScope.this.bucket.getResolvedFeaturesProvider());
                    if (order == 1) {
                        allFeatures.addAll(features);
                        continue;
                    }
                    int size = features.size();
                    for (int i = 0; i < size; ++i) {
                        JvmFeature feature = features.get(i);
                        if (feature.eClass() != TypesPackage.Literals.JVM_OPERATION) continue;
                        allFeatures.add(feature);
                    }
                }
            }
        });
        if (allFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IEObjectDescription> allDescriptions = Lists.newArrayListWithCapacity(allFeatures.size());
        for (JvmFeature feature : allFeatures) {
            this.addDescription(name, feature, allDescriptions);
        }
        return allDescriptions;
    }

    @Override
    protected void addDescription(QualifiedName name, JvmFeature feature, List<IEObjectDescription> result) {
        if (feature.isStatic()) {
            this.addToList(this.createDescription(name, feature, this.bucket), result);
        } else if (this.receiver == null && this.receiverType == null) {
            this.addToList(this.createInstanceDescription(name, feature, this.bucket), result);
        }
    }

    protected IEObjectDescription createDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        if (this.receiver != null) {
            return new StaticFeatureDescriptionWithSyntacticReceiver(name, feature, this.receiver, this.receiverType, bucket.getId(), this.getSession().isVisible(feature));
        }
        if (this.receiverType != null) {
            return new StaticFeatureDescriptionWithImplicitReceiver(name, feature, this.receiverType, bucket.getId(), this.getSession().isVisible(feature));
        }
        return new StaticFeatureDescription(name, feature, bucket.getId(), this.getSession().isVisible(feature));
    }

    protected IEObjectDescription createInstanceDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        return new InstanceFeatureDescriptionWithoutReceiver(name, feature, bucket.getId(), this.getSession().isVisible(feature));
    }

    @Override
    protected List<IEObjectDescription> getAllLocalElements() {
        LinkedHashSet<JvmFeature> allFeatures = Sets.newLinkedHashSet();
        for (JvmType jvmType : this.bucket.getTypes()) {
            if (!(jvmType instanceof JvmDeclaredType)) continue;
            Iterable<JvmFeature> features = ((JvmDeclaredType)jvmType).getAllFeatures();
            Iterables.addAll(allFeatures, features);
        }
        if (allFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IEObjectDescription> allDescriptions = Lists.newArrayListWithCapacity(allFeatures.size());
        for (JvmFeature feature : allFeatures) {
            if (!feature.isStatic() && (this.receiver != null || this.receiverType != null)) continue;
            this.addDescriptions(feature, allDescriptions);
        }
        return allDescriptions;
    }

    protected LightweightTypeReference getReceiverType() {
        return this.receiverType;
    }

    protected XExpression getReceiver() {
        return this.receiver;
    }

    protected TypeBucket getBucket() {
        return this.bucket;
    }
}

