/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedExecutableScope;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

public abstract class AbstractStaticImportsScope
extends AbstractSessionBasedExecutableScope {
    public AbstractStaticImportsScope(IScope parent, IFeatureScopeSession session, XAbstractFeatureCall context, OperatorMapping operatorMapping) {
        super(parent, session, context, operatorMapping);
    }

    @Override
    protected List<IEObjectDescription> getAllLocalElements() {
        List<TypeBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IEObjectDescription> result = Lists.newArrayList();
        for (TypeBucket bucket : buckets) {
            this.getAllLocalElements(bucket, result);
        }
        return result;
    }

    protected void getAllLocalElements(TypeBucket bucket, List<IEObjectDescription> result) {
        if (bucket.isRestrictingNames()) {
            for (Map.Entry<? extends JvmType, ? extends Set<String>> entry : bucket.getTypesToNames().entrySet()) {
                JvmType type = entry.getKey();
                if (!(type instanceof JvmDeclaredType)) continue;
                this.getAllLocalElements(bucket, (JvmDeclaredType)type, entry.getValue(), result);
            }
        } else {
            for (JvmType jvmType : bucket.getTypes()) {
                if (!(jvmType instanceof JvmDeclaredType)) continue;
                this.getAllLocalElements(bucket, (JvmDeclaredType)jvmType, result);
            }
        }
    }

    protected void getAllLocalElements(TypeBucket bucket, JvmDeclaredType type, List<IEObjectDescription> result) {
        Iterable<JvmFeature> features = type.getAllFeatures();
        for (JvmFeature feature : features) {
            if (!feature.isStatic()) continue;
            this.addDescriptions(feature, bucket, result);
        }
    }

    protected void getAllLocalElements(TypeBucket bucket, JvmDeclaredType type, Set<String> restrictedNames, List<IEObjectDescription> result) {
        Iterable<JvmFeature> features = type.getAllFeatures();
        for (JvmFeature feature : features) {
            if (!feature.isStatic() || !restrictedNames.contains(feature.getSimpleName())) continue;
            this.addDescriptions(feature, bucket, result);
        }
    }

    protected void addDescriptions(JvmFeature feature, TypeBucket bucket, List<IEObjectDescription> result) {
        String simpleName = feature.getSimpleName();
        BucketedEObjectDescription description = this.createDescription(QualifiedName.create(simpleName), feature, bucket);
        if (description != null) {
            this.addToList(description, result);
            String propertyName = this.toProperty(simpleName, feature);
            if (propertyName != null) {
                this.addToList(this.createDescription(QualifiedName.create(propertyName), feature, bucket), result);
            }
        }
    }

    protected abstract List<TypeBucket> getBuckets();

    @Override
    protected List<IEObjectDescription> getLocalElementsByName(final QualifiedName name) {
        final List<TypeBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        final ArrayList<IEObjectDescription> result = Lists.newArrayList();
        this.processFeatureNames(name, new AbstractSessionBasedScope.NameAcceptor(){

            @Override
            public void accept(String simpleName, int order) {
                for (TypeBucket bucket : buckets) {
                    if (bucket.isRestrictingNames()) {
                        for (Map.Entry entry : bucket.getTypesToNames().entrySet()) {
                            if (!((Set)entry.getValue()).contains(simpleName)) continue;
                            this.processType((JvmType)entry.getKey(), simpleName, order, bucket);
                        }
                        continue;
                    }
                    for (JvmType jvmType : bucket.getTypes()) {
                        this.processType(jvmType, simpleName, order, bucket);
                    }
                }
            }

            protected void processType(JvmType type, String simpleName, int order, TypeBucket bucket) {
                if (type instanceof JvmDeclaredType) {
                    List<JvmFeature> features = AbstractStaticImportsScope.this.findAllFeaturesByName(type, simpleName, bucket.getResolvedFeaturesProvider());
                    int size = features.size();
                    for (int i = 0; i < size; ++i) {
                        BucketedEObjectDescription description;
                        JvmFeature feature = features.get(i);
                        if (!feature.isStatic() || order != 1 && !(feature instanceof JvmOperation) || (description = AbstractStaticImportsScope.this.createDescription(name, feature, bucket)) == null) continue;
                        AbstractStaticImportsScope.this.addToList(description, (List<IEObjectDescription>)result);
                    }
                }
            }
        });
        return result;
    }

    protected abstract BucketedEObjectDescription createDescription(QualifiedName var1, JvmFeature var2, TypeBucket var3);
}

