/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.scoping.AbstractNestedTypeAwareImportNormalizer;

public class NestedTypeAwareImportNormalizerWithDotSeparator
extends AbstractNestedTypeAwareImportNormalizer {
    public NestedTypeAwareImportNormalizerWithDotSeparator(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        super(importedNamespace, wildcard, ignoreCase);
    }

    @Override
    public QualifiedName deresolve(QualifiedName fullyQualifiedName) {
        if (this.hasWildCard()) {
            if (fullyQualifiedName.startsWith(this.getImportedNamespacePrefix()) && fullyQualifiedName.getSegmentCount() != this.getImportedNamespacePrefix().getSegmentCount()) {
                return fullyQualifiedName.skipFirst(this.getImportedNamespacePrefix().getSegmentCount());
            }
        } else {
            QualifiedName withoutDollars;
            if (fullyQualifiedName.equals(this.getImportedNamespacePrefix())) {
                return QualifiedName.create(fullyQualifiedName.getLastSegment());
            }
            if (fullyQualifiedName.startsWith(this.getImportedNamespacePrefix())) {
                return fullyQualifiedName.skipFirst(this.getImportedNamespacePrefix().getSegmentCount() - 1);
            }
            int segmentCount = fullyQualifiedName.getSegmentCount();
            ArrayList<String> segments = Lists.newArrayListWithExpectedSize(segmentCount);
            for (int i = 0; i < segmentCount; ++i) {
                String segment = fullyQualifiedName.getSegment(i);
                segments.addAll(Strings.split(segment, '$'));
            }
            if (segments.size() > segmentCount && (withoutDollars = QualifiedName.create(segments)).startsWith(this.getImportedNamespacePrefix())) {
                return withoutDollars.skipFirst(this.getImportedNamespacePrefix().getSegmentCount() - 1);
            }
        }
        return null;
    }

    @Override
    protected QualifiedName resolveNonWildcard(QualifiedName relativeName) {
        if (relativeName.getSegmentCount() == 1) {
            List<String> split = Strings.split(relativeName.getFirstSegment(), '$');
            if (split.size() == 0) {
                return this.internalResolve(relativeName);
            }
            return this.internalResolve(QualifiedName.create(split));
        }
        StringBuilder concatenated = new StringBuilder();
        for (int i = 0; i < relativeName.getSegmentCount(); ++i) {
            String segment = relativeName.getSegment(i);
            if (segment.indexOf(36) == -1) {
                if (concatenated.length() != 0) {
                    concatenated.append('$');
                }
            } else {
                return null;
            }
            concatenated.append(segment);
        }
        return this.internalResolve(relativeName);
    }

    protected QualifiedName internalResolve(QualifiedName relativeName) {
        QualifiedName importedNamespace = this.getImportedNamespacePrefix();
        if (importedNamespace.getLastSegment().equals(relativeName.getFirstSegment())) {
            return importedNamespace.skipLast(1).append(relativeName);
        }
        return null;
    }
}

