/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.formatting.BasicFormatterPreferenceKeys;
import org.eclipse.xtext.xbase.formatting.FormattingData;
import org.eclipse.xtext.xbase.formatting.FormattingPreferenceValues;
import org.eclipse.xtext.xbase.formatting.NewLineData;
import org.eclipse.xtext.xbase.formatting.TextReplacement;
import org.eclipse.xtext.xbase.formatting.WhitespaceData;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Deprecated
public class FormattableDocument {
    private static final Logger log = Logger.getLogger(FormattableDocument.class);
    @Accessors
    private final FormattingPreferenceValues cfg;
    @Accessors
    private final String document;
    @Accessors
    private final TreeMap<Integer, FormattingData> formattings;
    @Accessors
    private Throwable rootTrace = null;
    @Accessors
    private boolean conflictOccurred = false;

    public FormattableDocument(FormattingPreferenceValues cfg, String document) {
        this.cfg = cfg;
        this.document = document;
        TreeMap _treeMap = new TreeMap();
        this.formattings = _treeMap;
    }

    public FormattableDocument(FormattableDocument fmt) {
        this.cfg = fmt.cfg;
        this.document = fmt.document;
        TreeMap<Integer, FormattingData> _treeMap = new TreeMap<Integer, FormattingData>((SortedMap<Integer, FormattingData>)fmt.formattings);
        this.formattings = _treeMap;
    }

    public boolean isDebugConflicts() {
        return this.rootTrace != null;
    }

    protected FormattingData addFormatting(FormattingData data) {
        FormattingData _xifexpression = null;
        if (data != null) {
            boolean _greaterThan;
            boolean _lessThan;
            FormattingData _xblockexpression = null;
            int _length = data.getLength();
            boolean bl = _lessThan = _length < 0;
            if (_lessThan) {
                Pair<String, String> text = this.getTextAround(data);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("lenght of text-edit can not be negative:");
                _builder.newLine();
                _builder.append("--------------------------------- document snippet ------------------------------");
                _builder.newLine();
                String _key = text.getKey();
                _builder.append(_key);
                _builder.append("[[[!!]]]");
                String _value = text.getValue();
                _builder.append(_value);
                _builder.newLineIfNotEmpty();
                _builder.append("---------------------------------------------------------------------------------");
                _builder.newLine();
                log.error(_builder);
                throw new IllegalStateException("Length of text edit can not be negative");
            }
            int _length_1 = data.getLength();
            boolean bl2 = _greaterThan = _length_1 > 0;
            if (_greaterThan) {
                boolean _not;
                int _offset = data.getOffset();
                int _length_2 = data.getLength();
                int _plus = _offset + _length_2;
                String oldText = this.document.substring(data.getOffset(), _plus);
                boolean _isWhitespace = this.isWhitespace(oldText);
                boolean bl3 = _not = !_isWhitespace;
                if (_not) {
                    Pair<String, String> text_1 = this.getTextAround(data);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Can not edit non-whitespace:");
                    _builder_1.newLine();
                    _builder_1.append("------------------------------- document snippet --------------------------------");
                    _builder_1.newLine();
                    String _key_1 = text_1.getKey();
                    _builder_1.append(_key_1);
                    _builder_1.append("[[[");
                    _builder_1.append(oldText);
                    _builder_1.append("]]]");
                    String _value_1 = text_1.getValue();
                    _builder_1.append(_value_1);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("---------------------------------------------------------------------------------");
                    _builder_1.newLine();
                    log.error(_builder_1);
                    throw new IllegalStateException("Can non format non-whitespace: " + oldText);
                }
            }
            FormattingData old = this.formattings.get(data.getOffset());
            FormattingData _xifexpression_1 = null;
            _xifexpression_1 = old == null ? data : this.merge(old, data);
            FormattingData newData = _xifexpression_1;
            FormattingData _xifexpression_2 = null;
            if (newData != null) {
                _xifexpression_2 = this.formattings.put(data.getOffset(), newData);
            }
            _xifexpression = _xblockexpression = _xifexpression_2;
        }
        return _xifexpression;
    }

    protected FormattingData merge(FormattingData data1, FormattingData data2) {
        FormattingData _xblockexpression = null;
        FormattingData old = null;
        int increaseIndentationChange = 0;
        int decreaseIndentationChange = 0;
        int indentationChange = 0;
        boolean _isEmpty = data2.isEmpty();
        if (_isEmpty) {
            int _plus;
            int _indentationChange = data1.getIndentationChange();
            int _indentationChange_1 = data2.getIndentationChange();
            indentationChange = _plus = _indentationChange + _indentationChange_1;
            old = data1;
        } else {
            boolean _isEmpty_1 = data1.isEmpty();
            if (_isEmpty_1) {
                int _plus_1;
                int _indentationChange_2 = data2.getIndentationChange();
                int _indentationChange_3 = data1.getIndentationChange();
                indentationChange = _plus_1 = _indentationChange_2 + _indentationChange_3;
                old = data2;
            }
        }
        FormattingData _xifexpression = null;
        if (old != null) {
            Throwable _trace;
            int _length;
            int _offset;
            NewLineData _xblockexpression_1 = null;
            if (indentationChange > 0) {
                increaseIndentationChange = indentationChange;
            } else {
                decreaseIndentationChange = indentationChange;
            }
            FormattingData _switchResult = null;
            boolean _matched = false;
            if (old instanceof NewLineData) {
                _matched = true;
                _offset = ((NewLineData)old).getOffset();
                _length = ((NewLineData)old).getLength();
                _trace = ((NewLineData)old).getTrace();
                Integer _newLines = ((NewLineData)old).getNewLines();
                _switchResult = new NewLineData(_offset, _length, increaseIndentationChange, decreaseIndentationChange, _trace, _newLines);
            }
            if (!_matched && old instanceof WhitespaceData) {
                _matched = true;
                _offset = ((WhitespaceData)old).getOffset();
                _length = ((WhitespaceData)old).getLength();
                _trace = ((WhitespaceData)old).getTrace();
                String _space = ((WhitespaceData)old).getSpace();
                _switchResult = new WhitespaceData(_offset, _length, increaseIndentationChange, decreaseIndentationChange, _trace, _space);
            }
            _xblockexpression_1 = _switchResult;
            _xifexpression = _xblockexpression_1;
        } else {
            Object _xblockexpression_2 = null;
            this.conflictOccurred = true;
            boolean _isDebugConflicts = this.isDebugConflicts();
            if (_isDebugConflicts) {
                this.reportConflict(data1, data2);
            }
            _xblockexpression_2 = null;
            _xifexpression = _xblockexpression_2;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected Pair<String, String> getTextAround(FormattingData data1) {
        Pair<String, String> _xblockexpression = null;
        Functions.Function2<Integer, Integer, Integer> _function = (last, i) -> {
            int _xifexpression = 0;
            _xifexpression = last > 0 ? this.document.lastIndexOf("\n", last - 1) : -1;
            return _xifexpression;
        };
        Integer back = IterableExtensions.fold(new IntegerRange(0, 5), data1.getOffset(), _function);
        Functions.Function2<Integer, Integer, Integer> _function_1 = (last, i) -> {
            int _xifexpression = 0;
            _xifexpression = last > 0 ? this.document.indexOf("\n", last + 1) : -1;
            return _xifexpression;
        };
        Integer forward = IterableExtensions.fold(new IntegerRange(0, 5), data1.getOffset(), _function_1);
        Integer _xifexpression = null;
        _xifexpression = back >= 0 ? back : Integer.valueOf(0);
        Integer fiveLinesBackOffset = _xifexpression;
        Integer _xifexpression_1 = null;
        _xifexpression_1 = forward >= 0 ? forward : Integer.valueOf(this.document.length());
        Integer fiveLinesForwardOffset = _xifexpression_1;
        String prefix = this.document.substring(fiveLinesBackOffset, data1.getOffset());
        int _offset = data1.getOffset();
        int _length = data1.getLength();
        int _plus = _offset + _length;
        String postfix = this.document.substring(_plus, fiveLinesForwardOffset);
        _xblockexpression = Pair.of(prefix, postfix);
        return _xblockexpression;
    }

    protected void reportConflict(FormattingData data1, FormattingData data2) {
        Pair<String, String> text = this.getTextAround(data1);
        int _size = ((List)Conversions.doWrapArray(this.rootTrace.getStackTrace())).size();
        int traceStart = _size - 1;
        StackTraceElement[] fullTrace1 = data1.getTrace().getStackTrace();
        int _size_1 = ((List)Conversions.doWrapArray(fullTrace1)).size();
        int _minus = _size_1 - traceStart;
        String shortTrace1 = IterableExtensions.join(((List)Conversions.doWrapArray(fullTrace1)).subList(0, _minus), "\n");
        StackTraceElement[] fullTrace2 = data2.getTrace().getStackTrace();
        int _size_2 = ((List)Conversions.doWrapArray(fullTrace2)).size();
        int _minus_1 = _size_2 - traceStart;
        String shortTrace2 = IterableExtensions.join(((List)Conversions.doWrapArray(fullTrace2)).subList(0, _minus_1), "\n");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Conflicting TextEdits during formatting:");
        _builder.newLine();
        _builder.append("------------------------------- document snippet --------------------------------");
        _builder.newLine();
        String _key = text.getKey();
        _builder.append(_key);
        _builder.append("[!!!]");
        String _value = text.getValue();
        _builder.append(_value);
        _builder.newLineIfNotEmpty();
        _builder.append("---------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("TextEdit1: ");
        String _replaceAll = data1.toString().replaceAll("\\n\\s*", " ");
        _builder.append(_replaceAll);
        _builder.newLineIfNotEmpty();
        _builder.append("TextEdit2: ");
        String _replaceAll_1 = data2.toString().replaceAll("\\n\\s*", " ");
        _builder.append(_replaceAll_1);
        _builder.newLineIfNotEmpty();
        _builder.append("---------------------------------- Trace 1 --------------------------------------");
        _builder.newLine();
        _builder.append(shortTrace1);
        _builder.newLineIfNotEmpty();
        _builder.append("---------------------------------- Trace 2 --------------------------------------");
        _builder.newLine();
        _builder.append(shortTrace2);
        _builder.newLineIfNotEmpty();
        _builder.append("---------------------------------------------------------------------------------");
        _builder.newLine();
        log.error(_builder);
    }

    public FormattingData operator_add(FormattingData data) {
        return this.addFormatting(data);
    }

    public void operator_add(Iterable<FormattingData> data) {
        if (data != null) {
            Consumer<FormattingData> _function = it -> this.addFormatting((FormattingData)it);
            data.forEach(_function);
        }
    }

    public void operator_add(Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> data) {
        if (data != null) {
            this.operator_add(data.apply(this));
        }
    }

    public List<TextReplacement> renderToEdits() {
        return this.renderToEdits(0, this.document.length());
    }

    public List<TextReplacement> renderToEdits(int offset, int length) {
        ArrayList<TextReplacement> _xblockexpression = null;
        ArrayList<TextReplacement> replacements = CollectionLiterals.newArrayList();
        int oldOffset = offset;
        int indentation = 0;
        Collection<FormattingData> _values = this.formattings.values();
        for (FormattingData f : _values) {
            int _plus_1;
            int _plus;
            int _indentationChange = f.getIndentationChange();
            indentation = _plus = indentation + _indentationChange;
            if (f.getOffset() < offset || f.getOffset() + f.getLength() > offset + length) continue;
            int _offset = f.getOffset();
            int textlength = _offset - oldOffset;
            boolean _matched = false;
            if (f instanceof WhitespaceData) {
                boolean _tripleNotEquals;
                _matched = true;
                String _space = ((WhitespaceData)f).getSpace();
                boolean bl = _tripleNotEquals = _space != null;
                if (_tripleNotEquals) {
                    String replacement = ((WhitespaceData)f).getSpace();
                    int _offset_1 = ((WhitespaceData)f).getOffset();
                    int _length = ((WhitespaceData)f).getLength();
                    TextReplacement _textReplacement = new TextReplacement(_offset_1, _length, replacement);
                    replacements.add(_textReplacement);
                }
            }
            if (!_matched && f instanceof NewLineData) {
                int _decreaseIndentationChange;
                int _multiply;
                boolean _equals;
                _matched = true;
                int _xifexpression = 0;
                int _increaseIndentationChange = ((NewLineData)f).getIncreaseIndentationChange();
                boolean bl = _equals = _increaseIndentationChange == (_multiply = (_decreaseIndentationChange = ((NewLineData)f).getDecreaseIndentationChange()) * -1);
                if (_equals) {
                    int _increaseIndentationChange_1 = ((NewLineData)f).getIncreaseIndentationChange();
                    _xifexpression = indentation + _increaseIndentationChange_1;
                } else {
                    _xifexpression = indentation;
                }
                int computedIndentation = _xifexpression;
                String _wrap = this.getWrap(((NewLineData)f).getNewLines());
                String _indentation = this.getIndentation(computedIndentation);
                String replacement = _wrap + _indentation;
                int _offset_1 = ((NewLineData)f).getOffset();
                int _length = ((NewLineData)f).getLength();
                TextReplacement _textReplacement = new TextReplacement(_offset_1, _length, replacement);
                replacements.add(_textReplacement);
            }
            int _length = f.getLength();
            oldOffset = _plus_1 = textlength + _length;
        }
        _xblockexpression = replacements;
        return _xblockexpression;
    }

    public String renderToString() {
        return this.renderToString(0, this.document.length());
    }

    public String renderToString(int offset, int length) {
        String _xblockexpression = null;
        List<TextReplacement> edits = this.renderToEdits(offset, length);
        int lastOffset = offset;
        StringBuilder newDocument = new StringBuilder();
        Functions.Function1<TextReplacement, Integer> _function = it -> offset;
        List<TextReplacement> _sortBy = IterableExtensions.sortBy(edits, _function);
        for (TextReplacement edit : _sortBy) {
            int _plus;
            String text = this.document.substring(lastOffset, edit.getOffset());
            newDocument.append(text);
            newDocument.append(edit.getText());
            int _offset = edit.getOffset();
            int _length = edit.getLength();
            lastOffset = _plus = _offset + _length;
        }
        String text = this.document.substring(lastOffset, offset + length);
        newDocument.append(text);
        _xblockexpression = newDocument.toString();
        return _xblockexpression;
    }

    protected boolean isWhitespace(String doc) {
        int _length = doc.length();
        int _minus = _length - 1;
        Functions.Function1<Integer, Boolean> _function = it -> Character.isWhitespace(doc.charAt((int)it));
        return IterableExtensions.forall(new IntegerRange(0, _minus), _function);
    }

    public int lineLengthBefore(int offset) {
        int lastOffset;
        int _xblockexpression = 0;
        int currentIndentation = 0;
        FormattingData lastWrap = null;
        Collection<FormattingData> _values = this.formattings.values();
        for (FormattingData f : _values) {
            int _plus;
            int _offset = f.getOffset();
            boolean _lessThan = _offset < offset;
            if (!_lessThan) continue;
            int _indentationChange = f.getIndentationChange();
            currentIndentation = _plus = currentIndentation + _indentationChange;
            if (!(f instanceof NewLineData)) continue;
            lastWrap = (NewLineData)f;
        }
        if (lastWrap == null) {
            return offset;
        }
        int _offset_1 = lastWrap.getOffset();
        int _length = lastWrap.getLength();
        int lineStart = lastOffset = _offset_1 + _length;
        int _offset_2 = lastWrap.getOffset();
        int _plus_1 = _offset_2 + 1;
        Collection<FormattingData> _values_1 = this.formattings.subMap(_plus_1, offset).values();
        for (FormattingData f_1 : _values_1) {
            int _plus_2;
            String text = this.document.substring(lastOffset, f_1.getOffset());
            int index = text.lastIndexOf("\n");
            if (index >= 0) {
                lineStart = index + lastOffset;
                currentIndentation = 0;
            }
            int _offset_3 = f_1.getOffset();
            int _length_1 = f_1.getLength();
            lastOffset = _plus_2 = _offset_3 + _length_1;
        }
        int lengthDiff = 0;
        int _offset_3 = lastWrap.getOffset();
        int _plus_2 = _offset_3 + 1;
        Collection<FormattingData> _values_2 = this.formattings.subMap(_plus_2, offset).values();
        for (FormattingData f_2 : _values_2) {
            int _minus;
            if (!(f_2 instanceof WhitespaceData)) continue;
            String space = ((WhitespaceData)f_2).getSpace();
            int _xifexpression = 0;
            _xifexpression = space == null ? 0 : space.length();
            int length = _xifexpression;
            int _length_1 = ((WhitespaceData)f_2).getLength();
            lengthDiff = _minus = lengthDiff + length - _length_1;
        }
        int _indentationLenght = this.getIndentationLenght(currentIndentation);
        int _plus_3 = offset - lineStart + _indentationLenght;
        _xblockexpression = _plus_3 + lengthDiff;
        return _xblockexpression;
    }

    public String lookahead(int offset, int length, Procedures.Procedure1<? super FormattableDocument> format) {
        String _xblockexpression = null;
        FormattableDocument lookahead = new FormattableDocument(this);
        format.apply(lookahead);
        _xblockexpression = lookahead.renderToString(offset, length);
        return _xblockexpression;
    }

    public boolean fitsIntoLine(int offset, int length, Procedures.Procedure1<? super FormattableDocument> format) {
        int _get;
        int _length;
        String lookahead = this.lookahead(offset, length, format);
        boolean _contains = lookahead.contains("\n");
        if (_contains) {
            return false;
        }
        int _lineLengthBefore = this.lineLengthBefore(offset);
        int line = _lineLengthBefore + (_length = lookahead.length());
        return line <= (_get = this.cfg.get(BasicFormatterPreferenceKeys.maxLineWidth));
    }

    public String toString() {
        String _xblockexpression = null;
        int lastOffset = 0;
        StringBuilder debugTrace = new StringBuilder();
        List<TextReplacement> _renderToEdits = this.renderToEdits();
        for (TextReplacement edit : _renderToEdits) {
            int _plus_1;
            String text = this.document.substring(lastOffset, edit.getOffset());
            debugTrace.append(text);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("[");
            int _offset = edit.getOffset();
            int _length = edit.getLength();
            int _plus = _offset + _length;
            String _substring = this.document.substring(edit.getOffset(), _plus);
            _builder.append(_substring);
            _builder.append("|");
            String _text = edit.getText();
            _builder.append(_text);
            _builder.append("]");
            debugTrace.append(_builder);
            int _offset_1 = edit.getOffset();
            int _length_1 = edit.getLength();
            lastOffset = _plus_1 = _offset_1 + _length_1;
        }
        String text = this.document.substring(lastOffset, this.document.length());
        debugTrace.append(text);
        _xblockexpression = debugTrace.toString();
        return _xblockexpression;
    }

    public String getIndentation(int levels) {
        String _xifexpression = null;
        if (levels > 0) {
            String _xblockexpression = null;
            String indent = this.cfg.get(BasicFormatterPreferenceKeys.indentation);
            Functions.Function1<Integer, String> _function = it -> indent;
            _xifexpression = _xblockexpression = IterableExtensions.join(IterableExtensions.map(new IntegerRange(0, levels - 1), _function));
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    public int getIndentationLenght(int levels) {
        int _get = this.cfg.get(BasicFormatterPreferenceKeys.indentationLength);
        return levels * _get;
    }

    public String getWrap(int levels) {
        String _xifexpression = null;
        if (levels > 0) {
            String _xblockexpression = null;
            String sep = this.cfg.get(BasicFormatterPreferenceKeys.lineSeparator);
            Functions.Function1<Integer, String> _function = it -> sep;
            _xifexpression = _xblockexpression = IterableExtensions.join(IterableExtensions.map(new IntegerRange(0, levels - 1), _function));
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    @Pure
    public FormattingPreferenceValues getCfg() {
        return this.cfg;
    }

    @Pure
    public String getDocument() {
        return this.document;
    }

    @Pure
    public TreeMap<Integer, FormattingData> getFormattings() {
        return this.formattings;
    }

    @Pure
    public Throwable getRootTrace() {
        return this.rootTrace;
    }

    public void setRootTrace(Throwable rootTrace) {
        this.rootTrace = rootTrace;
    }

    @Pure
    public boolean isConflictOccurred() {
        return this.conflictOccurred;
    }

    public void setConflictOccurred(boolean conflictOccurred) {
        this.conflictOccurred = conflictOccurred;
    }
}

