/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.LiteralsCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.IntegerExtensions;
import org.eclipse.xtext.xbase.lib.LongExtensions;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.util.XExpressionHelper;

public class FeatureCallCompiler
extends LiteralsCompiler {
    @Inject
    private IdentifiableSimpleNameProvider featureNameProvider;
    @Inject
    private XExpressionHelper expressionHelper;
    @Inject
    private Primitives primitives;
    @Inject
    private ILogicalContainerProvider contextProvider;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    private Pattern pattern = Pattern.compile("\\$(\\$|[0-9]+)");
    @Inject
    IBatchTypeResolver batchTypeResolver;

    @Override
    protected void internalToConvertedExpression(XExpression obj, ITreeAppendable appendable) {
        if (obj instanceof XAbstractFeatureCall) {
            this._toJavaExpression((XAbstractFeatureCall)obj, appendable);
        } else {
            super.internalToConvertedExpression(obj, appendable);
        }
    }

    @Override
    protected void doInternalToJavaStatement(XExpression obj, ITreeAppendable appendable, boolean isReferenced) {
        if (obj instanceof XFeatureCall) {
            this._toJavaStatement((XFeatureCall)obj, appendable, isReferenced);
        } else if (obj instanceof XAbstractFeatureCall) {
            this._toJavaStatement((XAbstractFeatureCall)obj, appendable, isReferenced);
        } else {
            super.doInternalToJavaStatement(obj, appendable, isReferenced);
        }
    }

    protected boolean nullSafeMemberFeatureCallExpressionNeedsPreparation(XExpression argument, ITreeAppendable b) {
        if (b.hasName(argument)) {
            return false;
        }
        return !(argument instanceof JvmField) && !(argument instanceof JvmFormalParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _toJavaStatement(final XAbstractFeatureCall expr, ITreeAppendable b, boolean isReferenced) {
        if (expr.isTypeLiteral()) {
            this.generateComment(new Later(){

                @Override
                public void exec(ITreeAppendable appendable) {
                    FeatureCallCompiler.this.internalToJavaExpression(expr, appendable);
                }
            }, b, isReferenced);
        } else if (this.expressionHelper.isShortCircuitOperation(expr)) {
            XBinaryOperation binaryOperation = (XBinaryOperation)expr;
            XExpression leftOperand = binaryOperation.getLeftOperand();
            XExpression rightOperand = binaryOperation.getRightOperand();
            if (isReferenced && this.expressionHelper.isBooleanAndOrOr(expr) && this.canCompileToJavaExpression(leftOperand, b) && this.canCompileToJavaExpression(rightOperand, b)) {
                return;
            }
            this.generateShortCircuitInvocation(expr, b);
        } else if (expr instanceof XMemberFeatureCall && ((XMemberFeatureCall)expr).isNullSafe()) {
            this.compileNullSafeFeatureCall((XMemberFeatureCall)expr, b, isReferenced);
        } else {
            XExpression receiver = this.getActualReceiver(expr);
            if (receiver != null) {
                this.prepareExpression(receiver, b);
            }
            for (XExpression arg : this.getActualArguments(expr)) {
                this.prepareExpression(arg, b);
            }
            if (!isReferenced) {
                b.newLine();
                if (!this.expressionHelper.hasSideEffects(expr, false)) {
                    b.append("/* ");
                }
                try {
                    this.featureCalltoJavaExpression(expr, b, false);
                    b.append(";");
                }
                finally {
                    if (!this.expressionHelper.hasSideEffects(expr, false)) {
                        b.append(" */");
                    }
                }
            } else if (this.isVariableDeclarationRequired((XExpression)expr, b, true)) {
                Later later = new Later(){

                    @Override
                    public void exec(ITreeAppendable appendable) {
                        FeatureCallCompiler.this.featureCalltoJavaExpression(expr, appendable, true);
                    }
                };
                this.declareFreshLocalVariable(expr, b, later);
            }
        }
    }

    protected ITreeAppendable appendLeftOperand(XAbstractFeatureCall expr, ITreeAppendable appendable, boolean isExpressionContext) {
        XBinaryOperation binaryOperation = (XBinaryOperation)expr;
        XAbstractFeatureCall leftOperand = (XAbstractFeatureCall)binaryOperation.getLeftOperand();
        JvmIdentifiableElement feature = leftOperand.getFeature();
        if (appendable.hasName(feature)) {
            return appendable.append(appendable.getName(feature));
        }
        boolean hasReceiver = this.appendReceiver(leftOperand, appendable, isExpressionContext);
        if (hasReceiver) {
            appendable.append(".");
        }
        return appendable.append(feature.getSimpleName());
    }

    protected boolean needMultiAssignment(XAbstractFeatureCall expr) {
        if (expr instanceof XBinaryOperation) {
            XBinaryOperation binaryOperation = (XBinaryOperation)expr;
            return binaryOperation.isReassignFirstArgument();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileNullSafeFeatureCall(final XMemberFeatureCall expr, ITreeAppendable b, boolean isReferenced) {
        XExpression memberCallTarget = this.normalizeBlockExpression(expr.getMemberCallTarget());
        if (!isReferenced) {
            if (!this.expressionHelper.hasSideEffects(expr, false)) {
                b.append("/* ");
            }
            try {
                if (this.nullSafeMemberFeatureCallExpressionNeedsPreparation(memberCallTarget, b)) {
                    this.prepareExpression(memberCallTarget, b);
                }
                b.newLine().append("if (");
                this.internalToJavaExpression(memberCallTarget, b);
                b.append("!=null) {").increaseIndentation();
                for (XExpression arg : this.getActualArguments(expr)) {
                    if (!this.nullSafeMemberFeatureCallExpressionNeedsPreparation(arg, b)) continue;
                    this.prepareExpression(arg, b);
                }
                b.newLine();
                this.featureCalltoJavaExpression(expr, b, false);
                b.append(";");
            }
            finally {
                b.decreaseIndentation().newLine().append("}");
                if (!this.expressionHelper.hasSideEffects(expr, false)) {
                    b.append(" */");
                }
            }
        }
        if (this.isVariableDeclarationRequired(expr, b)) {
            Later later = new Later(){

                @Override
                public void exec(ITreeAppendable appendable) {
                    FeatureCallCompiler.this.appendNullValueUntyped(FeatureCallCompiler.this.getTypeForVariableDeclaration(expr), expr, appendable);
                }
            };
            if (this.nullSafeMemberFeatureCallExpressionNeedsPreparation(memberCallTarget, b)) {
                this.prepareExpression(memberCallTarget, b);
            }
            this.declareFreshLocalVariable(expr, b, later);
            b.newLine().append("if (");
            this.internalToJavaExpression(memberCallTarget, b);
            b.append("!=null) {").increaseIndentation();
            try {
                for (XExpression arg : this.getActualArguments(expr)) {
                    if (!this.nullSafeMemberFeatureCallExpressionNeedsPreparation(arg, b)) continue;
                    this.prepareExpression(arg, b);
                }
                b.newLine();
                b.append(b.getName(expr));
                b.append("=");
                this.featureCalltoJavaExpression(expr, b, true);
                b.append(";");
            }
            finally {
                b.decreaseIndentation().newLine().append("}");
            }
        }
    }

    protected XAbstractFeatureCall getFeatureCall(XExpression argument) {
        XBlockExpression blockExpression;
        EObject expr = argument.eContainer();
        if (expr instanceof XAbstractFeatureCall) {
            return (XAbstractFeatureCall)expr;
        }
        if (expr instanceof XBlockExpression && (blockExpression = (XBlockExpression)expr).getExpressions().size() == 1) {
            return this.getFeatureCall(blockExpression);
        }
        return null;
    }

    protected List<XExpression> getActualArguments(XAbstractFeatureCall expr) {
        EList<XExpression> actualArguments = expr.getActualArguments();
        return Lists.transform(actualArguments, new Function<XExpression, XExpression>(){

            @Override
            public XExpression apply(XExpression e) {
                return FeatureCallCompiler.this.normalizeBlockExpression(e);
            }
        });
    }

    protected XExpression getActualReceiver(XAbstractFeatureCall expr) {
        return expr.getActualReceiver();
    }

    protected void _toJavaStatement(XFeatureCall expr, ITreeAppendable b, boolean isReferenced) {
        if (expr.getFeature() instanceof JvmConstructor) {
            b.newLine();
            this.featureCalltoJavaExpression(expr, b, false);
            b.append(";");
        } else {
            this._toJavaStatement((XAbstractFeatureCall)expr, b, isReferenced);
        }
    }

    protected void generateShortCircuitInvocation(XAbstractFeatureCall featureCall, ITreeAppendable b) {
        XBinaryOperation binaryOperation = (XBinaryOperation)featureCall;
        XExpression leftOperand = binaryOperation.getLeftOperand();
        XExpression rightOperand = binaryOperation.getRightOperand();
        this.declareSyntheticVariable(binaryOperation, b);
        boolean isElvis = binaryOperation.getConcreteSyntaxFeatureName().equals(this.expressionHelper.getElvisOperator());
        this.prepareExpression(leftOperand, b);
        if (isElvis) {
            b.newLine().append("if (");
            this.toJavaExpression(leftOperand, b);
            b.append(" != null) {").increaseIndentation();
            b.newLine().append(b.getName(binaryOperation)).append(" = ");
            this.toJavaExpression(leftOperand, b);
            b.append(";");
        } else {
            b.newLine().append("if (");
            if (binaryOperation.getConcreteSyntaxFeatureName().equals(this.expressionHelper.getAndOperator())) {
                b.append("!");
            }
            this.toJavaExpression(leftOperand, b);
            b.append(") {").increaseIndentation();
            b.newLine().append(b.getName(binaryOperation)).append(" = ");
            b.append(Boolean.toString(binaryOperation.getConcreteSyntaxFeatureName().equals(this.expressionHelper.getOrOperator()))).append(";");
        }
        b.decreaseIndentation().newLine().append("} else {").increaseIndentation();
        if (binaryOperation.getImplicitReceiver() != null) {
            this.internalToJavaStatement(binaryOperation.getImplicitReceiver(), b, true);
        }
        this.prepareExpression(rightOperand, b);
        b.newLine().append(b.getName(binaryOperation)).append(" = ");
        this.toJavaExpression(rightOperand, b);
        b.append(";");
        b.decreaseIndentation().newLine().append("}");
    }

    @Override
    protected boolean internalCanCompileToJavaExpression(XExpression expression, ITreeAppendable appendable) {
        XBinaryOperation binaryOperation;
        if (expression instanceof XBinaryOperation && (binaryOperation = (XBinaryOperation)expression).isReassignFirstArgument()) {
            return false;
        }
        if (expression instanceof XAbstractFeatureCall) {
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)expression;
            if (this.isPrimitiveVoid(featureCall)) {
                return false;
            }
            for (XExpression arg : featureCall.getActualArguments()) {
                if (this.internalCanCompileToJavaExpression(arg, appendable)) continue;
                return false;
            }
            if (featureCall.getActualReceiver() != null && !this.internalCanCompileToJavaExpression(featureCall.getActualReceiver(), appendable)) {
                return false;
            }
            if (featureCall instanceof XMemberFeatureCall) {
                return !((XMemberFeatureCall)featureCall).isNullSafe();
            }
            return true;
        }
        if (expression instanceof XConstructorCall) {
            XConstructorCall constructorCall = (XConstructorCall)expression;
            for (XExpression arg : constructorCall.getArguments()) {
                if (this.internalCanCompileToJavaExpression(arg, appendable)) continue;
                return false;
            }
            return true;
        }
        return super.internalCanCompileToJavaExpression(expression, appendable);
    }

    protected boolean isVariableDeclarationRequired(XMemberFeatureCall expr, ITreeAppendable b) {
        return expr.isNullSafe();
    }

    @Override
    protected boolean isVariableDeclarationRequired(XExpression expr, ITreeAppendable b, boolean recursive) {
        XBinaryOperation binaryOperation;
        if (recursive && this.isVariableDeclarationRequired(this.getFeatureCall(expr), expr, b)) {
            return true;
        }
        EStructuralFeature eContainingFeature = expr.eContainingFeature();
        if (eContainingFeature == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET) {
            if (((XMemberFeatureCall)expr.eContainer()).isNullSafe()) {
                if (expr instanceof XFeatureCall) {
                    JvmIdentifiableElement feature = ((XFeatureCall)expr).getFeature();
                    if (feature instanceof JvmField || feature instanceof JvmFormalParameter) {
                        return false;
                    }
                    return !b.hasName(feature);
                }
                return !b.hasName(expr);
            }
            return false;
        }
        if (eContainingFeature == XbasePackage.Literals.XBINARY_OPERATION__LEFT_OPERAND && (binaryOperation = (XBinaryOperation)expr.eContainer()).isReassignFirstArgument()) {
            return true;
        }
        if (expr instanceof XBinaryOperation && (binaryOperation = (XBinaryOperation)expr).isReassignFirstArgument()) {
            return true;
        }
        if (expr instanceof XAbstractFeatureCall) {
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)expr;
            if (featureCall.isTypeLiteral() || featureCall.isPackageFragment()) {
                return false;
            }
            if (this.isPotentialJavaOperation(featureCall)) {
                JvmAnnotationReference inlineAnnotation = this.expressionHelper.findInlineAnnotation(featureCall);
                if (inlineAnnotation == null) {
                    return true;
                }
                for (XExpression argument : featureCall.getActualArguments()) {
                    if (this.isVariableDeclarationRequired(argument, b, recursive)) {
                        return true;
                    }
                    if (argument instanceof XInstanceOfExpression && this.isVariableDeclarationRequired(((XInstanceOfExpression)argument).getExpression(), b, recursive)) {
                        return true;
                    }
                    if (!(argument instanceof XCastedExpression) || !this.isVariableDeclarationRequired(((XCastedExpression)argument).getTarget(), b, recursive)) continue;
                    return true;
                }
                for (JvmAnnotationValue value : inlineAnnotation.getValues()) {
                    EList<Boolean> values;
                    if (!(value instanceof JvmBooleanAnnotationValue) || !value.getValueName().equals("constantExpression") || (values = ((JvmBooleanAnnotationValue)value).getValues()).isEmpty()) continue;
                    return (Boolean)values.get(0) == false;
                }
                return true;
            }
            if (featureCall instanceof XMemberFeatureCall && this.isVariableDeclarationRequired((XMemberFeatureCall)featureCall, b)) {
                return true;
            }
            JvmIdentifiableElement feature = featureCall.getFeature();
            if (feature instanceof JvmField || feature instanceof JvmFormalParameter) {
                return false;
            }
            if (eContainingFeature == XbasePackage.Literals.XFEATURE_CALL__FEATURE_CALL_ARGUMENTS || eContainingFeature == XbasePackage.Literals.XASSIGNMENT__VALUE || eContainingFeature == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_ARGUMENTS) {
                return false;
            }
            return !b.hasName(feature);
        }
        return super.isVariableDeclarationRequired(expr, b, recursive);
    }

    protected boolean isVariableDeclarationRequired(XAbstractFeatureCall featureCall, XExpression expression, ITreeAppendable b) {
        if (featureCall == null) {
            return false;
        }
        XExpression actualReceiver = this.normalizeBlockExpression(this.getActualReceiver(featureCall));
        List<XExpression> arguments = this.getActualArguments(featureCall);
        XExpression argument = this.normalizeBlockExpression(expression);
        int argumentIndex = -1;
        if (actualReceiver != argument && (argumentIndex = arguments.indexOf(argument)) == -1) {
            return false;
        }
        if (!this.expressionHelper.hasSideEffects(argument)) {
            return false;
        }
        int startIndex = argumentIndex + 1;
        int endIndex = arguments.size();
        for (int i = startIndex; i < endIndex; ++i) {
            if (!this.isVariableDeclarationRequired(arguments.get(i), b, false)) continue;
            return true;
        }
        return false;
    }

    private boolean isPotentialJavaOperation(XAbstractFeatureCall featureCall) {
        JvmIdentifiableElement feature;
        if (featureCall.isOperation()) {
            return true;
        }
        if (featureCall.eClass() == XbasePackage.Literals.XMEMBER_FEATURE_CALL && featureCall.isStatic() && featureCall.isExtension() && featureCall.getActualArguments().size() == 2 && (feature = featureCall.getFeature()).eClass() == TypesPackage.Literals.JVM_OPERATION) {
            String simpleName;
            JvmDeclaredType declarator = ((JvmOperation)feature).getDeclaringType();
            if ((IntegerExtensions.class.getName().equals(declarator.getIdentifier()) || LongExtensions.class.getName().equals(declarator.getIdentifier())) && ((simpleName = feature.getSimpleName()).startsWith("bitwise") || simpleName.startsWith("shift"))) {
                return true;
            }
        }
        return false;
    }

    protected void prepareExpression(XExpression arg, ITreeAppendable b) {
        if (arg instanceof XAbstractFeatureCall && !(((XAbstractFeatureCall)arg).getFeature() instanceof JvmField) && !this.isVariableDeclarationRequired(arg, b, true)) {
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)arg;
            if (featureCall.getFeature() instanceof XVariableDeclaration) {
                XVariableDeclaration variableDeclaration = (XVariableDeclaration)featureCall.getFeature();
                if (!variableDeclaration.isWriteable()) {
                    this.internalToJavaStatement(arg, b, true);
                } else {
                    LightweightTypeReference expectedType = this.getLightweightExpectedType(arg);
                    LightweightTypeReference type = this.getLightweightType(arg);
                    if (expectedType != null && !this.isJavaConformant(expectedType, type)) {
                        String varName = this.getVarName(((XAbstractFeatureCall)arg).getFeature(), b);
                        String finalVariable = b.declareSyntheticVariable(arg, "_converted_" + varName);
                        b.newLine().append("final ");
                        b.append(type);
                        b.append(" ").append(finalVariable).append(" = ").append("(");
                        b.append(type);
                        b.append(")").append(varName).append(";");
                    }
                }
                return;
            }
            if (featureCall.getFeature() instanceof JvmFormalParameter) {
                this.internalToJavaStatement(arg, b, true);
                return;
            }
        }
        this.internalToJavaStatement(arg, b, true);
        if (b.hasName(arg)) {
            LightweightTypeReference type = this.getTypeForVariableDeclaration(arg);
            LightweightTypeReference expectation = this.getLightweightExpectedType(arg);
            if (expectation != null && type.isFunctionType() && !this.isJavaConformant(expectation, type)) {
                String mutableName = b.removeName(arg);
                String finalNameProposal = "_final" + mutableName;
                String finalName = b.declareSyntheticVariable(arg, finalNameProposal);
                b.newLine();
                b.append("final ");
                b.append(type);
                b.append(" ").append(finalName).append(" = ");
                b.append(mutableName);
                b.append(";");
            }
        }
    }

    protected void _toJavaExpression(XAbstractFeatureCall call, ITreeAppendable b) {
        if (call.isTypeLiteral()) {
            b.append((JvmType)call.getFeature()).append(".class");
        } else {
            if (this.isPrimitiveVoid(call)) {
                throw new IllegalArgumentException("feature yields 'void'");
            }
            String referenceName = this.getReferenceName(call, b);
            if (referenceName != null) {
                if (call instanceof XFeatureCall || call instanceof XMemberFeatureCall) {
                    b.trace(call, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0).append(referenceName);
                } else {
                    b.trace(call, false).append(referenceName);
                }
            } else {
                this.featureCalltoJavaExpression(call, b, true);
            }
        }
    }

    private static boolean isConstantExpression(JvmAnnotationReference reference) {
        for (JvmAnnotationValue annotationValue : reference.getValues()) {
            EObject value;
            if (!"constantExpression".equals(annotationValue.getValueName())) continue;
            if (annotationValue instanceof JvmBooleanAnnotationValue) {
                return (Boolean)((JvmBooleanAnnotationValue)annotationValue).getValues().get(0);
            }
            if (!(annotationValue instanceof JvmCustomAnnotationValue) || !((value = (EObject)((JvmCustomAnnotationValue)annotationValue).getValues().get(0)) instanceof XBooleanLiteral)) continue;
            return ((XBooleanLiteral)value).isIsTrue();
        }
        return false;
    }

    protected void featureCalltoJavaExpression(XAbstractFeatureCall call, ITreeAppendable b, boolean isExpressionContext) {
        if (call instanceof XAssignment) {
            this.assignmentToJavaExpression((XAssignment)call, b, isExpressionContext);
        } else {
            boolean hasReceiver;
            JvmAnnotationReference annotationRef;
            if (this.needMultiAssignment(call)) {
                this.appendLeftOperand(call, b, isExpressionContext).append(" = ");
            }
            if (((annotationRef = this.expressionHelper.findInlineAnnotation(call)) == null || !FeatureCallCompiler.isConstantExpression(annotationRef)) && (hasReceiver = this.appendReceiver(call, b, isExpressionContext))) {
                b.append(".");
                b = this.appendTypeArguments(call, b);
            }
            this.appendFeatureCall(call, b);
        }
    }

    protected ITreeAppendable appendTypeArguments(XAbstractFeatureCall call, ITreeAppendable original) {
        JvmExecutable executable;
        ITreeAppendable completeFeatureCallAppendable;
        ILocationData completeLocationData = this.getLocationWithTypeArguments(call);
        ITreeAppendable iTreeAppendable = completeFeatureCallAppendable = completeLocationData != null ? original.trace(completeLocationData) : original;
        if (!call.getTypeArguments().isEmpty()) {
            ILocationData argumentsLocationData = null;
            if (completeLocationData != null) {
                argumentsLocationData = this.getLocationOfTypeArguments(call);
            }
            ITreeAppendable typeArgumentsAppendable = argumentsLocationData != null ? completeFeatureCallAppendable.trace(argumentsLocationData) : completeFeatureCallAppendable;
            typeArgumentsAppendable.append("<");
            for (int i = 0; i < call.getTypeArguments().size(); ++i) {
                if (i != 0) {
                    typeArgumentsAppendable.append(", ");
                }
                JvmTypeReference typeArgument = (JvmTypeReference)call.getTypeArguments().get(i);
                ITreeAppendable singleTypeArgumentAppendable = typeArgumentsAppendable.trace(typeArgument, false);
                this.serialize(typeArgument, call, singleTypeArgumentAppendable);
            }
            typeArgumentsAppendable.append(">");
            ILocationData featureAndArgumentLocation = null;
            if (completeLocationData != null && argumentsLocationData != null) {
                featureAndArgumentLocation = this.getLocationWithoutTypeArguments(call);
            }
            ITreeAppendable result = featureAndArgumentLocation != null ? completeFeatureCallAppendable.trace(featureAndArgumentLocation) : completeFeatureCallAppendable;
            return result;
        }
        if (call.getFeature() instanceof JvmExecutable && !(executable = (JvmExecutable)call.getFeature()).getTypeParameters().isEmpty()) {
            Object typeArgument;
            int i;
            List<LightweightTypeReference> typeArguments = this.getResolvedTypes(call).getActualTypeArguments(call);
            ArrayList<JvmTypeReference> resolvedTypeArguments = Lists.newArrayList();
            boolean containedUnresolved = false;
            for (i = 0; i < executable.getTypeParameters().size() && !containedUnresolved; ++i) {
                typeArgument = typeArguments.get(i);
                if (typeArgument != null) {
                    if (((LightweightTypeReference)typeArgument).isWildcard()) {
                        containedUnresolved = true;
                        continue;
                    }
                    resolvedTypeArguments.add(((LightweightTypeReference)typeArgument).toJavaCompliantTypeReference());
                    continue;
                }
                containedUnresolved = true;
            }
            if (!containedUnresolved) {
                completeFeatureCallAppendable.append("<");
                for (i = 0; i < resolvedTypeArguments.size(); ++i) {
                    if (i != 0) {
                        completeFeatureCallAppendable.append(", ");
                    }
                    typeArgument = (JvmTypeReference)resolvedTypeArguments.get(i);
                    this.serialize((JvmTypeReference)typeArgument, call, completeFeatureCallAppendable);
                }
                completeFeatureCallAppendable.append(">");
            }
        }
        return completeFeatureCallAppendable;
    }

    protected ILocationData getLocationWithoutTypeArguments(XAbstractFeatureCall call) {
        ICompositeNode startNode = NodeModelUtils.getNode(call);
        if (startNode != null) {
            ArrayList<INode> resultNodes = Lists.newArrayList();
            if (call instanceof XFeatureCall || call instanceof XMemberFeatureCall) {
                boolean featureReferenceSeen = false;
                for (INode child : startNode.getChildren()) {
                    Assignment assignment;
                    if (featureReferenceSeen) {
                        resultNodes.add(child);
                        continue;
                    }
                    EObject grammarElement = child.getGrammarElement();
                    if (!(grammarElement instanceof CrossReference) || (assignment = GrammarUtil.containingAssignment(grammarElement)) == null || !"feature".equals(assignment.getFeature())) continue;
                    featureReferenceSeen = true;
                    resultNodes.add(child);
                }
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    protected ILocationData getLocationWithTypeArguments(XAbstractFeatureCall call) {
        ICompositeNode startNode = NodeModelUtils.getNode(call);
        if (startNode != null) {
            ArrayList<INode> resultNodes = Lists.newArrayList();
            if (call instanceof XFeatureCall) {
                for (INode child : startNode.getChildren()) {
                    resultNodes.add(child);
                }
            } else if (call instanceof XMemberFeatureCall) {
                boolean keywordSeen = false;
                for (INode child : startNode.getChildren()) {
                    if (keywordSeen) {
                        resultNodes.add(child);
                        continue;
                    }
                    EObject grammarElement = child.getGrammarElement();
                    if (!(grammarElement instanceof Keyword)) continue;
                    keywordSeen = true;
                }
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    protected ILocationData getLocationOfTypeArguments(XAbstractFeatureCall call) {
        ICompositeNode startNode = NodeModelUtils.getNode(call);
        if (startNode != null) {
            ArrayList<INode> resultNodes = Lists.newArrayList();
            if (call instanceof XFeatureCall) {
                INode child;
                Iterator iterator = startNode.getChildren().iterator();
                while (iterator.hasNext() && !((child = (INode)iterator.next()).getGrammarElement() instanceof CrossReference)) {
                    resultNodes.add(child);
                }
            } else if (call instanceof XMemberFeatureCall) {
                boolean keywordSeen = false;
                for (INode child : startNode.getChildren()) {
                    if (keywordSeen) {
                        if (!(child.getGrammarElement() instanceof CrossReference)) {
                            resultNodes.add(child);
                            continue;
                        }
                        break;
                    }
                    EObject grammarElement = child.getGrammarElement();
                    if (!(grammarElement instanceof Keyword)) continue;
                    keywordSeen = true;
                }
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    protected ILocationData toLocationData(List<INode> nodes) {
        ITextRegionWithLineInformation result = ITextRegionWithLineInformation.EMPTY_REGION;
        for (INode node : nodes) {
            ITextRegionWithLineInformation region;
            if (this.isHidden(node) || (region = node.getTextRegionWithLineInformation()).getLength() == 0) continue;
            result = result.merge(new TextRegionWithLineInformation(region.getOffset(), region.getLength(), region.getLineNumber() - 1, region.getEndLineNumber() - 1));
        }
        if (result.getLength() == 0) {
            return null;
        }
        return new LocationData(result.getOffset(), result.getLength(), result.getLineNumber(), result.getEndLineNumber(), null);
    }

    protected boolean isHidden(INode node) {
        return node instanceof ILeafNode && ((ILeafNode)node).isHidden();
    }

    protected boolean appendReceiver(XAbstractFeatureCall call, ITreeAppendable b, boolean isExpressionContext) {
        if (call.isStatic()) {
            XMemberFeatureCall memberFeatureCall;
            if (this.expressionHelper.findInlineAnnotation(call) != null) {
                return false;
            }
            if (call instanceof XMemberFeatureCall && (memberFeatureCall = (XMemberFeatureCall)call).isStaticWithDeclaringType()) {
                XAbstractFeatureCall target = (XAbstractFeatureCall)memberFeatureCall.getMemberCallTarget();
                JvmType declaringType = (JvmType)target.getFeature();
                b.trace(target, false).append(declaringType);
                return true;
            }
            b.append(((JvmFeature)call.getFeature()).getDeclaringType());
            return true;
        }
        XExpression receiver = this.getActualReceiver(call);
        if (receiver != null) {
            String referenceName;
            this.internalToJavaExpression(receiver, b);
            return !(receiver instanceof XAbstractFeatureCall) || !(((XAbstractFeatureCall)receiver).getFeature() instanceof JvmType) || (referenceName = this.getReferenceName(receiver, b)) == null || referenceName.length() != 0;
        }
        return false;
    }

    protected void appendNullValue(JvmTypeReference type, EObject context, ITreeAppendable b) {
        if (!this.primitives.isPrimitive(type)) {
            if (!(type.getType() instanceof JvmVoid)) {
                b.append("(");
                this.serialize(type, context, b);
                b.append(")");
            }
            b.append("null");
        } else {
            b.append(this.getDefaultLiteral((JvmPrimitiveType)type.getType()));
        }
    }

    protected void appendNullValueUntyped(LightweightTypeReference type, EObject context, ITreeAppendable b) {
        if (!type.isPrimitive()) {
            b.append("null");
        } else {
            b.append(this.getDefaultLiteral((JvmPrimitiveType)type.getType()));
        }
    }

    protected String getDefaultLiteral(JvmPrimitiveType primitiveType) {
        String name = primitiveType.getIdentifier();
        if (Boolean.TYPE.getName().equals(name)) {
            return "false";
        }
        if (Integer.TYPE.getName().equals(name)) {
            return "0";
        }
        if (Byte.TYPE.getName().equals(name)) {
            return "(byte) 0";
        }
        if (Short.TYPE.getName().equals(name)) {
            return "(short) 0";
        }
        if (Character.TYPE.getName().equals(name)) {
            return "(char) 0";
        }
        if (Long.TYPE.getName().equals(name)) {
            return "0l";
        }
        if (Float.TYPE.getName().equals(name)) {
            return "0f";
        }
        if (Double.TYPE.getName().equals(name)) {
            return "0.0";
        }
        throw new IllegalArgumentException("Unkown primitive " + name);
    }

    protected boolean isMemberCall(XAbstractFeatureCall call) {
        return !call.isStatic();
    }

    protected boolean isReferenceToSelf(XFeatureCall featureCall, JvmType type) {
        return !featureCall.isTypeLiteral() && !featureCall.isPackageFragment() && type.equals(featureCall.getFeature()) && IFeatureNames.SELF.getFirstSegment().equals(featureCall.getConcreteSyntaxFeatureName());
    }

    protected void assignmentToJavaExpression(XAssignment expr, ITreeAppendable b, boolean isExpressionContext) {
        JvmIdentifiableElement feature = expr.getFeature();
        if (feature instanceof JvmOperation) {
            boolean appendReceiver = this.appendReceiver(expr, b, isExpressionContext);
            if (appendReceiver) {
                b.append(".");
            }
            this.appendFeatureCall(expr, b);
        } else {
            boolean isArgument = expr.eContainer() instanceof XAbstractFeatureCall;
            if (isArgument) {
                EStructuralFeature containingFeature = expr.eContainingFeature();
                if (containingFeature == XbasePackage.Literals.XFEATURE_CALL__FEATURE_CALL_ARGUMENTS || containingFeature == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_ARGUMENTS) {
                    isArgument = false;
                } else {
                    b.append("(");
                }
            }
            if (feature instanceof JvmField) {
                boolean appendReceiver = this.appendReceiver(expr, b, isExpressionContext);
                if (appendReceiver) {
                    b.append(".");
                }
                this.appendFeatureCall(expr, b);
            } else {
                String name = b.getName(expr.getFeature());
                b.append(name);
            }
            b.append(" = ");
            this.internalToJavaExpression(expr.getValue(), b);
            if (isArgument) {
                b.append(")");
            }
        }
    }

    protected void appendFeatureCall(XAbstractFeatureCall call, ITreeAppendable b) {
        if (this.expressionHelper.isInlined(call)) {
            this.appendInlineFeatureCall(call, b);
            return;
        }
        JvmIdentifiableElement feature = call.getFeature();
        String name = null;
        if (feature instanceof JvmConstructor) {
            JvmDeclaredType constructorContainer = ((JvmConstructor)feature).getDeclaringType();
            JvmIdentifiableElement logicalContainer = this.contextProvider.getNearestLogicalContainer(call);
            JvmDeclaredType contextType = ((JvmMember)logicalContainer).getDeclaringType();
            name = contextType == constructorContainer ? "this" : "super";
        } else if (feature != null) {
            name = b.hasName(feature) ? b.getName(feature) : this.featureNameProvider.getSimpleName(feature);
        }
        if (name == null) {
            name = "/* name is null */";
        }
        b.trace(call, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0).append(name);
        if (feature instanceof JvmExecutable) {
            b.append("(");
            List<XExpression> arguments = this.getActualArguments(call);
            if (!arguments.isEmpty()) {
                XExpression receiver = null;
                if (call instanceof XMemberFeatureCall) {
                    receiver = ((XMemberFeatureCall)call).getMemberCallTarget();
                } else if (call instanceof XAssignment) {
                    receiver = ((XAssignment)call).getAssignable();
                }
                boolean shouldBreakFirstArgument = receiver == null || arguments.get(0) != receiver;
                this.appendArguments(arguments, b, shouldBreakFirstArgument);
            }
            b.append(")");
        }
    }

    protected void appendInlineFeatureCall(XAbstractFeatureCall call, ITreeAppendable b) {
        JvmAnnotationReference inlineAnnotation = this.expressionHelper.findInlineAnnotation(call);
        String formatString = null;
        ArrayList<JvmTypeReference> importedTypes = Lists.newArrayListWithCapacity(2);
        for (JvmAnnotationValue annotationValue : inlineAnnotation.getValues()) {
            JvmCustomAnnotationValue customAnnotationValue;
            if ("value".equals(annotationValue.getValueName()) || null == annotationValue.getValueName()) {
                if (annotationValue instanceof JvmStringAnnotationValue) {
                    formatString = (String)((JvmStringAnnotationValue)annotationValue).getValues().get(0);
                    continue;
                }
                if (!(annotationValue instanceof JvmCustomAnnotationValue) || (customAnnotationValue = (JvmCustomAnnotationValue)annotationValue).getValues().size() != 1 || !(customAnnotationValue.getValues().get(0) instanceof XStringLiteral)) continue;
                formatString = ((XStringLiteral)customAnnotationValue.getValues().get(0)).getValue();
                continue;
            }
            if (!"imported".equals(annotationValue.getValueName())) continue;
            if (annotationValue instanceof JvmTypeAnnotationValue) {
                JvmTypeAnnotationValue typeAnnotationValue = (JvmTypeAnnotationValue)annotationValue;
                importedTypes.addAll(typeAnnotationValue.getValues());
                continue;
            }
            if (annotationValue instanceof JvmCustomAnnotationValue) {
                customAnnotationValue = (JvmCustomAnnotationValue)annotationValue;
                if (customAnnotationValue.getValues().size() != 1 || !(customAnnotationValue.getValues().get(0) instanceof XListLiteral)) continue;
                EList<XExpression> elements = ((XListLiteral)customAnnotationValue.getValues().get(0)).getElements();
                for (XExpression e : elements) {
                    LightweightTypeReference lightweightType = this.getLightweightType(e);
                    if (lightweightType == null || !lightweightType.isType(Class.class)) continue;
                    importedTypes.add(lightweightType.toTypeReference());
                }
                continue;
            }
            throw new IllegalStateException("Unhandled 'imported' AnnotationValue type " + annotationValue.getClass());
        }
        if (formatString == null) {
            throw new IllegalStateException();
        }
        boolean inlineCallNeedsParenthesis = this.inlineCallNeedsParenthesis(call, formatString);
        if (inlineCallNeedsParenthesis) {
            b.append("(");
        }
        IResolvedTypes resolvedTypes = this.batchTypeResolver.resolveTypes(call);
        List<XExpression> arguments = this.getActualArguments(call);
        Matcher matcher = this.pattern.matcher(formatString);
        int prevEnd = 0;
        while (matcher.find()) {
            String indexOrDollar;
            int start = matcher.start();
            if (start != prevEnd) {
                b.append(formatString.substring(prevEnd, start));
            }
            if ("$".equals(indexOrDollar = matcher.group(1))) {
                b.append("$");
            } else {
                int index = Integer.parseInt(indexOrDollar) - 1;
                int numberImports = importedTypes.size();
                int numberArguments = arguments.size();
                if (index > numberArguments + numberImports) {
                    List<LightweightTypeReference> typeArguments = resolvedTypes.getActualTypeArguments(call);
                    LightweightTypeReference typeArgument = typeArguments.get(index - (numberArguments + numberImports + 1));
                    this.serialize(typeArgument.getRawTypeReference().toTypeReference(), call, b);
                } else if (index >= numberArguments && index < numberArguments + numberImports) {
                    this.serialize((JvmTypeReference)importedTypes.get(index - numberArguments), call, b);
                } else if (index == numberArguments + numberImports) {
                    this.appendTypeArguments(call, b);
                } else {
                    XExpression argument = arguments.get(index);
                    this.appendArgument(argument, b, index > 0);
                }
            }
            prevEnd = matcher.end();
        }
        if (prevEnd != formatString.length()) {
            b.append(formatString.substring(prevEnd));
        }
        if (inlineCallNeedsParenthesis) {
            b.append(")");
        }
    }

    protected boolean inlineCallNeedsParenthesis(XAbstractFeatureCall call, String formatString) {
        String trimmedFormatString = formatString.trim();
        if (trimmedFormatString.startsWith("(")) {
            return false;
        }
        if (call.eContainer() instanceof XMemberFeatureCall && call.eContainingFeature() == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET) {
            XMemberFeatureCall mfc = (XMemberFeatureCall)call.eContainer();
            JvmAnnotationReference inlineAnnotation = this.expressionHelper.findInlineAnnotation(mfc);
            if (inlineAnnotation != null) {
                return true;
            }
            if (mfc.isExtension()) {
                return false;
            }
            return !trimmedFormatString.endsWith(")");
        }
        return false;
    }

    protected void appendArguments(List<? extends XExpression> arguments, ITreeAppendable b) {
        this.appendArguments(arguments, b, true);
    }

    protected void appendArguments(List<? extends XExpression> arguments, ITreeAppendable b, boolean shouldWrapLine) {
        for (int i = 0; i < arguments.size(); ++i) {
            XExpression argument = arguments.get(i);
            this.appendArgument(argument, b, shouldWrapLine || i > 0);
            if (i + 1 >= arguments.size()) continue;
            b.append(", ");
        }
    }

    protected void appendArgument(XExpression argument, ITreeAppendable b) {
        this.appendArgument(argument, b, true);
    }

    protected void appendArgument(XExpression argument, ITreeAppendable b, boolean doLineWrappingIfSourceWasWrapped) {
        boolean needsNewLine;
        String referenceName = this.getReferenceName(argument, b);
        boolean bl = needsNewLine = doLineWrappingIfSourceWasWrapped && referenceName == null && this.isDeclaredInNewLine(argument);
        if (needsNewLine) {
            b.increaseIndentation();
            b.newLine();
        }
        if (referenceName == null && this.isVariableDeclarationRequired(argument, b, true)) {
            if (this.canCompileToJavaExpression(argument, b)) {
                this.internalToJavaExpression(argument, b);
            } else {
                LightweightTypeReference type = this.getLightweightExpectedType(argument);
                if (type == null) {
                    type = this.getLightweightType(argument);
                }
                this.compileAsJavaExpression(argument, b, type);
            }
        } else {
            this.internalToJavaExpression(argument, b);
        }
        if (needsNewLine) {
            b.decreaseIndentation();
        }
    }

    protected boolean isDeclaredInNewLine(XExpression obj) {
        ICompositeNode node = NodeModelUtils.getNode(obj);
        if (node != null) {
            int line = -1;
            for (ILeafNode n : node.getLeafNodes()) {
                if (n.isHidden() && line == -1) {
                    line = n.getStartLine();
                }
                if (n.isHidden() || line == -1) continue;
                return line != n.getStartLine();
            }
        }
        return false;
    }

    protected ILogicalContainerProvider getLogicalContainerProvider() {
        return this.contextProvider;
    }

    protected ILocationInFileProvider getLocationInFileProvider() {
        return this.locationInFileProvider;
    }
}

