/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.compiler.BrokenTypeRefDetector;
import org.eclipse.xtext.xbase.compiler.IElementIssueProvider;
import org.eclipse.xtext.xbase.compiler.LoopParams;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.compiler.output.ErrorTreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ErrorSafeExtensions {
    @Inject
    @Extension
    private TypeReferenceSerializer _typeReferenceSerializer;
    @Inject
    private IElementIssueProvider.Factory issueProviderFactory;

    public Iterable<Issue> getErrors(EObject element) {
        Iterable<Issue> _xblockexpression = null;
        IElementIssueProvider issueProvider = this.issueProviderFactory.get(element.eResource());
        Functions.Function1<Issue, Boolean> _function = it -> {
            Severity _severity = it.getSeverity();
            return Objects.equal((Object)_severity, (Object)Severity.ERROR);
        };
        _xblockexpression = IterableExtensions.filter(issueProvider.getIssues(element), _function);
        return _xblockexpression;
    }

    public boolean hasErrors(EObject element) {
        boolean _xblockexpression = false;
        IElementIssueProvider issueProvider = this.issueProviderFactory.get(element.eResource());
        Functions.Function1<Issue, Boolean> _function = it -> {
            Severity _severity = it.getSeverity();
            return Objects.equal((Object)_severity, (Object)Severity.ERROR);
        };
        _xblockexpression = IterableExtensions.exists(issueProvider.getIssues(element), _function);
        return _xblockexpression;
    }

    public <T extends EObject> void forEachSafely(ITreeAppendable appendable, Iterable<T> elements, Procedures.Procedure1<? super LoopParams> loopInitializer, Procedures.Procedure2<? super T, ? super ITreeAppendable> body) {
        int _size_1;
        boolean _isEmpty = IterableExtensions.isEmpty(elements);
        if (_isEmpty) {
            return;
        }
        LoopParams _loopParams = new LoopParams();
        LoopParams loopParams = ObjectExtensions.operator_doubleArrow(_loopParams, loopInitializer);
        Functions.Function1<EObject, Boolean> _function = it -> this.hasErrors((EObject)it);
        int _size = IterableExtensions.size(IterableExtensions.filter(elements, _function));
        boolean allElementsBroken = _size == (_size_1 = IterableExtensions.size(elements));
        ITreeAppendable _xifexpression = null;
        _xifexpression = allElementsBroken ? this.openErrorAppendable(appendable, null) : appendable;
        ITreeAppendable currentAppendable = _xifexpression;
        loopParams.appendPrefix(currentAppendable);
        boolean isFirst = true;
        boolean isFirstBroken = true;
        for (EObject element : elements) {
            boolean _not;
            boolean _hasErrors = this.hasErrors(element);
            boolean bl = _not = !_hasErrors;
            if (_not) {
                currentAppendable = this.closeErrorAppendable(appendable, currentAppendable);
                if (!isFirst) {
                    loopParams.appendSeparator(appendable);
                }
                isFirst = false;
                body.apply(element, appendable);
                continue;
            }
            if (!allElementsBroken) {
                currentAppendable = this.openErrorAppendable(appendable, currentAppendable);
            }
            if (!isFirst || !isFirstBroken) {
                loopParams.appendSeparator(currentAppendable);
            }
            isFirstBroken = false;
            try {
                body.apply(element, currentAppendable);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) continue;
                throw Exceptions.sneakyThrow(_t);
            }
        }
        ITreeAppendable _xifexpression_1 = null;
        _xifexpression_1 = allElementsBroken ? currentAppendable : this.closeErrorAppendable(appendable, currentAppendable);
        currentAppendable = _xifexpression_1;
        loopParams.appendSuffix(currentAppendable);
        this.closeErrorAppendable(appendable, currentAppendable);
    }

    protected ITreeAppendable openErrorAppendable(ITreeAppendable parent, ITreeAppendable child) {
        ITreeAppendable _xifexpression = null;
        _xifexpression = !(child instanceof ErrorTreeAppendable) ? parent.errorChild().append("/* ") : child;
        return _xifexpression;
    }

    protected ITreeAppendable closeErrorAppendable(ITreeAppendable parent, ITreeAppendable child) {
        ITreeAppendable _xblockexpression = null;
        if (child instanceof ErrorTreeAppendable && !Objects.equal(child, parent)) {
            child.append(" */");
        }
        _xblockexpression = parent;
        return _xblockexpression;
    }

    public void serializeSafely(JvmTypeReference typeRef, ITreeAppendable appendable) {
        this.serializeSafely(typeRef, null, appendable);
    }

    public void serializeSafely(JvmTypeReference typeRef, String surrogateType, ITreeAppendable appendable) {
        if (typeRef == null || typeRef.getType() == null) {
            boolean _matched = false;
            if (typeRef instanceof JvmSpecializedTypeReference) {
                _matched = true;
                this.serializeSafely(((JvmSpecializedTypeReference)typeRef).getEquivalent(), surrogateType, appendable);
            }
            if (!_matched && typeRef instanceof JvmUnknownTypeReference) {
                _matched = true;
                appendable.append(((JvmUnknownTypeReference)typeRef).getQualifiedName());
            }
            if (!_matched) {
                appendable.append("Object");
                ITreeAppendable errorChild = this.openErrorAppendable(appendable, appendable);
                errorChild.append("type is 'null'");
                this.closeErrorAppendable(appendable, errorChild);
            }
        } else {
            BrokenTypeRefDetector _brokenTypeRefDetector = new BrokenTypeRefDetector();
            Boolean _accept = typeRef.accept(_brokenTypeRefDetector);
            if (_accept.booleanValue()) {
                ITreeAppendable errorChild;
                block10: {
                    errorChild = this.openErrorAppendable(appendable, appendable);
                    try {
                        this._typeReferenceSerializer.serialize(typeRef, typeRef.eContainer(), errorChild);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) break block10;
                        throw Exceptions.sneakyThrow(_t);
                    }
                }
                this.closeErrorAppendable(appendable, errorChild);
                if (surrogateType != null) {
                    appendable.append(surrogateType);
                }
            } else {
                this._typeReferenceSerializer.serialize(typeRef, typeRef.eContainer(), appendable);
            }
        }
    }

    public void serializeSafely(JvmAnnotationReference annotationRef, ITreeAppendable appendable, Procedures.Procedure1<? super ITreeAppendable> onSuccess) {
        if (annotationRef == null || annotationRef.getAnnotation() == null) {
            ITreeAppendable errorChild = this.openErrorAppendable(appendable, appendable);
            errorChild.append("annotation is 'null'");
            this.closeErrorAppendable(appendable, errorChild);
        } else {
            boolean _eIsProxy = annotationRef.getAnnotation().eIsProxy();
            if (_eIsProxy) {
                ITreeAppendable errorChild_1 = this.openErrorAppendable(appendable, appendable);
                appendable.append("@");
                appendable.append(annotationRef.getAnnotation());
                this.closeErrorAppendable(appendable, errorChild_1);
            } else {
                appendable.append("@");
                appendable.append(annotationRef.getAnnotation());
                onSuccess.apply(appendable);
            }
        }
    }
}

