/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AlternateJdkLoader
extends URLClassLoader {
    private final ConcurrentMap<String, Object> locks = new ConcurrentHashMap<String, Object>();

    public AlternateJdkLoader(Iterable<File> files) {
        super(AlternateJdkLoader.mapToURLs(files));
    }

    private static URL[] mapToURLs(Iterable<File> files) {
        ArrayList<File> fileList = Lists.newArrayList(files);
        URL[] result = new URL[fileList.size()];
        for (int i = 0; i < fileList.size(); ++i) {
            try {
                result[i] = fileList.get(i).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLockJdk5(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }

    private Object getClassLoadingLockJdk5(String className) {
        Object newLock = new Object();
        Object existingLock = this.locks.putIfAbsent(className, newLock);
        return existingLock != null ? existingLock : newLock;
    }
}

