/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Function;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SimpleCache<Key, Value> {
    private final Map<Key, Value> content;
    private final ReentrantReadWriteLock readWriteLock;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Function<Key, Value> f;

    public SimpleCache(Function<Key, Value> f) {
        if (f == null) {
            throw new IllegalArgumentException("function may not be null");
        }
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.f = f;
        this.content = new WeakHashMap<Key, Value>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value get(Key k) {
        Value result = null;
        try {
            this.readLock.lock();
            result = this.content.get(k);
            if (result != null || this.content.containsKey(k)) {
                Value Value2 = result;
                return Value2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        result = this.f.apply(k);
        try {
            this.writeLock.lock();
            this.content.put(k, result);
        }
        finally {
            this.writeLock.unlock();
        }
        return result;
    }

    public void clear() {
        try {
            this.writeLock.lock();
            if (!this.content.isEmpty()) {
                this.content.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void discard(Key k) {
        try {
            this.writeLock.lock();
            this.content.remove(k);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasCachedValue(Key key) {
        try {
            this.readLock.lock();
            boolean bl = this.content.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getSize() {
        try {
            this.readLock.lock();
            int n = this.content.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        try {
            this.readLock.lock();
            boolean bl = this.content.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

