/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.IContextPDAProvider;
import org.eclipse.xtext.serializer.analysis.IContextTypePDAProvider;
import org.eclipse.xtext.serializer.analysis.ISerState;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.serializer.analysis.SerializerPDA;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaUtil;
import org.eclipse.xtext.util.formallang.Traverser;

@Singleton
public class ContextTypePDAProvider
implements IContextTypePDAProvider {
    private static Logger LOG = Logger.getLogger(ContextTypePDAProvider.class);
    private Map<Grammar, SerializationContextMap<Pda<ISerState, RuleCall>>> cache = Maps.newHashMap();
    @Inject
    protected SerializerPDA.SerializerPDACloneFactory factory;
    @Inject
    protected IContextPDAProvider pdaProvider;
    @Inject
    protected PdaUtil pdaUtil;
    @Inject
    protected NfaUtil nfaUtil;

    protected Set<EClass> collectTypes(Pda<ISerState, RuleCall> contextPda, Map<ISerState, Integer> distances) {
        TypeCollector collector = this.newTypeCollector();
        this.pdaUtil.filterEdges(contextPda, collector, distances, null);
        return collector.getTypes();
    }

    protected Pda<ISerState, RuleCall> filterByType(Pda<ISerState, RuleCall> contextPda, EClass type, Map<ISerState, Integer> distances) {
        TypeFilter typeFilter = this.newTypeFilter(type);
        SerializerPDA pda = this.pdaUtil.filterEdges(contextPda, typeFilter, distances, this.factory);
        return pda;
    }

    @Override
    public SerializationContextMap<Pda<ISerState, RuleCall>> getContextTypePDAs(Grammar grammar) {
        SerializationContextMap<Pda<ISerState, RuleCall>> cached = this.cache.get(grammar);
        if (cached != null) {
            return cached;
        }
        SerializationContextMap.Builder<Pda<ISerState, RuleCall>> builder = SerializationContextMap.builder();
        SerializationContextMap<Pda<ISerState, RuleCall>> contextPDAs = this.pdaProvider.getContextPDAs(grammar);
        for (SerializationContextMap.Entry<Pda<ISerState, RuleCall>> e : contextPDAs.values()) {
            List<ISerializationContext> parents = e.getContexts();
            Pda<ISerState, RuleCall> contextPDA = e.getValue();
            try {
                Map<ISerState, Integer> distances = this.nfaUtil.distanceToFinalStateMap(contextPDA);
                Set<EClass> types = this.collectTypes(contextPDA, distances);
                if (types.size() == 1) {
                    for (ISerializationContext parent : parents) {
                        SerializationContext.TypeContext ctx = new SerializationContext.TypeContext(parent, types.iterator().next());
                        builder.put(ctx, contextPDA);
                    }
                    continue;
                }
                for (EClass type : types) {
                    Pda<ISerState, RuleCall> filtered = this.filterByType(contextPDA, type, distances);
                    for (ISerializationContext parent : parents) {
                        SerializationContext.TypeContext typeContext = new SerializationContext.TypeContext(parent, type);
                        builder.put(typeContext, filtered);
                    }
                }
            }
            catch (Exception x) {
                LOG.error("Error extracting PDAs for types for context '" + parents + "': " + x.getMessage(), x);
            }
        }
        SerializationContextMap<Pda<ISerState, RuleCall>> result = builder.create();
        this.cache.put(grammar, result);
        return result;
    }

    protected TypeCollector newTypeCollector() {
        return new TypeCollector();
    }

    protected TypeFilter newTypeFilter(EClass type) {
        return new TypeFilter(type);
    }

    protected static class TypeFilter
    extends AbstractTypeTraverser {
        protected final EClass type;

        public TypeFilter(EClass type) {
            this.type = type;
        }

        @Override
        protected FilterState enterType(ISerState state, FilterState previous, StackItem stack, EClass newType) {
            if (newType == this.type) {
                return new FilterState(previous, this.type, stack, state);
            }
            return null;
        }

        @Override
        public boolean isSolution(FilterState result) {
            return result.type == this.type;
        }
    }

    protected static class TypeCollector
    extends AbstractTypeTraverser {
        protected final Set<EClass> types = Sets.newLinkedHashSet();

        protected TypeCollector() {
        }

        @Override
        protected FilterState enterType(ISerState state, FilterState previous, StackItem stack, EClass newType) {
            this.types.add(newType);
            return null;
        }

        public Set<EClass> getTypes() {
            return this.types;
        }

        @Override
        public boolean isSolution(FilterState result) {
            this.types.add(null);
            return false;
        }
    }

    protected static class StackItem {
        protected final StackItem parent;
        protected final RuleCall rc;

        public StackItem(StackItem parent, RuleCall rc) {
            this.parent = parent;
            this.rc = rc;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StackItem current1 = this;
            StackItem current2 = (StackItem)obj;
            int count = 0;
            while (current1 != null || current2 != null) {
                if (current1 == null || current2 == null) {
                    return false;
                }
                if (current1.rc != current2.rc) {
                    return false;
                }
                if (current1 != this && current1.rc == this.rc) {
                    ++count;
                }
                if (count > 0) {
                    return true;
                }
                current1 = current1.parent;
                current2 = current2.parent;
            }
            return true;
        }

        public int hashCode() {
            return this.rc.hashCode();
        }
    }

    protected static class FilterState {
        protected final FilterState previous;
        protected final StackItem stack;
        protected final ISerState state;
        protected final EClass type;

        public FilterState(FilterState previous, EClass type, StackItem stack, ISerState state) {
            this.previous = previous;
            this.type = type;
            this.stack = stack;
            this.state = state;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FilterState other = (FilterState)obj;
            if (this.type != other.type || this.state != other.state) {
                return false;
            }
            if (this.stack == null) {
                return other.stack == null;
            }
            return this.stack.equals(other.stack);
        }

        public int hashCode() {
            int r = this.state.getType().hashCode();
            if (this.state.getGrammarElement() != null) {
                r *= this.state.getGrammarElement().hashCode();
            }
            if (this.type != null) {
                r *= this.type.hashCode() * 7;
            }
            if (this.stack != null) {
                r *= this.stack.rc.hashCode() * 13;
            }
            return r;
        }
    }

    protected static abstract class AbstractTypeTraverser
    implements Traverser<Pda<ISerState, RuleCall>, ISerState, FilterState> {
        protected AbstractTypeTraverser() {
        }

        @Override
        public FilterState enter(Pda<ISerState, RuleCall> pda, ISerState state, FilterState previous) {
            switch (state.getType()) {
                case ELEMENT: {
                    if (previous.type == null) {
                        EClass cls = this.getInstantiatedType(state.getGrammarElement());
                        if (cls != null) {
                            return this.enterType(state, previous, previous.stack, cls);
                        }
                    } else if (state.getGrammarElement() instanceof Action) {
                        return null;
                    }
                    return new FilterState(previous, previous.type, previous.stack, state);
                }
                case POP: {
                    if (previous.stack != null && state.getGrammarElement() == previous.stack.rc) {
                        return new FilterState(previous, previous.type, previous.stack.parent, state);
                    }
                    return null;
                }
                case PUSH: {
                    EClass cls;
                    RuleCall rc = (RuleCall)state.getGrammarElement();
                    if (previous.type == null && (cls = this.getInstantiatedType(rc)) != null) {
                        return this.enterType(state, previous, new StackItem(previous.stack, rc), cls);
                    }
                    return new FilterState(previous, previous.type, new StackItem(previous.stack, rc), state);
                }
                case START: {
                    return new FilterState(previous, null, null, state);
                }
                case STOP: {
                    if (previous.stack == null) {
                        return previous;
                    }
                    return null;
                }
            }
            return null;
        }

        protected abstract FilterState enterType(ISerState var1, FilterState var2, StackItem var3, EClass var4);

        protected EClass getInstantiatedType(AbstractElement element) {
            EClassifier classifier;
            TypeRef type = null;
            if (GrammarUtil.isAssigned(element) || GrammarUtil.isEObjectFragmentRuleCall(element)) {
                type = GrammarUtil.containingRule(element).getType();
            } else if (element instanceof Action) {
                type = ((Action)element).getType();
            }
            if (type != null && (classifier = type.getClassifier()) instanceof EClass && !classifier.eIsProxy()) {
                return (EClass)classifier;
            }
            return null;
        }

        @Override
        public boolean isSolution(FilterState result) {
            return true;
        }
    }
}

