/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Objects;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializationExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class SerializableReferenceDescription
implements IReferenceDescription,
Externalizable {
    private URI sourceEObjectUri;
    private URI targetEObjectUri;
    private URI containerEObjectURI;
    private EReference eReference;
    private int indexInList;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sourceEObjectUri = SerializationExtensions.readURI(in);
        this.targetEObjectUri = SerializationExtensions.readURI(in);
        this.containerEObjectURI = SerializationExtensions.readURI(in);
        this.eReference = (EReference)SerializationExtensions.readEcoreElement(in);
        this.indexInList = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializationExtensions.writeURI(out, this.sourceEObjectUri);
        SerializationExtensions.writeURI(out, this.targetEObjectUri);
        SerializationExtensions.writeURI(out, this.containerEObjectURI);
        SerializationExtensions.writeEcoreElement(out, this.eReference);
        out.writeInt(this.indexInList);
    }

    public void updateResourceURI(URI newURI, URI oldURI) {
        this.sourceEObjectUri = newURI.appendFragment(this.sourceEObjectUri.fragment());
        URI _trimFragment = this.targetEObjectUri.trimFragment();
        boolean _equals = Objects.equal(_trimFragment, oldURI);
        if (_equals) {
            this.targetEObjectUri = newURI.appendFragment(this.targetEObjectUri.fragment());
        }
    }

    @Override
    @Pure
    public URI getSourceEObjectUri() {
        return this.sourceEObjectUri;
    }

    public void setSourceEObjectUri(URI sourceEObjectUri) {
        this.sourceEObjectUri = sourceEObjectUri;
    }

    @Override
    @Pure
    public URI getTargetEObjectUri() {
        return this.targetEObjectUri;
    }

    public void setTargetEObjectUri(URI targetEObjectUri) {
        this.targetEObjectUri = targetEObjectUri;
    }

    @Override
    @Pure
    public URI getContainerEObjectURI() {
        return this.containerEObjectURI;
    }

    public void setContainerEObjectURI(URI containerEObjectURI) {
        this.containerEObjectURI = containerEObjectURI;
    }

    @Override
    @Pure
    public EReference getEReference() {
        return this.eReference;
    }

    public void setEReference(EReference eReference) {
        this.eReference = eReference;
    }

    @Override
    @Pure
    public int getIndexInList() {
        return this.indexInList;
    }

    public void setIndexInList(int indexInList) {
        this.indexInList = indexInList;
    }
}

