/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.antlr;

import com.google.common.collect.Lists;
import com.google.inject.ImplementedBy;
import java.util.ArrayList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@ImplementedBy(value=GenericUnloader.class)
public interface IReferableElementsUnloader {
    public void unloadRoot(EObject var1);

    public static class GenericUnloader
    implements IReferableElementsUnloader {
        @Override
        public void unloadRoot(EObject root) {
            ArrayList<Pair<EObject, URI>> elementsToUnload = Lists.newArrayList();
            elementsToUnload.add(Tuples.create(root, EcoreUtil.getURI(root)));
            root.eAdapters().clear();
            TreeIterator i = EcoreUtil.getAllProperContents(root, false);
            while (i.hasNext()) {
                EObject eObject = (EObject)i.next();
                elementsToUnload.add(Tuples.create(eObject, EcoreUtil.getURI(eObject)));
                eObject.eAdapters().clear();
            }
            for (Pair pair : elementsToUnload) {
                ((InternalEObject)pair.getFirst()).eSetProxyURI((URI)pair.getSecond());
            }
        }
    }

    public static final class NullUnloader
    implements IReferableElementsUnloader {
        @Override
        public void unloadRoot(EObject root) {
        }
    }
}

