/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtext.parser.antlr.IAntlrTokenFileProvider;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.util.Strings;

@Singleton
public class AntlrTokenDefProvider
implements ITokenDefProvider {
    private static final Logger log = Logger.getLogger(AntlrTokenDefProvider.class);
    @Inject
    private IAntlrTokenFileProvider antlrTokenFileProvider;
    protected volatile Map<Integer, String> tokenDefMap;

    @Override
    public Map<Integer, String> getTokenDefMap() {
        if (this.antlrTokenFileProvider == null) {
            return Collections.emptyMap();
        }
        if (this.tokenDefMap == null) {
            InputStream tokenFile = this.antlrTokenFileProvider.getAntlrTokenFile();
            try {
                BufferedReader br = this.createReader(tokenFile);
                HashMap<Integer, String> tokenDefMap = new HashMap<Integer, String>();
                String line = br.readLine();
                Pattern pattern = Pattern.compile("(.*)=(\\d+)");
                while (line != null) {
                    Matcher m3 = pattern.matcher(line);
                    if (!m3.matches()) {
                        throw new IllegalStateException("Couldn't match line : '" + line + "'");
                    }
                    int antlrTokenType = Integer.parseInt(m3.group(2));
                    String antlrTokenDef = m3.group(1);
                    if (antlrTokenDef.startsWith("'")) {
                        antlrTokenDef = antlrTokenDef.substring(1, antlrTokenDef.length() - 1);
                        antlrTokenDef = Strings.convertFromJavaString(antlrTokenDef, true);
                        antlrTokenDef = "'" + antlrTokenDef + "'";
                        tokenDefMap.put(antlrTokenType, antlrTokenDef);
                    } else if (antlrTokenDef.startsWith("RULE_") || this.isKeywordToken(antlrTokenDef) || antlrTokenDef.startsWith("SUPER_")) {
                        tokenDefMap.put(antlrTokenType, antlrTokenDef);
                    }
                    line = br.readLine();
                }
                this.setTokenDefMap(tokenDefMap);
            }
            catch (Exception e) {
                log.error(e, e);
                this.tokenDefMap = null;
                throw new WrappedException(e);
            }
            finally {
                try {
                    tokenFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.tokenDefMap;
    }

    protected boolean isKeywordToken(String antlrTokenDef) {
        return antlrTokenDef.startsWith("KEYWORD_");
    }

    protected BufferedReader createReader(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream));
    }

    protected void setTokenDefMap(Map<Integer, String> tokenDefMap) {
        this.tokenDefMap = ImmutableMap.copyOf(tokenDefMap);
    }

    public void setAntlrTokenFileProvider(IAntlrTokenFileProvider antlrTokenFileProvider) {
        this.antlrTokenFileProvider = antlrTokenFileProvider;
    }

    public IAntlrTokenFileProvider getAntlrTokenFileProvider() {
        return this.antlrTokenFileProvider;
    }
}

