/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.debug;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.formatting2.debug.TextRegionListToString;
import org.eclipse.xtext.formatting2.regionaccess.IAstRegion;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccessDiff;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegmentDiff;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.util.EmfFormatter;

public class TextRegionAccessToString {
    private static final int TITLE_WIDTH = 2;
    private static final String EMPTY_TITLE = Strings.repeat(" ", 2);
    private static final String EOBJECT_BEGIN_PADDED = Strings.padEnd("B", 2, ' ');
    private static final String EOBJECT_END_PADDED = Strings.padEnd("E", 2, ' ');
    private static final String HIDDEN = "H";
    private static final String HIDDEN_PADDED = Strings.padEnd("H", 2, ' ');
    private static final String SEMANTIC_PADDED = Strings.padEnd("S", 2, ' ');
    private Function<AbstractElement, String> grammarToString = new GrammarElementTitleSwitch().showRule().showAssignments().showQualified();
    private boolean hideColumnExplanation = false;
    private boolean hideIndentation = false;
    private boolean hightlightOrigin = false;
    private ITextSegment origin;
    private int textWidth = 20;

    protected void appendRegions(TextRegionListToString result, List<ITextSegment> list, DiffColumn diff, boolean isDiffAppendix) {
        LinkedListMultimap<IHiddenRegion, IEObjectRegion> hiddens = LinkedListMultimap.create();
        ArrayList<String> errors = Lists.newArrayList();
        ITextRegionAccess access = list.get(0).getTextRegionAccess();
        TreeIterator<EObject> all = EcoreUtil2.eAll(access.regionForRootEObject().getSemanticElement());
        while (all.hasNext()) {
            EObject element = (EObject)all.next();
            IEObjectRegion obj = access.regionForEObject(element);
            if (obj == null) continue;
            IHiddenRegion previous = obj.getPreviousHiddenRegion();
            IHiddenRegion next = obj.getNextHiddenRegion();
            if (previous == null) {
                errors.add("ERROR: " + EmfFormatter.objPath(element) + " has no leading HiddenRegion.");
            } else {
                hiddens.put(previous, obj);
            }
            if (previous == next) continue;
            if (next == null) {
                errors.add("ERROR: " + EmfFormatter.objPath(element) + " has no trailing HiddenRegion.");
                continue;
            }
            hiddens.put(next, obj);
        }
        for (String error : errors) {
            result.add(error, false);
        }
        int indentation = 0;
        int min2 = 0;
        for (ITextSegment region : list) {
            if (!(region instanceof IHiddenRegion)) continue;
            Collection found = hiddens.get((IHiddenRegion)region);
            for (IEObjectRegion obj : found) {
                boolean p = region.equals(obj.getNextHiddenRegion());
                boolean n = region.equals(obj.getPreviousHiddenRegion());
                if (p) {
                    --indentation;
                } else if (n) {
                    ++indentation;
                }
                if (indentation >= min2) continue;
                min2 = indentation;
            }
        }
        indentation = min2 < 0 ? min2 * -1 : 0;
        for (ITextSegment region : list) {
            ArrayList<IEObjectRegion> previous = Lists.newArrayList();
            ArrayList<IEObjectRegion> next = Lists.newArrayList();
            ArrayList<String> middle = Lists.newArrayList(this.toString(region));
            if (region instanceof IHiddenRegion) {
                Collection found = hiddens.get((IHiddenRegion)region);
                Iterator n = found.iterator();
                while (n.hasNext()) {
                    IEObjectRegion obj = (IEObjectRegion)n.next();
                    boolean p = region.equals(obj.getNextHiddenRegion());
                    boolean n2 = region.equals(obj.getPreviousHiddenRegion());
                    if (p && n2) {
                        middle.add(EMPTY_TITLE + "Semantic " + this.toString(obj));
                        continue;
                    }
                    if (p) {
                        previous.add(obj);
                        continue;
                    }
                    if (!n2) continue;
                    next.add(obj);
                }
                Collections.sort(previous, AstRegionComparator.CHILDREN_FIRST);
                Collections.sort(next, AstRegionComparator.CONTAINER_FIRST);
            }
            if (!isDiffAppendix) {
                for (IEObjectRegion obj : previous) {
                    result.add(diff.empty + this.indent(--indentation) + EOBJECT_END_PADDED + this.toString(obj));
                }
            }
            String indent = this.indent(indentation);
            result.add(region, diff.get(region) + indent + Joiner.on("\n").join(middle).replace("\n", "\n" + indent));
            if (isDiffAppendix) continue;
            for (IEObjectRegion obj : next) {
                result.add(diff.empty + this.indent(indentation) + EOBJECT_BEGIN_PADDED + this.toString(obj));
                ++indentation;
            }
        }
    }

    public int getTextWidth() {
        return this.textWidth;
    }

    public TextRegionAccessToString hideColumnExplanation() {
        this.hideColumnExplanation = true;
        return this;
    }

    public TextRegionAccessToString hideIndentation() {
        this.hideIndentation = true;
        return this;
    }

    public TextRegionAccessToString hightlightOrigin() {
        this.hightlightOrigin = true;
        return this;
    }

    protected String indent(int indentation) {
        if (this.hideIndentation) {
            return "";
        }
        return Strings.repeat(" ", indentation);
    }

    public boolean isHideColumnExplanation() {
        return this.hideColumnExplanation;
    }

    public boolean isHideIndentation() {
        return this.hideIndentation;
    }

    public boolean isHightlightOrigin() {
        return this.hightlightOrigin;
    }

    protected String quote(String string) {
        if (string == null) {
            return "null";
        }
        string = string.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
        int textLen = this.textWidth - 2;
        if (string.length() > textLen) {
            return "\"" + string.substring(0, textLen - 3) + "...\"";
        }
        return Strings.padEnd("\"" + string + "\"", this.textWidth, ' ');
    }

    protected String toClassWithName(EObject obj) {
        Object name;
        String className = obj.eClass().getName();
        EStructuralFeature nameFeature = obj.eClass().getEStructuralFeature("name");
        if (nameFeature != null && (name = obj.eGet(nameFeature)) != null) {
            return className + "'" + name + "'";
        }
        return className;
    }

    public String toString() {
        List<ITextSegment> list = this.toTokenAndGapList();
        if (list.isEmpty()) {
            return "(empty)";
        }
        ITextRegionAccess access = list.get(0).getTextRegionAccess();
        DiffColumn diff = new DiffColumn(access);
        TextRegionListToString result = new TextRegionListToString();
        if (!this.hideColumnExplanation) {
            if (diff.isDiff()) {
                result.add("Columns: 1:offset 2:length 3:diff 4:kind 5: text 6:grammarElement", false);
            } else {
                result.add("Columns: 1:offset 2:length 3:kind 4: text 5:grammarElement", false);
            }
            result.add("Kind: H=IHiddenRegion S=ISemanticRegion B/E=IEObjectRegion", false);
            result.add("", false);
        }
        this.appendRegions(result, list, diff, false);
        diff.appendDiffs(result, this);
        return result.toString();
    }

    protected String toString(AbstractRule rule) {
        return rule == null ? "null" : rule.getName();
    }

    protected String toString(EObject ele) {
        if (ele instanceof AbstractElement) {
            return this.grammarToString.apply((AbstractElement)ele);
        }
        if (ele instanceof AbstractRule) {
            return ele.eClass().getName() + "'" + ((AbstractRule)ele).getName() + "'";
        }
        return ele.toString();
    }

    protected String toString(IComment comment) {
        String text = this.quote(comment.getText());
        String gammar = this.toString(comment.getGrammarElement());
        String association = (Object)((Object)comment.getAssociation()) + "";
        return String.format("%s Comment:%s Association:%s", text, gammar, association);
    }

    protected String toString(IEObjectRegion region) {
        EObject obj = region.getSemanticElement();
        StringBuilder builder = new StringBuilder(Strings.padEnd(this.toClassWithName(obj), this.textWidth, ' ') + " ");
        EObject element = region.getGrammarElement();
        if (element instanceof AbstractElement) {
            builder.append(this.grammarToString.apply((AbstractElement)element));
        } else if (element instanceof AbstractRule) {
            builder.append(((AbstractRule)element).getName());
        } else {
            builder.append(": ERROR: No grammar element.");
        }
        ArrayList<String> segments = Lists.newArrayList();
        EObject current = obj;
        while (current.eContainer() != null) {
            EObject container = current.eContainer();
            EStructuralFeature containingFeature = current.eContainingFeature();
            StringBuilder segment = new StringBuilder();
            segment.append(this.toClassWithName(container));
            segment.append("/");
            segment.append(containingFeature.getName());
            if (containingFeature.isMany()) {
                int index = ((List)container.eGet(containingFeature)).indexOf(current);
                segment.append("[" + index + "]");
            }
            current = container;
            segments.add(segment.toString());
        }
        if (!segments.isEmpty()) {
            builder.append(" path:");
            builder.append(Joiner.on("=").join(segments));
        }
        return builder.toString();
    }

    protected String toString(IHiddenRegion hiddens) {
        List<IHiddenRegionPart> parts = hiddens.getParts();
        if (parts.isEmpty()) {
            return HIDDEN;
        }
        ArrayList<String> children = Lists.newArrayListWithExpectedSize(parts.size());
        children.add(HIDDEN_PADDED + this.toString(parts.get(0)));
        for (int i = 1; i < parts.size(); ++i) {
            children.add(EMPTY_TITLE + this.toString(parts.get(i)));
        }
        return Joiner.on("\n").join(children);
    }

    protected String toString(ISemanticRegion token) {
        String text = this.quote(token.getText());
        return String.format("%s%s %s", SEMANTIC_PADDED, text, this.toString(token.getGrammarElement()));
    }

    protected String toString(ITextSegment region) {
        String result = region instanceof IEObjectRegion ? this.toString((IEObjectRegion)region) : (region instanceof ISemanticRegion ? this.toString((ISemanticRegion)region) : (region instanceof IHiddenRegion ? this.toString((IHiddenRegion)region) : (region instanceof IWhitespace ? this.toString((IWhitespace)region) : (region instanceof IComment ? this.toString((IComment)region) : (region != null ? region.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(region)) : "null")))));
        if (this.hightlightOrigin && region == this.origin) {
            return ">>>" + result + "<<<";
        }
        return result;
    }

    protected String toString(IWhitespace whitespace) {
        String text = this.quote(whitespace.getText());
        String grammar = this.toString(whitespace.getGrammarElement());
        return String.format("%s Whitespace:%s", text, grammar);
    }

    protected List<ITextSegment> toTokenAndGapList() {
        int range = this.hightlightOrigin ? 4 : 0x3FFFFFFF;
        ITextSegment first = null;
        ITextSegment current = this.origin;
        for (int i = 0; i < range && current != null; ++i) {
            first = current;
            if (current instanceof ITextRegionAccess) {
                current = ((ITextRegionAccess)((Object)current)).regionForRootEObject().getPreviousHiddenRegion();
                continue;
            }
            if (current instanceof ISequentialRegion) {
                current = ((ISequentialRegion)current).getPreviousHiddenRegion();
                continue;
            }
            if (current instanceof IHiddenRegionPart) {
                current = ((IHiddenRegionPart)current).getHiddenRegion();
                continue;
            }
            throw new IllegalStateException("Unexpected Type: " + current.getClass());
        }
        if (first == null) {
            return Collections.emptyList();
        }
        ArrayList<ITextSegment> result = Lists.newArrayList();
        ITextSegment current2 = first;
        for (int i = 0; i <= range * 2 && current2 != null; ++i) {
            result.add(current2);
            if (current2 instanceof ISemanticRegion) {
                current2 = ((ISemanticRegion)current2).getNextHiddenRegion();
                continue;
            }
            if (current2 instanceof IHiddenRegion) {
                current2 = ((IHiddenRegion)current2).getNextSemanticRegion();
                continue;
            }
            throw new IllegalStateException("Unexpected Type: " + current2.getClass());
        }
        return result;
    }

    public TextRegionAccessToString withOrigin(ITextSegment origin) {
        this.origin = origin;
        return this;
    }

    public TextRegionAccessToString withRegionAccess(ITextRegionAccess access) {
        this.origin = access.regionForRootEObject();
        this.hightlightOrigin = false;
        return this;
    }

    public TextRegionAccessToString withTextWidth(int width) {
        this.textWidth = width;
        return this;
    }

    protected static class DiffColumn {
        private ITextRegionAccessDiff access;
        private Map<ITextSegment, String> diffs;
        private String empty;

        protected ISequentialRegion toSequential(ITextSegment seg) {
            if (seg instanceof ISequentialRegion) {
                return (ISequentialRegion)seg;
            }
            if (seg instanceof IHiddenRegionPart) {
                return ((IHiddenRegionPart)seg).getHiddenRegion();
            }
            throw new IllegalStateException();
        }

        public DiffColumn(ITextRegionAccess access) {
            if (access instanceof ITextRegionAccessDiff) {
                this.diffs = Maps.newHashMap();
                this.access = (ITextRegionAccessDiff)access;
                int width = 0;
                int i = 1;
                for (ITextSegmentDiff diff : this.access.getRegionDifferences()) {
                    ISequentialRegion current = this.toSequential(diff.getModifiedFirstRegion());
                    ISequentialRegion last = this.toSequential(diff.getModifiedLastRegion());
                    String text = i + " ";
                    if (width < text.length()) {
                        width = text.length();
                    }
                    while (current != null) {
                        this.diffs.put(current, text);
                        if (current.getOffset() >= last.getOffset()) break;
                        current = current.getNextSequentialRegion();
                    }
                    ++i;
                }
                this.empty = Strings.repeat(" ", width);
            } else {
                this.access = null;
                this.empty = "";
            }
        }

        public void appendDiffs(TextRegionListToString result, TextRegionAccessToString toStr) {
            if (this.access == null) {
                return;
            }
            int i = 1;
            for (ITextSegmentDiff diff : this.access.getRegionDifferences()) {
                ISequentialRegion last = this.toSequential(diff.getOriginalLastRegion());
                ArrayList<ITextSegment> regions = Lists.newArrayList();
                for (ISequentialRegion current = this.toSequential(diff.getOriginalFirstRegion()); current != null; current = current.getNextSequentialRegion()) {
                    regions.add(current);
                    if (current.getOffset() >= last.getOffset()) break;
                }
                result.add("------------ diff " + i + " ------------", false);
                toStr.appendRegions(result, regions, new DiffColumn(null), true);
                ++i;
            }
        }

        public String get(ITextSegment seg) {
            if (this.access == null) {
                return "";
            }
            String result = this.diffs.get(seg);
            if (result != null) {
                return result;
            }
            return this.empty;
        }

        public boolean isDiff() {
            return this.access != null;
        }
    }

    protected static enum AstRegionComparator implements Comparator<IAstRegion>
    {
        CHILDREN_FIRST{

            @Override
            public int compare(IAstRegion o1, IAstRegion o2) {
                EObject e2;
                EObject e1 = o1.getSemanticElement();
                if (e1 == (e2 = o2.getSemanticElement())) {
                    return 0;
                }
                if (EcoreUtil.isAncestor(e1, e2)) {
                    return 1;
                }
                return -1;
            }
        }
        ,
        CONTAINER_FIRST{

            @Override
            public int compare(IAstRegion o1, IAstRegion o2) {
                EObject e2;
                EObject e1 = o1.getSemanticElement();
                if (e1 == (e2 = o2.getSemanticElement())) {
                    return 0;
                }
                if (EcoreUtil.isAncestor(e1, e2)) {
                    return -1;
                }
                return 1;
            }
        };

    }
}

