/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryErasureTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeArgumentSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeParameter;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.SignatureUtil;

public class BinaryGenericTypeSignature
extends BinaryTypeSignature {
    BinaryGenericTypeSignature(String chars) {
        super(chars);
    }

    BinaryGenericTypeSignature(String chars, int offset, int length) {
        super(chars, offset, length);
    }

    @Override
    public String toIdentifier() {
        StringBuilder result = new StringBuilder(this.chars.length());
        this.toIdentifier(result, 1);
        return result.toString();
    }

    @Override
    public BinaryGenericTypeSignature getArrayComponentType() {
        int dimensions = this.getArrayDimensions();
        if (dimensions == 0) {
            return this;
        }
        return new BinaryGenericTypeSignature(this.chars, this.offset + dimensions, this.length - dimensions);
    }

    @Override
    public List<BinaryTypeArgumentSignature> getTypeArguments() {
        if (this.length < 2 || this.chars.charAt(this.offset + this.length - 2) != '>') {
            return Collections.emptyList();
        }
        int count = 1;
        int start = this.offset + this.length - 2;
        while (start >= this.offset && count > 0) {
            switch (this.chars.charAt(--start)) {
                case '<': {
                    --count;
                    break;
                }
                case '>': {
                    ++count;
                }
            }
        }
        if (start < 0) {
            throw new IllegalArgumentException(this.toString());
        }
        ArrayList<BinaryTypeArgumentSignature> result = Lists.newArrayListWithExpectedSize(2);
        int p = start + 1;
        while (true) {
            if (p >= this.offset + this.length) {
                throw new IllegalArgumentException(this.toString());
            }
            char c = this.chars.charAt(p);
            if (c == '>') {
                return result;
            }
            int end = SignatureUtil.scanTypeSignature(this.chars, p);
            result.add(new BinaryTypeArgumentSignature(this.chars, p, end + 1 - p));
            p = end + 1;
        }
    }

    @Override
    public BinaryTypeSignature getOuter() {
        int startFrom = this.offset;
        int end = -1;
        while (true) {
            int typeArgsIdx;
            if ((typeArgsIdx = this.chars.indexOf(60, startFrom)) == -1 || typeArgsIdx > this.offset + this.length) {
                if (end == -1) {
                    return null;
                }
                return new BinaryGenericTypeSignature(this.chars, this.offset, end - this.offset + 2);
            }
            int count = 1;
            int i = typeArgsIdx;
            while (count > 0) {
                switch (this.chars.charAt(++i)) {
                    case '<': {
                        ++count;
                        break;
                    }
                    case '>': {
                        --count;
                    }
                }
            }
            if (i != this.offset + this.length - 2) {
                end = i;
            }
            startFrom = i;
        }
    }

    @Override
    public BinaryGenericTypeSignature getTypeErasure() {
        int end = this.chars.indexOf(60, this.offset);
        if (end == -1 || end > this.offset + this.length) {
            return this;
        }
        return new BinaryErasureTypeSignature(this, this.getArrayDimensions());
    }

    @Override
    public List<BinaryTypeParameter> getTypeParameters() {
        return this.doGetTypeParameters();
    }

    @Override
    public String getTypeVariableName() {
        if (this.chars.charAt(this.offset) == 'T') {
            return this.chars.substring(this.offset + 1, this.offset + this.length - 1);
        }
        return null;
    }

    public boolean isEqualToSignature(String string) {
        return this.chars.regionMatches(this.offset, string, 0, string.length());
    }
}

