/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.build.BuildContext;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.build.Indexer;
import org.eclipse.xtext.build.Source2GeneratedMapping;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider2;
import org.eclipse.xtext.generator.IFilePostProcessor;
import org.eclipse.xtext.generator.IShouldGenerate;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.URIBasedFileSystemAccess;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.DisabledClusteringPolicy;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class IncrementalBuilder {
    @Inject
    private Provider<InternalStatefulIncrementalBuilder> provider;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public Result build(BuildRequest request, Functions.Function1<? super URI, ? extends IResourceServiceProvider> languages) {
        return this.build(request, languages, new DisabledClusteringPolicy());
    }

    public Result build(BuildRequest request, Functions.Function1<? super URI, ? extends IResourceServiceProvider> languages, IResourceClusteringPolicy clusteringPolicy) {
        XtextResourceSet resourceSet = request.getResourceSet();
        IndexState oldState = new IndexState(request.getState().getResourceDescriptions().copy(), request.getState().getFileMappings().copy());
        BuildContext context = new BuildContext(languages, resourceSet, oldState, clusteringPolicy, request.getCancelIndicator());
        InternalStatefulIncrementalBuilder builder = this.provider.get();
        builder.setContext(context);
        builder.setRequest(request);
        try {
            return builder.launch();
        }
        catch (Throwable t) {
            this.operationCanceledManager.propagateIfCancelException(t);
            throw t;
        }
    }

    public static class InternalStatefulIncrementalBuilder {
        private BuildContext context;
        private BuildRequest request;
        @Inject
        private Indexer indexer;
        @Inject
        private OperationCanceledManager operationCanceledManager;

        protected void unloadResource(URI uri) {
            XtextResourceSet resourceSet = this.request.getResourceSet();
            Resource resource = resourceSet.getResource(uri, false);
            if (resource != null) {
                resourceSet.getResources().remove(resource);
                resource.unload();
            }
        }

        public Result launch() {
            Source2GeneratedMapping newSource2GeneratedMapping = this.request.getState().getFileMappings();
            HashSet<URI> unloaded = new HashSet<URI>();
            for (URI deleted : this.request.getDeletedFiles()) {
                if (!unloaded.add(deleted)) continue;
                this.unloadResource(deleted);
            }
            for (URI dirty : this.request.getDirtyFiles()) {
                if (!unloaded.add(dirty)) continue;
                this.unloadResource(dirty);
            }
            for (URI source : this.request.getDeletedFiles()) {
                this.request.getAfterValidate().afterValidate(source, Collections.emptyList());
                Map<URI, String> outputConfigs = newSource2GeneratedMapping.deleteSourceAndGetOutputConfigs(source);
                for (URI generated : outputConfigs.keySet()) {
                    IResourceServiceProvider serviceProvider = this.context.getResourceServiceProvider(source);
                    XtextResourceSet resourceSet = this.request.getResourceSet();
                    Set<OutputConfiguration> configs = serviceProvider.get(IContextualOutputConfigurationProvider2.class).getOutputConfigurations(resourceSet);
                    String configName = (String)outputConfigs.get(generated);
                    OutputConfiguration config = FluentIterable.from(configs).firstMatch(it -> it.getName().equals(configName)).orNull();
                    if (config == null || !config.isCleanUpDerivedResources()) continue;
                    try {
                        resourceSet.getURIConverter().delete(generated, Collections.emptyMap());
                        this.request.getAfterDeleteFile().apply(generated);
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException(e);
                    }
                }
            }
            Indexer.IndexResult result = this.indexer.computeAndIndexAffected(this.request, this.context);
            this.operationCanceledManager.checkCanceled(this.request.getCancelIndicator());
            ArrayList<IResourceDescription.Delta> resolvedDeltas = new ArrayList<IResourceDescription.Delta>();
            for (IResourceDescription.Delta delta : result.getResourceDeltas()) {
                URI uri = delta.getUri();
                if (delta.getOld() != null && unloaded.add(uri)) {
                    this.unloadResource(uri);
                }
                if (delta.getNew() != null) continue;
                resolvedDeltas.add(delta);
            }
            Iterable<IResourceDescription.Delta> deltas = this.context.executeClustered(FluentIterable.from(result.getResourceDeltas()).filter(it -> it.getNew() != null).transform(IResourceDescription.Delta::getUri), resource -> {
                CancelIndicator cancelIndicator = this.request.getCancelIndicator();
                this.operationCanceledManager.checkCanceled(cancelIndicator);
                resource.getContents();
                EcoreUtil2.resolveLazyCrossReferences(resource, CancelIndicator.NullImpl);
                this.operationCanceledManager.checkCanceled(cancelIndicator);
                IResourceServiceProvider serviceProvider = this.getResourceServiceProvider((Resource)resource);
                IResourceDescription.Manager manager = serviceProvider.getResourceDescriptionManager();
                IResourceDescription description = manager.getResourceDescription((Resource)resource);
                SerializableResourceDescription copiedDescription = SerializableResourceDescription.createCopy(description);
                result.getNewIndex().addDescription(resource.getURI(), copiedDescription);
                this.operationCanceledManager.checkCanceled(cancelIndicator);
                if (!this.request.isIndexOnly() && this.validate((Resource)resource) && serviceProvider.get(IShouldGenerate.class).shouldGenerate((Resource)resource, CancelIndicator.NullImpl)) {
                    this.operationCanceledManager.checkCanceled(cancelIndicator);
                    this.generate((Resource)resource, this.request, newSource2GeneratedMapping);
                }
                IResourceDescription old = this.context.getOldState().getResourceDescriptions().getResourceDescription(resource.getURI());
                return manager.createDelta(old, copiedDescription);
            });
            Iterables.addAll(resolvedDeltas, deltas);
            return new Result(this.request.getState(), resolvedDeltas);
        }

        private IResourceServiceProvider getResourceServiceProvider(Resource resource) {
            if (resource instanceof XtextResource) {
                return ((XtextResource)resource).getResourceServiceProvider();
            }
            return this.context.getResourceServiceProvider(resource.getURI());
        }

        protected boolean validate(Resource resource) {
            IResourceValidator resourceValidator = this.getResourceServiceProvider(resource).getResourceValidator();
            if (resourceValidator == null) {
                return true;
            }
            List<Issue> validationResult = resourceValidator.validate(resource, CheckMode.ALL, this.request.getCancelIndicator());
            return this.request.getAfterValidate().afterValidate(resource.getURI(), validationResult);
        }

        protected void generate(Resource resource, BuildRequest request, Source2GeneratedMapping newMappings) {
            IResourceStorageFacade resourceStorageFacade;
            IResourceServiceProvider serviceProvider = this.getResourceServiceProvider(resource);
            GeneratorDelegate generator = serviceProvider.get(GeneratorDelegate.class);
            if (generator == null) {
                return;
            }
            Set<URI> previous = newMappings.deleteSource(resource.getURI());
            URIBasedFileSystemAccess fileSystemAccess = this.createFileSystemAccess(serviceProvider, resource);
            fileSystemAccess.setBeforeWrite((uri, outputCfgName, contents) -> {
                newMappings.addSource2Generated(resource.getURI(), uri, outputCfgName);
                previous.remove(uri);
                request.getAfterGenerateFile().apply(resource.getURI(), uri);
                return contents;
            });
            fileSystemAccess.setBeforeDelete(uri -> {
                newMappings.deleteGenerated(uri);
                request.getAfterDeleteFile().apply(uri);
                return true;
            });
            fileSystemAccess.setContext(resource);
            if (request.isWriteStorageResources() && resource instanceof StorageAwareResource && (resourceStorageFacade = ((StorageAwareResource)resource).getResourceStorageFacade()) != null) {
                resourceStorageFacade.saveResource((StorageAwareResource)resource, fileSystemAccess);
            }
            GeneratorContext generatorContext = new GeneratorContext();
            generatorContext.setCancelIndicator(request.getCancelIndicator());
            generator.generate(resource, fileSystemAccess, generatorContext);
            XtextResourceSet resourceSet = request.getResourceSet();
            for (URI noLongerCreated : previous) {
                try {
                    resourceSet.getURIConverter().delete(noLongerCreated, Collections.emptyMap());
                    request.getAfterDeleteFile().apply(noLongerCreated);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }

        protected URIBasedFileSystemAccess createFileSystemAccess(IResourceServiceProvider serviceProvider, Resource resource) {
            return serviceProvider.get(URIBasedFileSystemAccessFactory.class).newFileSystemAccess(resource, this.request);
        }

        protected BuildContext getContext() {
            return this.context;
        }

        protected void setContext(BuildContext context) {
            this.context = context;
        }

        protected BuildRequest getRequest() {
            return this.request;
        }

        protected void setRequest(BuildRequest request) {
            this.request = request;
        }

        @Singleton
        public static class URIBasedFileSystemAccessFactory {
            @Inject
            private IContextualOutputConfigurationProvider outputConfigurationProvider;
            @Inject
            private IFilePostProcessor postProcessor;
            @Inject(optional=true)
            private IEncodingProvider encodingProvider;
            @Inject
            private TraceFileNameProvider traceFileNameProvider;
            @Inject
            private TraceRegionSerializer traceRegionSerializer;
            @Inject(optional=true)
            private IProjectConfigProvider projectConfigProvider;

            public URIBasedFileSystemAccess newFileSystemAccess(Resource resource, BuildRequest request) {
                ISourceFolder sourceFolder;
                IProjectConfig projectConfig;
                URIBasedFileSystemAccess uriBasedFileSystemAccess = new URIBasedFileSystemAccess();
                uriBasedFileSystemAccess.setOutputConfigurations(IterableExtensions.toMap(this.outputConfigurationProvider.getOutputConfigurations(resource), OutputConfiguration::getName));
                uriBasedFileSystemAccess.setPostProcessor(this.postProcessor);
                if (this.encodingProvider != null) {
                    uriBasedFileSystemAccess.setEncodingProvider(this.encodingProvider);
                }
                uriBasedFileSystemAccess.setTraceFileNameProvider(this.traceFileNameProvider);
                uriBasedFileSystemAccess.setTraceRegionSerializer(this.traceRegionSerializer);
                uriBasedFileSystemAccess.setGenerateTraces(true);
                uriBasedFileSystemAccess.setBaseDir(request.getBaseDir());
                if (this.projectConfigProvider != null && (projectConfig = this.projectConfigProvider.getProjectConfig(resource.getResourceSet())) != null && (sourceFolder = projectConfig.findSourceFolderContaining(resource.getURI())) != null) {
                    uriBasedFileSystemAccess.setCurrentSource(sourceFolder.getName());
                }
                uriBasedFileSystemAccess.setConverter(resource.getResourceSet().getURIConverter());
                return uriBasedFileSystemAccess;
            }
        }
    }

    public static class Result {
        private final IndexState indexState;
        private final List<IResourceDescription.Delta> affectedResources;

        public Result(IndexState indexState, List<IResourceDescription.Delta> affectedResources) {
            this.indexState = indexState;
            this.affectedResources = affectedResources;
        }

        public IndexState getIndexState() {
            return this.indexState;
        }

        public List<IResourceDescription.Delta> getAffectedResources() {
            return this.affectedResources;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.indexState == null ? 0 : this.indexState.hashCode());
            return prime * result + (this.affectedResources == null ? 0 : this.affectedResources.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            if (this.indexState == null ? other.indexState != null : !this.indexState.equals(other.indexState)) {
                return false;
            }
            return !(this.affectedResources == null ? other.affectedResources != null : !this.affectedResources.equals(other.affectedResources));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder(this);
            b.add("indexState", this.indexState);
            b.add("affectedResources", this.affectedResources);
            return b.toString();
        }
    }
}

