/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.plugin.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;

public class ApiGatewayRequest {
    private static final String IS_BASE64_ENCODED = "isBase64Encoded";
    private static final String PATH_PARAMETERS = "pathParameters";
    private static final String QUERY_STRING_PARAMETERS = "queryStringParameters";
    private static final String AWS_REQUEST_BODY = "body";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static Logger logger = Logger.getLogger(ApiGatewayRequest.class);
    private JsonNode requestNode = null;

    public static ApiGatewayRequest createFromJson(InputStream jsonInput) throws JsonProcessingException, IOException {
        return new ApiGatewayRequest(jsonInput);
    }

    private ApiGatewayRequest(InputStream request) throws JsonProcessingException, IOException {
        this.requestNode = mapper.readTree(request);
        logger.debug("Incoming request: " + this.requestNode.toString());
    }

    private byte[] decodeInput() {
        return Base64.getDecoder().decode(this.requestNode.get(AWS_REQUEST_BODY).asText().getBytes());
    }

    private byte[] getBoundry() {
        String[] boundaryArray = this.getContentType().split("=");
        if (boundaryArray.length > 1) {
            return boundaryArray[1].getBytes();
        }
        logger.error("AWSRequest, boundary missing");
        return null;
    }

    private String getContentType() {
        return this.requestNode.get("headers").get("Content-Type").asText();
    }

    public byte[] getInput() throws IOException {
        if (this.isMultipartRequest()) {
            return this.getMultiPartInput();
        }
        return this.getPlainInput();
    }

    private byte[] getMultiPartInput() throws IOException {
        byte[] bI = this.decodeInput();
        logger.debug(new String(bI, StandardCharsets.UTF_8) + "\n");
        ByteArrayInputStream content = new ByteArrayInputStream(bI);
        MultipartStream multipartStream = new MultipartStream((InputStream)content, this.getBoundry(), bI.length);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean nextPart = multipartStream.skipPreamble();
        while (nextPart) {
            String header = multipartStream.readHeaders();
            logger.debug("Headers:");
            logger.debug(header);
            multipartStream.readBodyData(out);
            nextPart = multipartStream.readBoundary();
        }
        return out.toByteArray();
    }

    public String getPathParam(String key) {
        return this.requestNode.get(PATH_PARAMETERS).get(key).asText();
    }

    public Map<String, String> getQueryParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.requestNode.get(QUERY_STRING_PARAMETERS) != null) {
            Iterator<String> iter = this.requestNode.get(QUERY_STRING_PARAMETERS).fieldNames();
            while (iter.hasNext()) {
                String fieldName = iter.next();
                params.put(fieldName, this.requestNode.get(QUERY_STRING_PARAMETERS).get(fieldName).asText());
            }
        }
        return Collections.unmodifiableMap(params);
    }

    private byte[] getPlainInput() {
        if (this.requestNode.get(IS_BASE64_ENCODED).asBoolean()) {
            return this.decodeInput();
        }
        return this.requestNode.get(AWS_REQUEST_BODY).asText().getBytes();
    }

    public String getQueryParam(String key) {
        return this.requestNode.get(QUERY_STRING_PARAMETERS).get(key).asText();
    }

    private boolean isMultipartRequest() {
        return this.requestNode.get("headers").has("Content-Type") && this.requestNode.get("headers").get("Content-Type").asText().contains("multipart/form-data");
    }
}

