/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.plugin.generator.utils.javatemplates;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.ITemplate;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaInformationModelTemplate
implements ITemplate<InformationModel> {
    private String classPackage;
    private String[] imports;
    private String interfacePrefix;
    private String implSuffix;
    private ITemplate<FunctionblockProperty> propertyTemplate;
    private ITemplate<FunctionblockProperty> getterTemplate;
    private ITemplate<FunctionblockProperty> setterTemplate;

    public JavaInformationModelTemplate(String classPackage, String interfacePrefix, String implSuffix, String[] imports, ITemplate<FunctionblockProperty> propertyTemplate, ITemplate<FunctionblockProperty> getterTemplate, ITemplate<FunctionblockProperty> setterTemplate) {
        this.classPackage = classPackage;
        this.interfacePrefix = interfacePrefix;
        this.implSuffix = implSuffix;
        this.imports = imports;
        this.propertyTemplate = propertyTemplate;
        this.getterTemplate = getterTemplate;
        this.setterTemplate = setterTemplate;
    }

    @Override
    public String getContent(InformationModel im, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*");
        _builder.newLine();
        _builder.append("*****************************************************************************************");
        _builder.newLine();
        _builder.append("* The present code has been generated by the Eclipse Vorto Java Code Generator.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* The basis for the generation was the Information Model which is uniquely identified by:");
        _builder.newLine();
        _builder.append("* Name:\t\t\t");
        String _name = im.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("* Namespace:\t");
        String _namespace = im.getNamespace();
        _builder.append(_namespace);
        _builder.newLineIfNotEmpty();
        _builder.append("* Version:\t\t");
        String _version = im.getVersion();
        _builder.append(_version);
        _builder.newLineIfNotEmpty();
        _builder.append("*****************************************************************************************");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("package ");
        _builder.append(this.classPackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (String imprt : this.imports) {
            _builder.append("import ");
            _builder.append(imprt);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append("* ");
        String _description = im.getDescription();
        _builder.append(_description);
        _builder.newLineIfNotEmpty();
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public class ");
        String _firstUpper = StringExtensions.toFirstUpper(im.getName());
        _builder.append(_firstUpper);
        _builder.append(" implements ");
        _builder.append(this.interfacePrefix);
        String _firstUpper_1 = StringExtensions.toFirstUpper(im.getName());
        _builder.append(_firstUpper_1);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        EList<FunctionblockProperty> _properties = im.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append("\t");
            String _content = this.propertyTemplate.getContent(fbProperty, invocationContext);
            _builder.append(_content, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* The default constructor for ");
        String _firstUpper_2 = StringExtensions.toFirstUpper(im.getName());
        _builder.append(_firstUpper_2, "\t");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _firstUpper_3 = StringExtensions.toFirstUpper(im.getName());
        _builder.append(_firstUpper_3, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        EList<FunctionblockProperty> _properties_1 = im.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_1) {
            _builder.append("\t");
            _builder.append("// Use the standard implementation to initialize the ");
            String _name_1 = fbProperty_1.getType().getName();
            _builder.append(_name_1, "\t");
            _builder.append(".");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _name_2 = fbProperty_1.getName();
            _builder.append(_name_2, "\t");
            _builder.append(" = new ");
            String _name_3 = fbProperty_1.getType().getName();
            _builder.append(_name_3, "\t");
            _builder.append(this.implSuffix, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        EList<FunctionblockProperty> _properties_2 = im.getProperties();
        for (FunctionblockProperty fbProperty_2 : _properties_2) {
            _builder.append("\t");
            String _content_1 = this.getterTemplate.getContent(fbProperty_2, invocationContext);
            _builder.append(_content_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            String _content_2 = this.setterTemplate.getContent(fbProperty_2, invocationContext);
            _builder.append(_content_2, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }
}

