/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.plugin.generator.utils.javatemplates;

import org.eclipse.vorto.core.api.model.datatype.DictionaryPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.ITemplate;
import org.eclipse.vorto.plugin.generator.utils.javatemplates.ValueMapper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaClassFieldTemplate
implements ITemplate<Property> {
    @Override
    public String getContent(Property property, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append("* ");
        String _description = property.getDescription();
        _builder.append(_description);
        _builder.newLineIfNotEmpty();
        _builder.append("*/");
        _builder.newLine();
        PropertyType _type = property.getType();
        if (_type instanceof PrimitivePropertyType) {
            CharSequence _addFieldAnnotations = this.addFieldAnnotations(property);
            _builder.append(_addFieldAnnotations);
            _builder.newLineIfNotEmpty();
            _builder.append("private ");
            PropertyType _type_1 = property.getType();
            PrimitiveType _type_2 = ((PrimitivePropertyType)_type_1).getType();
            String _mapSimpleDatatype = ValueMapper.mapSimpleDatatype(_type_2);
            _builder.append(_mapSimpleDatatype);
            _builder.append(" ");
            String _normalize = ValueMapper.normalize(property.getName());
            _builder.append(_normalize);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        } else {
            PropertyType _type_3 = property.getType();
            if (_type_3 instanceof ObjectPropertyType) {
                PropertyType _type_4 = property.getType();
                ObjectPropertyType object = (ObjectPropertyType)_type_4;
                _builder.newLineIfNotEmpty();
                Type _type_5 = object.getType();
                if (_type_5 instanceof Entity) {
                    CharSequence _addFieldAnnotations_1 = this.addFieldAnnotations(property);
                    _builder.append(_addFieldAnnotations_1);
                    _builder.newLineIfNotEmpty();
                    _builder.append("private ");
                    CharSequence _namespaceOfDatatype = this.getNamespaceOfDatatype();
                    _builder.append(_namespaceOfDatatype);
                    Type _type_6 = object.getType();
                    String _firstUpper = StringExtensions.toFirstUpper(((Entity)_type_6).getName());
                    _builder.append(_firstUpper);
                    _builder.append(" ");
                    String _normalize_1 = ValueMapper.normalize(property.getName());
                    _builder.append(_normalize_1);
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                } else {
                    Type _type_7 = object.getType();
                    if (_type_7 instanceof Enum) {
                        CharSequence _addFieldAnnotations_2 = this.addFieldAnnotations(property);
                        _builder.append(_addFieldAnnotations_2);
                        _builder.newLineIfNotEmpty();
                        _builder.append("private ");
                        CharSequence _namespaceOfDatatype_1 = this.getNamespaceOfDatatype();
                        _builder.append(_namespaceOfDatatype_1);
                        Type _type_8 = object.getType();
                        String _firstUpper_1 = StringExtensions.toFirstUpper(((Enum)_type_8).getName());
                        _builder.append(_firstUpper_1);
                        _builder.append(" ");
                        String _normalize_2 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_2);
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                }
            } else {
                PropertyType _type_9 = property.getType();
                if (_type_9 instanceof DictionaryPropertyType) {
                    PropertyType _type_10 = property.getType();
                    DictionaryPropertyType dictionary = (DictionaryPropertyType)_type_10;
                    _builder.newLineIfNotEmpty();
                    CharSequence _addFieldAnnotations_3 = this.addFieldAnnotations(property);
                    _builder.append(_addFieldAnnotations_3);
                    _builder.newLineIfNotEmpty();
                    if (dictionary.getKeyType() != null && dictionary.getValueType() != null) {
                        _builder.append("private java.util.Map<");
                        String _propertyType = this.getPropertyType(dictionary.getKeyType());
                        _builder.append(_propertyType);
                        _builder.append(",");
                        String _propertyType_1 = this.getPropertyType(dictionary.getValueType());
                        _builder.append(_propertyType_1);
                        _builder.append("> ");
                        String _normalize_3 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_3);
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append("private java.util.Map ");
                        String _normalize_4 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_4);
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
        }
        return _builder.toString();
    }

    public String getPropertyType(PropertyType propertyType) {
        if (propertyType instanceof PrimitivePropertyType) {
            PrimitiveType _type = ((PrimitivePropertyType)propertyType).getType();
            return ValueMapper.mapSimpleDatatype(_type);
        }
        if (propertyType instanceof ObjectPropertyType) {
            return StringExtensions.toFirstUpper(((ObjectPropertyType)propertyType).getType().getName());
        }
        return "java.util.Map";
    }

    protected CharSequence addFieldAnnotations(Property property) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence getNamespaceOfDatatype() {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }
}

