/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.plugin.generator.utils.javatemplates;

import org.eclipse.vorto.core.api.model.datatype.DictionaryPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.ITemplate;
import org.eclipse.vorto.plugin.generator.utils.javatemplates.ValueMapper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaClassFieldGetterTemplate
implements ITemplate<Property> {
    private String getterPrefix;

    public JavaClassFieldGetterTemplate(String getterPrefix) {
        this.getterPrefix = getterPrefix;
    }

    @Override
    public String getContent(Property property, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append("* Getter for ");
        String _name = property.getName();
        _builder.append(_name);
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append("*/");
        _builder.newLine();
        PropertyType _type = property.getType();
        if (_type instanceof PrimitivePropertyType) {
            _builder.append("public ");
            PropertyType _type_1 = property.getType();
            PrimitiveType _type_2 = ((PrimitivePropertyType)_type_1).getType();
            String _mapSimpleDatatype = ValueMapper.mapSimpleDatatype(_type_2);
            _builder.append(_mapSimpleDatatype);
            _builder.append(" ");
            _builder.append(this.getterPrefix);
            String _normalize = ValueMapper.normalize(StringExtensions.toFirstUpper(property.getName()));
            _builder.append(_normalize);
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return this.");
            String _normalize_1 = ValueMapper.normalize(property.getName());
            _builder.append(_normalize_1, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        } else {
            PropertyType _type_3 = property.getType();
            if (_type_3 instanceof ObjectPropertyType) {
                PropertyType _type_4 = property.getType();
                ObjectPropertyType object = (ObjectPropertyType)_type_4;
                _builder.newLineIfNotEmpty();
                Type _type_5 = object.getType();
                if (_type_5 instanceof Entity) {
                    _builder.append("public ");
                    CharSequence _namespaceOfDatatype = this.getNamespaceOfDatatype();
                    _builder.append(_namespaceOfDatatype);
                    Type _type_6 = object.getType();
                    String _firstUpper = StringExtensions.toFirstUpper(((Entity)_type_6).getName());
                    _builder.append(_firstUpper);
                    _builder.append(" ");
                    _builder.append(this.getterPrefix);
                    String _normalize_2 = ValueMapper.normalize(StringExtensions.toFirstUpper(property.getName()));
                    _builder.append(_normalize_2);
                    _builder.append("() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("return this.");
                    String _normalize_3 = ValueMapper.normalize(property.getName());
                    _builder.append(_normalize_3, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("}");
                    _builder.newLine();
                } else {
                    Type _type_7 = object.getType();
                    if (_type_7 instanceof Enum) {
                        _builder.append("public ");
                        CharSequence _namespaceOfDatatype_1 = this.getNamespaceOfDatatype();
                        _builder.append(_namespaceOfDatatype_1);
                        Type _type_8 = object.getType();
                        String _firstUpper_1 = StringExtensions.toFirstUpper(((Enum)_type_8).getName());
                        _builder.append(_firstUpper_1);
                        _builder.append(" ");
                        _builder.append(this.getterPrefix);
                        String _normalize_4 = ValueMapper.normalize(StringExtensions.toFirstUpper(property.getName()));
                        _builder.append(_normalize_4);
                        _builder.append("() {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("return this.");
                        String _normalize_5 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_5, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("}");
                        _builder.newLine();
                    }
                }
            } else {
                PropertyType _type_9 = property.getType();
                if (_type_9 instanceof DictionaryPropertyType) {
                    PropertyType _type_10 = property.getType();
                    DictionaryPropertyType dictionary = (DictionaryPropertyType)_type_10;
                    _builder.newLineIfNotEmpty();
                    if (dictionary.getKeyType() != null && dictionary.getValueType() != null) {
                        _builder.append("public java.util.Map<");
                        String _propertyType = this.getPropertyType(dictionary.getKeyType());
                        _builder.append(_propertyType);
                        _builder.append(",");
                        String _propertyType_1 = this.getPropertyType(dictionary.getValueType());
                        _builder.append(_propertyType_1);
                        _builder.append("> ");
                        _builder.append(this.getterPrefix);
                        String _normalize_6 = ValueMapper.normalize(StringExtensions.toFirstUpper(property.getName()));
                        _builder.append(_normalize_6);
                        _builder.append("() {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("    ");
                        _builder.append("return this.");
                        String _normalize_7 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_7, "    ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("}");
                        _builder.newLine();
                    } else {
                        _builder.append("public java.util.Map");
                        _builder.append(this.getterPrefix);
                        String _normalize_8 = ValueMapper.normalize(StringExtensions.toFirstUpper(property.getName()));
                        _builder.append(_normalize_8);
                        _builder.append("() {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("    ");
                        _builder.append("return this.");
                        String _normalize_9 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_9, "    ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("}");
                        _builder.newLine();
                    }
                }
            }
        }
        _builder.newLine();
        return _builder.toString();
    }

    protected CharSequence getNamespaceOfDatatype() {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public String getPropertyType(PropertyType propertyType) {
        if (propertyType instanceof PrimitivePropertyType) {
            PrimitiveType _type = ((PrimitivePropertyType)propertyType).getType();
            return ValueMapper.mapSimpleDatatype(_type);
        }
        if (propertyType instanceof ObjectPropertyType) {
            CharSequence _namespaceOfDatatype = this.getNamespaceOfDatatype();
            String _firstUpper = StringExtensions.toFirstUpper(((ObjectPropertyType)propertyType).getType().getName());
            return _namespaceOfDatatype + _firstUpper;
        }
        return "java.util.Map";
    }
}

