/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.vorto.core.api.model.BuilderUtils;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.ConstraintRule;
import org.eclipse.vorto.core.api.model.datatype.DatatypeFactory;
import org.eclipse.vorto.core.api.model.datatype.DictionaryPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Presence;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.datatype.impl.DatatypePackageImpl;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockFactory;
import org.eclipse.vorto.core.api.model.functionblock.ReturnDictonaryType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.impl.FunctionblockPackageImpl;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.informationmodel.impl.InformationModelPackageImpl;
import org.eclipse.vorto.core.api.model.mapping.FunctionBlockPropertySource;
import org.eclipse.vorto.core.api.model.mapping.FunctionBlockSource;
import org.eclipse.vorto.core.api.model.mapping.MappingFactory;
import org.eclipse.vorto.core.api.model.mapping.impl.MappingPackageImpl;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.model.Constraint;
import org.eclipse.vorto.model.DictionaryType;
import org.eclipse.vorto.model.EntityModel;
import org.eclipse.vorto.model.EnumLiteral;
import org.eclipse.vorto.model.EnumModel;
import org.eclipse.vorto.model.FunctionblockModel;
import org.eclipse.vorto.model.IModel;
import org.eclipse.vorto.model.IReferenceType;
import org.eclipse.vorto.model.Infomodel;
import org.eclipse.vorto.model.ModelContent;
import org.eclipse.vorto.model.ModelEvent;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.Operation;
import org.eclipse.vorto.model.Param;
import org.eclipse.vorto.model.PrimitiveType;
import org.eclipse.vorto.model.ReturnType;
import org.eclipse.vorto.model.Stereotype;
import org.eclipse.vorto.model.conversion.IModelConverter;

public class ModelContentToEcoreConverter
implements IModelConverter<ModelContent, Model> {
    @Override
    public Model convert(ModelContent source, Optional<String> platformKey) {
        IModel model = source.getModels().get(source.getRoot());
        return this.convert(model, source, platformKey);
    }

    private Model convert(IModel model, ModelContent context, Optional<String> platformKey) {
        if (model instanceof EntityModel) {
            return this.convertEntity((EntityModel)model, context);
        }
        if (model instanceof EnumModel) {
            return this.convertEnum((EnumModel)model);
        }
        if (model instanceof FunctionblockModel) {
            return platformKey.isPresent() ? this.convertFunctionblockMapping((FunctionblockModel)model, context, platformKey.get()) : this.convertFunctionblock((FunctionblockModel)model, context);
        }
        if (model instanceof Infomodel) {
            return this.convertInformationModel((Infomodel)model, context);
        }
        return null;
    }

    private Model convertFunctionblockMapping(FunctionblockModel model, ModelContent context, String platformKey) {
        FunctionBlockPropertySource source;
        BuilderUtils.MappingRuleBuilder ruleBuilder;
        BuilderUtils.MappingBuilder builder = BuilderUtils.newMapping(new org.eclipse.vorto.core.api.model.model.ModelId(ModelType.InformationModel, model.getId().getName() + "Mapping", model.getId().getNamespace() + ".mapping." + platformKey, model.getId().getVersion()), platformKey);
        builder.withVortolang("1.0");
        builder.withDescription("Mapping that contains " + platformKey + " specific meta data");
        builder.withReference(ModelIdFactory.newInstance(ModelType.Functionblock, model.getId().getNamespace(), model.getId().getVersion(), model.getId().getVersion()));
        org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel eFbm = this.convertFunctionblock(model, context);
        for (Stereotype stereotype : model.getStereotypes()) {
            BuilderUtils.MappingRuleBuilder ruleBuilder2 = new BuilderUtils.MappingRuleBuilder();
            ruleBuilder2.withStereotypeTarget(stereotype.getName(), stereotype.getAttributes());
            FunctionBlockSource source2 = MappingFactory.eINSTANCE.createFunctionBlockSource();
            source2.setModel(eFbm);
            ruleBuilder2.withSource(source2);
            builder.addRule(ruleBuilder2.build());
        }
        for (ModelProperty statusProperty : model.getStatusProperties()) {
            for (Stereotype stereotype : statusProperty.getStereotypes()) {
                ruleBuilder = new BuilderUtils.MappingRuleBuilder();
                ruleBuilder.withStereotypeTarget(stereotype.getName(), stereotype.getAttributes());
                source = MappingFactory.eINSTANCE.createStatusSource();
                source.setModel(eFbm);
                source.setProperty(eFbm.getFunctionblock().getStatus().getProperties().stream().filter(property -> property.getName().equals(statusProperty.getName())).findAny().get());
                ruleBuilder.withSource(source);
                builder.addRule(ruleBuilder.build());
            }
        }
        for (ModelProperty configProperty : model.getConfigurationProperties()) {
            for (Stereotype stereotype : configProperty.getStereotypes()) {
                ruleBuilder = new BuilderUtils.MappingRuleBuilder();
                ruleBuilder.withStereotypeTarget(stereotype.getName(), stereotype.getAttributes());
                source = MappingFactory.eINSTANCE.createConfigurationSource();
                source.setModel(eFbm);
                source.setProperty(eFbm.getFunctionblock().getConfiguration().getProperties().stream().filter(property -> property.getName().equals(configProperty.getName())).findAny().get());
                ruleBuilder.withSource(source);
                builder.addRule(ruleBuilder.build());
            }
        }
        return builder.build();
    }

    private InformationModel convertInformationModel(Infomodel model, ModelContent context) {
        BuilderUtils.InformationModelBuilder builder = BuilderUtils.newInformationModel(new org.eclipse.vorto.core.api.model.model.ModelId(ModelType.InformationModel, model.getId().getName(), model.getId().getNamespace(), model.getId().getVersion()));
        builder.withCategory(model.getCategory());
        builder.withDescription(model.getDescription());
        builder.withDisplayName(model.getDisplayName());
        builder.withVortolang(model.getVortolang());
        for (ModelProperty property : model.getFunctionblocks()) {
            FunctionblockModel fbModel = (FunctionblockModel)context.getModels().get((ModelId)property.getType());
            org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel convertedFb = this.convertFunctionblock(fbModel, context);
            builder.withReference(ModelIdFactory.newInstance(convertedFb));
            builder.withFunctionBlock(convertedFb, property.getName(), property.getDescription(), property.isMandatory());
        }
        return (InformationModel)builder.build();
    }

    private Property createProperty(ModelProperty sourceProperty, BuilderUtils.ModelBuilder<?> builder, ModelContent context) {
        Property property = DatatypeFactory.eINSTANCE.createProperty();
        property.setName(sourceProperty.getName());
        property.setType(this.createPropertyType(sourceProperty.getType(), builder, context));
        property.setDescription(sourceProperty.getDescription());
        Presence presence = DatatypeFactory.eINSTANCE.createPresence();
        presence.setMandatory(sourceProperty.isMandatory());
        property.setPresence(presence);
        property.setMultiplicity(sourceProperty.isMultiple());
        ConstraintRule rule = DatatypeFactory.eINSTANCE.createConstraintRule();
        for (Constraint constraint : sourceProperty.getConstraints()) {
            org.eclipse.vorto.core.api.model.datatype.Constraint eConstraint = DatatypeFactory.eINSTANCE.createConstraint();
            eConstraint.setConstraintValues(constraint.getValue());
            eConstraint.setType(ConstraintIntervalType.valueOf(constraint.getType().name()));
            rule.getConstraints().add(eConstraint);
        }
        property.setConstraintRule(rule);
        return property;
    }

    private PropertyType createPropertyType(IReferenceType referenceType, BuilderUtils.ModelBuilder<?> builder, ModelContent context) {
        if (referenceType instanceof PrimitiveType) {
            PrimitivePropertyType primitive = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
            primitive.setType(org.eclipse.vorto.core.api.model.datatype.PrimitiveType.valueOf(((PrimitiveType)referenceType).name()));
            return primitive;
        }
        if (referenceType instanceof ModelId) {
            IModel referencedModel = context.getModels().get((ModelId)referenceType);
            Type convertedReference = (Type)this.convert(referencedModel, context, Optional.empty());
            builder.withReference(ModelIdFactory.newInstance(convertedReference));
            ObjectPropertyType objType = DatatypeFactory.eINSTANCE.createObjectPropertyType();
            objType.setType(convertedReference);
            return objType;
        }
        if (referenceType instanceof DictionaryType) {
            DictionaryType dictionaryType = (DictionaryType)referenceType;
            DictionaryPropertyType dictionary = DatatypeFactory.eINSTANCE.createDictionaryPropertyType();
            if (dictionaryType.getKey() != null) {
                dictionary.setKeyType(this.createPropertyType(dictionaryType.getKey(), builder, context));
            }
            if (dictionaryType.getValue() != null) {
                dictionary.setValueType(this.createPropertyType(dictionaryType.getValue(), builder, context));
            }
            return dictionary;
        }
        throw new UnsupportedOperationException("Reference type is not valie");
    }

    private org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel convertFunctionblock(FunctionblockModel model, ModelContent context) {
        Property property;
        BuilderUtils.FunctionblockBuilder builder = BuilderUtils.newFunctionblock(new org.eclipse.vorto.core.api.model.model.ModelId(ModelType.Functionblock, model.getId().getName(), model.getId().getNamespace(), model.getId().getVersion()));
        builder.withCategory(model.getCategory());
        builder.withDescription(model.getDescription());
        builder.withDisplayName(model.getDisplayName());
        builder.withVortolang(model.getVortolang());
        if (model.getSuperType() != null) {
            builder.withSuperType(this.convertSupertype(model.getSuperType(), model, context));
        }
        for (ModelProperty sourceProperty : model.getStatusProperties()) {
            property = this.createProperty(sourceProperty, builder, context);
            builder.withStatusProperty(property);
        }
        for (ModelProperty sourceProperty : model.getConfigurationProperties()) {
            property = this.createProperty(sourceProperty, builder, context);
            builder.withConfiguration(property);
        }
        for (Operation operation : model.getOperations()) {
            builder.withOperation(operation.getName(), this.createReturnTypeOrNull(operation.getResult(), builder, context), operation.getDescription(), operation.isBreakable(), this.createParams(operation.getParams(), builder, context));
        }
        for (ModelEvent event : model.getEvents()) {
            BuilderUtils.EventBuilder eventBuilder = BuilderUtils.newEvent(event.getName());
            for (ModelProperty sourceProperty : event.getProperties()) {
                Property property2 = this.createProperty(sourceProperty, builder, context);
                eventBuilder.withProperty(property2);
            }
            builder.withEvent(eventBuilder.build());
        }
        return (org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel)builder.build();
    }

    private org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel convertSupertype(ModelId superType, FunctionblockModel model, ModelContent context) {
        IModel superTypeModel = context.getModels().get(superType);
        return (org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel)this.convert(superTypeModel, context, Optional.empty());
    }

    private org.eclipse.vorto.core.api.model.functionblock.Param[] createParams(List<Param> params, BuilderUtils.ModelBuilder<?> builder, ModelContent context) {
        ArrayList<org.eclipse.vorto.core.api.model.functionblock.Param> ecoreParams = new ArrayList<org.eclipse.vorto.core.api.model.functionblock.Param>();
        for (Param param : params) {
            org.eclipse.vorto.core.api.model.functionblock.Param type;
            if (param.getType() instanceof PrimitiveType) {
                type = FunctionblockFactory.eINSTANCE.createPrimitiveParam();
                type.setMultiplicity(param.isMultiple());
                type.setName(param.getName());
                type.setType(org.eclipse.vorto.core.api.model.datatype.PrimitiveType.valueOf(((PrimitiveType)param.getType()).name()));
                ecoreParams.add(type);
                continue;
            }
            if (param.getType() instanceof ModelId) {
                type = FunctionblockFactory.eINSTANCE.createRefParam();
                type.setMultiplicity(param.isMultiple());
                type.setName(param.getName());
                type.setType((Type)this.convert(context.getModels().get((ModelId)param.getType()), context, Optional.empty()));
                ecoreParams.add(type);
                continue;
            }
            if (param.getType() instanceof DictionaryType) {
                type = FunctionblockFactory.eINSTANCE.createDictonaryParam();
                type.setName(param.getName());
                type.setMultiplicity(param.isMultiple());
                type.setType((DictionaryPropertyType)this.createPropertyType(param.getType(), builder, context));
                ecoreParams.add(type);
                continue;
            }
            return null;
        }
        return ecoreParams.toArray(new org.eclipse.vorto.core.api.model.functionblock.Param[ecoreParams.size()]);
    }

    private org.eclipse.vorto.core.api.model.functionblock.ReturnType createReturnTypeOrNull(ReturnType result, BuilderUtils.FunctionblockBuilder builder, ModelContent context) {
        if (result == null) {
            return null;
        }
        if (result.getType() instanceof PrimitiveType) {
            ReturnPrimitiveType type = FunctionblockFactory.eINSTANCE.createReturnPrimitiveType();
            type.setMultiplicity(result.isMultiple());
            type.setReturnType(org.eclipse.vorto.core.api.model.datatype.PrimitiveType.valueOf(((PrimitiveType)result.getType()).name()));
            return type;
        }
        if (result.getType() instanceof ModelId) {
            ReturnObjectType type = FunctionblockFactory.eINSTANCE.createReturnObjectType();
            type.setMultiplicity(result.isMultiple());
            Type convertedType = (Type)this.convert(context.getModels().get((ModelId)result.getType()), context, Optional.empty());
            builder.withReference(ModelIdFactory.newInstance(convertedType));
            type.setReturnType(convertedType);
            return type;
        }
        if (result.getType() instanceof DictionaryType) {
            ReturnDictonaryType type = FunctionblockFactory.eINSTANCE.createReturnDictonaryType();
            type.setMultiplicity(result.isMultiple());
            type.setReturnType((DictionaryPropertyType)this.createPropertyType(result.getType(), builder, context));
            return type;
        }
        return null;
    }

    private Enum convertEnum(EnumModel model) {
        BuilderUtils.EnumBuilder builder = BuilderUtils.newEnum(new org.eclipse.vorto.core.api.model.model.ModelId(ModelType.Datatype, model.getId().getName(), model.getId().getNamespace(), model.getId().getVersion()));
        builder.withCategory(model.getCategory());
        builder.withDescription(model.getDescription());
        builder.withDisplayName(model.getDisplayName());
        builder.withVortolang(model.getVortolang());
        for (EnumLiteral literal : model.getLiterals()) {
            builder.withLiteral(literal.getName(), literal.getDescription());
        }
        return (Enum)builder.build();
    }

    private Entity convertEntity(EntityModel entity, ModelContent context) {
        BuilderUtils.EntityBuilder builder = BuilderUtils.newEntity(new org.eclipse.vorto.core.api.model.model.ModelId(ModelType.Datatype, entity.getId().getName(), entity.getId().getNamespace(), entity.getId().getVersion()));
        builder.withCategory(entity.getCategory());
        builder.withDescription(entity.getDescription());
        builder.withDisplayName(entity.getDisplayName());
        builder.withVortolang(entity.getVortolang());
        builder.withReferences(entity.getReferences().stream().map(r -> new org.eclipse.vorto.core.api.model.model.ModelId(ModelType.Datatype, r.getName(), r.getNamespace(), r.getVersion())).collect(Collectors.toList()));
        for (ModelProperty sourceProperty : entity.getProperties()) {
            Property property = this.createProperty(sourceProperty, builder, context);
            builder.withProperty(property);
        }
        return (Entity)builder.build();
    }

    static {
        DatatypePackageImpl.init();
        FunctionblockPackageImpl.init();
        InformationModelPackageImpl.init();
        MappingPackageImpl.init();
    }
}

