/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.scope;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.datatype.impl.TypeImpl;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.editor.scope.ProxyUriReferenceBasedScope;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class DatatypeScopeHelper {
    public static IScope getDataTypeReferenceScope(IQualifiedNameConverter converter, EObject context, EReference reference) {
        IScope scope = IScope.NULLSCOPE;
        if (context instanceof ObjectPropertyType && DatatypeScopeHelper.isFromVirtualFile((ObjectPropertyType)context)) {
            scope = DatatypeScopeHelper.getObjectPropertyScope(converter, (ObjectPropertyType)context, reference);
        } else if (context instanceof ReturnObjectType) {
            scope = DatatypeScopeHelper.getReturnObjectTypeScope(converter, (ReturnObjectType)context, reference);
        } else if (context instanceof RefParam) {
            scope = DatatypeScopeHelper.getRefParamTypeScope(converter, (RefParam)context, reference);
        }
        return scope;
    }

    public static IScope getObjectPropertyScope(IQualifiedNameConverter converter, ObjectPropertyType objectPropertyType, EReference reference) {
        try {
            return DatatypeScopeHelper.getTypeScope(converter, objectPropertyType.getType(), reference);
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        return IScope.NULLSCOPE;
    }

    public static IScope getReturnObjectTypeScope(IQualifiedNameConverter converter, ReturnObjectType returnObjectType, EReference reference) {
        try {
            return DatatypeScopeHelper.getTypeScope(converter, returnObjectType.getReturnType(), reference);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error error) {}
        return IScope.NULLSCOPE;
    }

    public static IScope getRefParamTypeScope(IQualifiedNameConverter converter, RefParam refParam, EReference reference) {
        try {
            return DatatypeScopeHelper.getTypeScope(converter, refParam.getType(), reference);
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        return IScope.NULLSCOPE;
    }

    private static IScope getTypeScope(IQualifiedNameConverter converter, Type type, EReference reference) {
        ArrayList<IEObjectDescription> objects = new ArrayList<IEObjectDescription>();
        String objectPropertyTypeName = DatatypeScopeHelper.getObjectPropertyNameFromProxyUri(((TypeImpl)type).eProxyURI().toString());
        objects.add(EObjectDescription.create(converter.toQualifiedName(objectPropertyTypeName), (EObject)reference));
        return new ProxyUriReferenceBasedScope(IScope.NULLSCOPE, objects);
    }

    public static boolean isFromVirtualFile(ObjectPropertyType objectPropertyType) {
        return objectPropertyType.eResource().getURI().toString().contains("NON_EXIST_DSL_FILE");
    }

    private static String getObjectPropertyNameFromProxyUri(String proxyUri) {
        String importPart = proxyUri.substring("using|".length() + 1);
        importPart = importPart.substring(0, importPart.indexOf(";"));
        String name = importPart.substring(importPart.lastIndexOf(".") + 1);
        return name;
    }
}

