/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.functionblock.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.vorto.core.api.model.datatype.BooleanPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.ConstraintRule;
import org.eclipse.vorto.core.api.model.datatype.DatatypePackage;
import org.eclipse.vorto.core.api.model.datatype.DictionaryPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteralPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Event;
import org.eclipse.vorto.core.api.model.functionblock.Fault;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockPackage;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.PrimitiveParam;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.model.ModelPackage;
import org.eclipse.vorto.editor.datatype.internal.validation.ConstraintValueValidator;
import org.eclipse.vorto.editor.datatype.validation.ConstraintValidatorFactory;
import org.eclipse.vorto.editor.datatype.validation.PropertyConstraintMappingValidation;
import org.eclipse.vorto.editor.datatype.validation.ValidatorUtils;
import org.eclipse.vorto.editor.functionblock.validation.AbstractFunctionblockValidator;
import org.eclipse.vorto.editor.functionblock.validation.FbValidatorUtils;
import org.eclipse.vorto.editor.functionblock.validation.TypeHelper;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;

public class FunctionblockValidator
extends AbstractFunctionblockValidator {
    public final PropertyConstraintMappingValidation propertyValidator = new PropertyConstraintMappingValidation();
    @Inject
    private TypeHelper helper;

    @Check
    public void checkEntityandEnum(FunctionblockModel model) {
        List<Type> list = this.getAllTypeFromReferencedFile(model);
        HashSet<String> set = this.getNonDuplicateLowerCasedNameSet(list);
        EList<Entity> entities = model.getEntities();
        EList<Enum> enums = model.getEnums();
        for (Entity en : entities) {
            boolean _not;
            boolean _add = set.add(en.getName().toLowerCase());
            boolean bl = _not = !_add;
            if (!_not) continue;
            this.error("Enum or Entity name has been defined.", en, ModelPackage.Literals.MODEL__NAME);
        }
        for (Enum en_1 : enums) {
            boolean _not_1;
            boolean _add_1 = set.add(en_1.getName().toLowerCase());
            boolean bl = _not_1 = !_add_1;
            if (!_not_1) continue;
            this.error("Enum or Entity name has been defined.", en_1, ModelPackage.Literals.MODEL__NAME);
        }
    }

    public List<Type> getAllTypeFromReferencedFile(EObject eObject) {
        return this.helper.getAllTypeFromReferencedTypeFile(eObject);
    }

    public HashSet<String> getNonDuplicateLowerCasedNameSet(List<Type> list) {
        HashSet<String> set = new HashSet<String>();
        for (Type e : list) {
            set.add(e.getName().toLowerCase());
        }
        return set;
    }

    @Check
    public void checkFunctionBlockName(FunctionblockModel model) {
        String name = model.getName();
        boolean _isCamelCasedName = this.isCamelCasedName(name);
        if (_isCamelCasedName) {
            this.error("Function block name must begin with a capital letter", model, ModelPackage.Literals.MODEL__NAME);
        }
    }

    @Check
    public void checkDuplicateParameter(Operation operation) {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray(operation.getParams(), Object.class)).length) {
            boolean _not;
            Param param = (Param)operation.getParams().get(i);
            boolean _add = set.add(param.getName());
            boolean bl = _not = !_add;
            if (_not) {
                this.error("Parameter name has been defined", param, FunctionblockPackage.Literals.PARAM__NAME);
            }
            ++i;
        }
    }

    @Check
    public void checkDuplicateOperation(Operation op) {
        HashSet<String> set = new HashSet<String>();
        EObject _eContainer = op.eContainer();
        FunctionBlock fb = (FunctionBlock)_eContainer;
        EList<Operation> ops = fb.getOperations();
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray(ops, Object.class)).length) {
            boolean _not;
            Operation method = (Operation)ops.get(i);
            boolean _add = set.add(method.getName());
            boolean bl = _not = !_add;
            if (_not) {
                this.error("Method name has been defined", method, FunctionblockPackage.Literals.OPERATION__NAME);
            }
            ++i;
        }
    }

    @Check
    public void checkVersionPattern(FunctionblockModel functionblock) {
        boolean _not;
        boolean _matches = functionblock.getVersion().matches("\\d+\\.\\d+\\.\\d+(\\-.+)?");
        boolean bl = _not = !_matches;
        if (_not) {
            this.error("Version is not matching the following pattern: <MAJOR>.<MINOR>.<PATCH>-<QUALIFIER>", functionblock, ModelPackage.Literals.MODEL__VERSION);
        }
    }

    @Check
    public void checkNamespacePattern(FunctionblockModel functionblock) {
        boolean _not;
        boolean _matches = functionblock.getNamespace().matches("([a-z0-9_]*\\.)*[a-z0-9_]*");
        boolean bl = _not = !_matches;
        if (_not) {
            this.error("Namespace should have following pattern: <[a-z0-9]+(.[a-z0-9])*> E.g com.bosch, com.bosch.lightsystem", functionblock, ModelPackage.Literals.MODEL__VERSION);
        }
    }

    @Check
    public void checkParametersConstraint(Operation op) {
        boolean _equals;
        EList<Param> parameters = op.getParams();
        EList<Param> _converted_parameters = parameters;
        int _length = ((Object[])Conversions.unwrapArray(_converted_parameters, Object.class)).length;
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return;
        }
        for (Param parameter : parameters) {
            if (!(parameter instanceof PrimitiveParam)) continue;
            PrimitiveParam primitiveParam = (PrimitiveParam)parameter;
            PrimitiveType primitiveType = primitiveParam.getType();
            EList<Constraint> constraintsList = primitiveParam.getConstraintRule().getConstraints();
            for (Constraint constraint : constraintsList) {
                this.checkForConstraint(primitiveType, constraint, parameter, primitiveParam.getType().getName(), ((PrimitiveParam)parameter).isMultiplicity(), FunctionblockPackage.Literals.PRIMITIVE_PARAM__CONSTRAINT_RULE);
            }
        }
    }

    @Check
    public void checkReturnTypeConstraint(Operation op) {
        ReturnType returnType = op.getReturnType();
        if (returnType instanceof ReturnPrimitiveType) {
            ReturnPrimitiveType returnPrimitiveType = (ReturnPrimitiveType)returnType;
            String parameterName = returnPrimitiveType.getReturnType().getName();
            EList<Constraint> constraintsList = returnPrimitiveType.getConstraintRule().getConstraints();
            for (Constraint constraint : constraintsList) {
                this.checkForConstraint(returnPrimitiveType.getReturnType(), constraint, returnPrimitiveType, parameterName, returnPrimitiveType.isMultiplicity(), FunctionblockPackage.Literals.RETURN_PRIMITIVE_TYPE__CONSTRAINT_RULE);
            }
        }
    }

    public void checkForConstraint(PrimitiveType primitiveType, Constraint constraint, EObject source, String parameterName, boolean isMultiplcity, EStructuralFeature feature) {
        boolean _not;
        boolean _isValidConstraintType = this.isValidConstraintType(primitiveType, constraint);
        boolean bl = _not = !_isValidConstraintType;
        if (_not) {
            this.error(this.propertyValidator.getErrorMessage(), source, feature);
        } else {
            boolean _not_1;
            ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator(constraint.getType());
            boolean _isValidConstraintValue = this.isValidConstraintValue(validator, primitiveType, constraint);
            boolean bl2 = _not_1 = !_isValidConstraintValue;
            if (_not_1) {
                this.error(validator.getErrorMessage(), source, feature);
            }
        }
        boolean _isMimeConstraint = this.isMimeConstraint(parameterName, constraint);
        if (_isMimeConstraint && !isMultiplcity) {
            this.error("MIMEType only applies to byte array, have you forgotten to add 'multiple' ?", source, feature);
        }
    }

    @Check
    public void checkPropsIn(Configuration c) {
        this.checkDuplicatedProperty(c.getProperties());
    }

    @Check
    public void checkPropsIn(Status s2) {
        this.checkDuplicatedProperty(s2.getProperties());
    }

    @Check
    public void checkPropsIn(Fault f) {
        this.checkDuplicatedProperty(f.getProperties());
    }

    @Check
    public void checkPropsIn(Event e) {
        this.checkDuplicatedProperty(e.getProperties());
    }

    @Check
    public void checkPropsIn(Entity e) {
        this.checkDuplicatedProperty(e.getProperties());
    }

    @Check
    public void checkCircularRefInSuperType(FunctionblockModel functionblock) {
        boolean _tripleNotEquals;
        FunctionblockModel _superType = functionblock.getSuperType();
        boolean bl = _tripleNotEquals = _superType != null;
        if (_tripleNotEquals) {
            try {
                boolean _hasCircularReference = ValidatorUtils.hasCircularReference(functionblock, functionblock.getSuperType(), FbValidatorUtils.modelToChildrenSupplierFunction);
                if (_hasCircularReference) {
                    this.error("Super type has circular reference", functionblock, FunctionblockPackage.Literals.FUNCTIONBLOCK_MODEL__SUPER_TYPE);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow(_t);
            }
        }
    }

    @Check
    public void checkRefParamIsImported(RefParam refParam) {
        EObject _parentOfType = ValidatorUtils.getParentOfType(refParam, FunctionblockModel.class);
        FunctionblockModel topParent = (FunctionblockModel)_parentOfType;
        if (topParent != null && !ValidatorUtils.isTypeInReferences(refParam.getType(), topParent.getReferences())) {
            this.error("Reference parameter has not yet been imported.", refParam, FunctionblockPackage.Literals.REF_PARAM__TYPE);
        }
    }

    @Check
    public void checkReturnTypeIsImported(ReturnObjectType returnType) {
        EObject _parentOfType = ValidatorUtils.getParentOfType(returnType, FunctionblockModel.class);
        FunctionblockModel topParent = (FunctionblockModel)_parentOfType;
        if (topParent != null && !ValidatorUtils.isTypeInReferences(returnType.getReturnType(), topParent.getReferences())) {
            this.error("Return type has not yet been imported.", returnType, FunctionblockPackage.Literals.RETURN_OBJECT_TYPE__RETURN_TYPE);
        }
    }

    public TypeHelper setHelper(TypeHelper helper) {
        this.helper = helper;
        return this.helper;
    }

    public TypeHelper getHelper() {
        return this.helper;
    }

    public String getPropertyName(PropertyType propertyType) {
        if (propertyType instanceof PrimitivePropertyType) {
            return ((PrimitivePropertyType)propertyType).getType().getLiteral();
        }
        if (propertyType instanceof DictionaryPropertyType) {
            String _propertyName = this.getPropertyName(((DictionaryPropertyType)propertyType).getKeyType());
            String _plus = "dict" + _propertyName;
            String _propertyName_1 = this.getPropertyName(((DictionaryPropertyType)propertyType).getValueType());
            return String.valueOf(_plus) + _propertyName_1;
        }
        if (propertyType instanceof ObjectPropertyType) {
            return ((ObjectPropertyType)propertyType).getType().getName();
        }
        return null;
    }

    public void validateOvewrittenPropertyAttr(Property baseProperty, Property extProperty) {
        EList<PropertyAttribute> _propertyAttributes = extProperty.getPropertyAttributes();
        for (PropertyAttribute propAttr : _propertyAttributes) {
            EList<PropertyAttribute> _propertyAttributes_1 = baseProperty.getPropertyAttributes();
            for (PropertyAttribute basePropAttr : _propertyAttributes_1) {
                boolean _equals_1;
                if (propAttr instanceof BooleanPropertyAttribute && basePropAttr instanceof BooleanPropertyAttribute) {
                    boolean _equals = ((BooleanPropertyAttribute)propAttr).getType().equals(((BooleanPropertyAttribute)basePropAttr).getType());
                    if (!_equals) continue;
                    this.error("Property attributes can not be overwritten.", extProperty, DatatypePackage.Literals.PROPERTY__PROPERTY_ATTRIBUTES);
                    continue;
                }
                if (!(propAttr instanceof EnumLiteralPropertyAttribute) || !(basePropAttr instanceof EnumLiteralPropertyAttribute) || !(_equals_1 = ((EnumLiteralPropertyAttribute)propAttr).getType().getName().equals(((EnumLiteralPropertyAttribute)basePropAttr).getType().getName()))) continue;
                this.error("Property attributes can not be overwritten.", extProperty, DatatypePackage.Literals.PROPERTY__PROPERTY_ATTRIBUTES);
            }
        }
    }

    public ArrayList<String> validateOverriddenConstraints(Property baseProperty, Property extProperty) {
        boolean _tripleEquals;
        ArrayList<String> validatedConstraints = new ArrayList<String>();
        ConstraintRule _constraintRule = baseProperty.getConstraintRule();
        boolean bl = _tripleEquals = _constraintRule == null;
        if (_tripleEquals) {
            return validatedConstraints;
        }
        Functions.Function1<Constraint, ConstraintIntervalType> _function = it -> it.getType();
        Functions.Function1<Constraint, Constraint> _function_1 = it -> it;
        Map<ConstraintIntervalType, Constraint> constraintsMap = MapExtensions.mapValues(IterableExtensions.toMap(baseProperty.getConstraintRule().getConstraints(), _function), _function_1);
        EList<Constraint> _constraints = extProperty.getConstraintRule().getConstraints();
        for (Constraint costraint : _constraints) {
            boolean _not;
            String _name = baseProperty.getName();
            String _name_1 = costraint.getType().getName();
            String constraintId = String.valueOf(_name) + _name_1;
            boolean _contains = validatedConstraints.contains(constraintId);
            boolean bl2 = _not = !_contains;
            if (!_not) continue;
            validatedConstraints.add(constraintId);
            Constraint baseConstraint = constraintsMap.get(costraint.getType());
            if (baseConstraint == null) continue;
            ConstraintIntervalType _type = costraint.getType();
            boolean _equals = Objects.equal(_type, ConstraintIntervalType.MIN);
            if (_equals) {
                double _parseDouble_1;
                boolean _lessThan;
                double _parseDouble = Double.parseDouble(costraint.getConstraintValues());
                boolean bl3 = _lessThan = _parseDouble < (_parseDouble_1 = Double.parseDouble(baseConstraint.getConstraintValues()));
                if (!_lessThan) continue;
                this.error("The given MIN constraint needs to be bigger or equal as the base MIN value.", costraint, DatatypePackage.Literals.CONSTRAINT__TYPE);
                continue;
            }
            ConstraintIntervalType _type_1 = costraint.getType();
            boolean _equals_1 = Objects.equal(_type_1, ConstraintIntervalType.MAX);
            if (_equals_1) {
                double _parseDouble_3;
                boolean _greaterThan;
                double _parseDouble_2 = Double.parseDouble(costraint.getConstraintValues());
                boolean bl4 = _greaterThan = _parseDouble_2 > (_parseDouble_3 = Double.parseDouble(baseConstraint.getConstraintValues()));
                if (!_greaterThan) continue;
                this.error("The given MAX constraint needs to be smaller or equal as the base MAX value.", costraint, DatatypePackage.Literals.CONSTRAINT__TYPE);
                continue;
            }
            ConstraintIntervalType _type_2 = costraint.getType();
            boolean _equals_2 = Objects.equal(_type_2, ConstraintIntervalType.STRLEN);
            if (_equals_2) {
                double _parseDouble_5;
                boolean _greaterThan_1;
                double _parseDouble_4 = Double.parseDouble(costraint.getConstraintValues());
                boolean bl5 = _greaterThan_1 = _parseDouble_4 > (_parseDouble_5 = Double.parseDouble(baseConstraint.getConstraintValues()));
                if (!_greaterThan_1) continue;
                this.error("The given STRLEN constraint needs to be smaller or equal as the base STRLEN value.", costraint, DatatypePackage.Literals.CONSTRAINT__TYPE);
                continue;
            }
            ConstraintIntervalType _type_3 = costraint.getType();
            boolean _equals_3 = Objects.equal(_type_3, ConstraintIntervalType.NULLABLE);
            if (_equals_3) {
                if (costraint.getConstraintValues().equals("true") && baseConstraint.getConstraintValues().equals("false")) {
                    this.error("If the constraint NULLABLE of the base type is false than it can not changed.", costraint, DatatypePackage.Literals.CONSTRAINT__TYPE);
                    continue;
                }
                this.error("The constraint is already defined in the base property.", costraint, DatatypePackage.Literals.CONSTRAINT__TYPE);
                continue;
            }
            this.error("The constraint is already defined in the base property.", costraint, DatatypePackage.Literals.CONSTRAINT__TYPE);
        }
        return validatedConstraints;
    }

    public ArrayList<String> validateOverriddenProperties(EList<Property> properties, EList<Property> extProperties, ArrayList<String> validatedConstraints) {
        Functions.Function1<Property, String> _function = it -> it.getName();
        Functions.Function1<Property, Property> _function_1 = it -> it;
        Map<String, Property> propertiesMap = MapExtensions.mapValues(IterableExtensions.toMap(properties, _function), _function_1);
        EcoreUtil.EqualityHelper equalHelper = new EcoreUtil.EqualityHelper();
        for (Property property : extProperties) {
            boolean _equals_1;
            boolean _not_1;
            boolean _isMultiplicity_1;
            boolean _isMultiplicity;
            boolean _notEquals;
            boolean _not;
            Property baseProperty = propertiesMap.get(property.getName());
            if (baseProperty == null) continue;
            boolean _equals = equalHelper.equals(property.getPresence(), baseProperty.getPresence());
            boolean bl = _not = !_equals;
            if (_not) {
                this.error("The presence is incompatible to presence of the base type.", property, DatatypePackage.Literals.PROPERTY__PRESENCE);
            }
            if (_notEquals = (_isMultiplicity = property.isMultiplicity()) ^ (_isMultiplicity_1 = baseProperty.isMultiplicity())) {
                this.error("The multiplicity is incompatible to multiplicity of the base type.", property, DatatypePackage.Literals.PROPERTY__MULTIPLICITY);
            }
            boolean bl2 = _not_1 = !(_equals_1 = equalHelper.equals(property.getType(), baseProperty.getType()));
            if (_not_1) {
                this.error("The property type is incompatible to base type.", property, DatatypePackage.Literals.PROPERTY__TYPE);
            }
            this.validateOvewrittenPropertyAttr(baseProperty, property);
            validatedConstraints.addAll(this.validateOverriddenConstraints(baseProperty, property));
        }
        return validatedConstraints;
    }

    public boolean equalsParamList(List<Param> list1, List<Param> list2) {
        int _size;
        boolean _notEquals;
        int size = list1.size();
        boolean bl = _notEquals = size != (_size = list2.size());
        if (_notEquals) {
            return false;
        }
        EcoreUtil.EqualityHelper equalHelper = new EcoreUtil.EqualityHelper();
        int i = 0;
        while (i < size) {
            boolean _not;
            boolean _equals = equalHelper.equals(list1.get(i), list2.get(i));
            boolean bl2 = _not = !_equals;
            if (_not) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void validateOverriddenOperations(EList<Operation> operations, EList<Operation> extOperations) {
        Functions.Function1<Operation, String> _function = it -> it.getName();
        Functions.Function1<Operation, Operation> _function_1 = it -> it;
        Map<String, Operation> operationsMap = MapExtensions.mapValues(IterableExtensions.toMap(operations, _function), _function_1);
        EcoreUtil.EqualityHelper equalHelper = new EcoreUtil.EqualityHelper();
        for (Operation operation : extOperations) {
            boolean _equals_2;
            boolean _not_3;
            boolean _equalsParamList;
            boolean _not_2;
            boolean _equals_1;
            boolean _not_1;
            boolean _isBreakable_1;
            boolean _isBreakable;
            boolean _notEquals;
            boolean _not;
            Operation baseOperation = operationsMap.get(operation.getName());
            if (baseOperation == null) continue;
            boolean _equals = equalHelper.equals(operation.getPresence(), baseOperation.getPresence());
            boolean bl = _not = !_equals;
            if (_not) {
                this.error("The presence is incompatible to presence of the base type.", operation, FunctionblockPackage.Literals.OPERATION__PRESENCE);
            }
            if (_notEquals = (_isBreakable = operation.isBreakable()) ^ (_isBreakable_1 = baseOperation.isBreakable())) {
                this.error("The breakable definition is incompatible to base operation.", operation, FunctionblockPackage.Literals.OPERATION__BREAKABLE);
            }
            boolean bl2 = _not_1 = !(_equals_1 = equalHelper.equals(operation.getPresence(), baseOperation.getPresence()));
            if (_not_1) {
                this.error("The presence is incompatible to presence of the base type.", operation, FunctionblockPackage.Literals.OPERATION__PRESENCE);
            }
            boolean bl3 = _not_2 = !(_equalsParamList = this.equalsParamList(operation.getParams(), baseOperation.getParams()));
            if (_not_2) {
                this.error("The parameters are incompatible to base operation parameters.", operation, FunctionblockPackage.Literals.OPERATION__PARAMS);
            }
            boolean bl4 = _not_3 = !(_equals_2 = equalHelper.equals(operation.getReturnType(), baseOperation.getReturnType()));
            if (!_not_3) continue;
            this.error("The return type is incompatible to base type.", operation, FunctionblockPackage.Literals.OPERATION__RETURN_TYPE);
        }
    }

    public void validateOverriddenEvents(EList<Event> events, EList<Event> extEvents) {
        ArrayList<String> validatedConstraints = new ArrayList<String>();
        Functions.Function1<Event, String> _function = it -> it.getName();
        Functions.Function1<Event, Event> _function_1 = it -> it;
        Map<String, Event> eventsMap = MapExtensions.mapValues(IterableExtensions.toMap(events, _function), _function_1);
        for (Event event : extEvents) {
            Event baseEvent = eventsMap.get(event.getName());
            if (baseEvent == null) continue;
            validatedConstraints = this.validateOverriddenProperties(baseEvent.getProperties(), event.getProperties(), validatedConstraints);
        }
    }

    public ArrayList<FunctionBlock> getParentFunctionBlocks(FunctionblockModel baseFunctionblockModel) {
        ArrayList<FunctionBlock> functionBlocks = new ArrayList<FunctionBlock>();
        FunctionblockModel lastFunctionblockModel = baseFunctionblockModel;
        while (lastFunctionblockModel.getSuperType() != null) {
            boolean _tripleEquals;
            FunctionblockModel _superType = lastFunctionblockModel.getSuperType();
            boolean bl = _tripleEquals = lastFunctionblockModel == _superType;
            if (_tripleEquals) {
                return functionBlocks;
            }
            lastFunctionblockModel = lastFunctionblockModel.getSuperType();
            functionBlocks.add(lastFunctionblockModel.getFunctionblock());
        }
        return functionBlocks;
    }

    @Check
    public void checkConfigurationOverriddenProperties(FunctionblockModel baseFunctionblockModel) {
        ArrayList<String> validatedConstraints = new ArrayList<String>();
        FunctionBlock baseFb = baseFunctionblockModel.getFunctionblock();
        ArrayList<FunctionBlock> parentFunctionBlocks = this.getParentFunctionBlocks(baseFunctionblockModel);
        for (FunctionBlock parentFb : parentFunctionBlocks) {
            if (parentFb.getConfiguration() == null || baseFb.getConfiguration() == null) continue;
            this.validateOverriddenProperties(parentFb.getConfiguration().getProperties(), baseFb.getConfiguration().getProperties(), validatedConstraints);
        }
    }

    @Check
    public void checkStatusOverriddenProperties(FunctionblockModel baseFunctionblockModel) {
        ArrayList<String> validatedConstraints = new ArrayList<String>();
        FunctionBlock baseFb = baseFunctionblockModel.getFunctionblock();
        ArrayList<FunctionBlock> parentFunctionBlocks = this.getParentFunctionBlocks(baseFunctionblockModel);
        for (FunctionBlock parentFb : parentFunctionBlocks) {
            if (parentFb.getStatus() == null || baseFb.getStatus() == null) continue;
            this.validateOverriddenProperties(parentFb.getStatus().getProperties(), baseFb.getStatus().getProperties(), validatedConstraints);
        }
    }

    @Check
    public void checkFaultOverriddenProperties(FunctionblockModel baseFunctionblockModel) {
        ArrayList<String> validatedConstraints = new ArrayList<String>();
        FunctionBlock baseFb = baseFunctionblockModel.getFunctionblock();
        ArrayList<FunctionBlock> parentFunctionBlocks = this.getParentFunctionBlocks(baseFunctionblockModel);
        for (FunctionBlock parentFb : parentFunctionBlocks) {
            if (parentFb.getFault() == null || baseFb.getFault() == null) continue;
            this.validateOverriddenProperties(parentFb.getFault().getProperties(), baseFb.getFault().getProperties(), validatedConstraints);
        }
    }

    @Check
    public void checkEventsOverriddenProperties(FunctionblockModel baseFunctionblockModel) {
        FunctionBlock baseFb = baseFunctionblockModel.getFunctionblock();
        ArrayList<FunctionBlock> parentFunctionBlocks = this.getParentFunctionBlocks(baseFunctionblockModel);
        for (FunctionBlock parentFb : parentFunctionBlocks) {
            this.validateOverriddenEvents(parentFb.getEvents(), baseFb.getEvents());
        }
    }

    @Check
    public void checkOperationsOverriddenProperties(FunctionblockModel baseFunctionblockModel) {
        FunctionBlock baseFb = baseFunctionblockModel.getFunctionblock();
        ArrayList<FunctionBlock> parentFunctionBlocks = this.getParentFunctionBlocks(baseFunctionblockModel);
        for (FunctionBlock parentFb : parentFunctionBlocks) {
            this.validateOverriddenOperations(parentFb.getOperations(), baseFb.getOperations());
        }
    }
}

