/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.datatype.validation;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.vorto.core.api.model.datatype.DictionaryPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelReference;

public class ValidatorUtils {
    public static final ModelTypeBasedChildrenSupplier entityTypeToChildrenSupplierFunction = ValidatorUtils.newModelTypeChildrenSupplier(ValidatorUtils.newEntityToFunctionMap());

    public static EObject getParentOfType(EObject obj, Class<?> type) {
        if (obj == null) {
            return null;
        }
        boolean _isInstance = type.isInstance(obj);
        if (_isInstance) {
            return obj;
        }
        return ValidatorUtils.getParentOfType(obj.eContainer(), type);
    }

    public static boolean isTypeInReferences(Model type, EList<ModelReference> references) {
        String _namespace = type.getNamespace();
        String _plus = String.valueOf(_namespace) + ".";
        String _name = type.getName();
        String _plus_1 = String.valueOf(_plus) + _name;
        String _plus_2 = String.valueOf(_plus_1) + ":";
        String _version = type.getVersion();
        String propertySig = String.valueOf(_plus_2) + _version;
        for (ModelReference ref : references) {
            String _importedNamespace = ref.getImportedNamespace();
            String _plus_3 = String.valueOf(_importedNamespace) + ":";
            String _version_1 = ref.getVersion();
            String refSig = String.valueOf(_plus_3) + _version_1;
            boolean _equals = propertySig.equals(refSig);
            if (!_equals) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCircularReference(Model parent, Model child, ModelTypeBasedChildrenSupplier modelTypeChildrenSupplier) {
        boolean _isEquals = ValidatorUtils.isEquals(parent, child);
        if (_isEquals) {
            return true;
        }
        Function childrenSupplier = (Function)modelTypeChildrenSupplier.apply(child.getClass());
        if (childrenSupplier != null) {
            Collection _apply = (Collection)childrenSupplier.apply(child);
            for (Model childrenOfChildren : _apply) {
                boolean _hasCircularReference = ValidatorUtils.hasCircularReference(parent, childrenOfChildren, modelTypeChildrenSupplier);
                if (!_hasCircularReference) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isEquals(Model a, Model b) {
        if (a instanceof Entity && b instanceof Entity || a instanceof Enum && b instanceof Enum || a instanceof FunctionblockModel && b instanceof FunctionblockModel || a instanceof InformationModel && b instanceof InformationModel) {
            return a.getNamespace().equals(b.getNamespace()) && a.getName().equals(b.getName()) && a.getVersion().equals(b.getVersion());
        }
        return false;
    }

    private static HashMap<Class<?>, Function<Model, Collection<Model>>> newEntityToFunctionMap() {
        HashMap entityToFunctionMap = new HashMap();
        EntityChildrenSupplier _entityChildrenSupplier = new EntityChildrenSupplier();
        entityToFunctionMap.put(Entity.class, _entityChildrenSupplier);
        return entityToFunctionMap;
    }

    public static ModelTypeBasedChildrenSupplier newModelTypeChildrenSupplier(final Map<Class<?>, Function<Model, Collection<Model>>> entityToFunctionMap) {
        return new ModelTypeBasedChildrenSupplier(){

            @Override
            public Function<Model, Collection<Model>> apply(Class<?> input) {
                Set _entrySet = entityToFunctionMap.entrySet();
                for (Map.Entry entry : _entrySet) {
                    boolean _isAssignableFrom = ((Class)entry.getKey()).isAssignableFrom(input);
                    if (!_isAssignableFrom) continue;
                    return (Function)entry.getValue();
                }
                return null;
            }
        };
    }

    public static abstract class AbstractChildrenSupplier
    implements Function<Model, Collection<Model>> {
        public Collection<Model> getReferenceModels(Collection<Property> properties) {
            ArrayList<Model> models = Lists.newArrayList();
            for (Property property : properties) {
                models.addAll(this.getReferenceModels(property.getType()));
            }
            return models;
        }

        public Collection<Model> getReferenceModels(PropertyType type) {
            ArrayList<Model> models = Lists.newArrayList();
            if (type instanceof ObjectPropertyType) {
                ObjectPropertyType propertyType = (ObjectPropertyType)type;
                models.add(propertyType.getType());
            } else if (type instanceof DictionaryPropertyType) {
                DictionaryPropertyType dictionaryType = (DictionaryPropertyType)type;
                models.addAll(this.getReferenceModels(dictionaryType.getKeyType()));
                models.addAll(this.getReferenceModels(dictionaryType.getValueType()));
            }
            return models;
        }
    }

    public static class EntityChildrenSupplier
    extends AbstractChildrenSupplier {
        @Override
        public Collection<Model> apply(Model input) {
            boolean _tripleNotEquals;
            ArrayList<Model> children = Lists.newArrayList();
            Entity parent = (Entity)input;
            Entity _superType = parent.getSuperType();
            boolean bl = _tripleNotEquals = _superType != null;
            if (_tripleNotEquals) {
                children.add(parent.getSuperType());
            }
            children.addAll(this.getReferenceModels(parent.getProperties()));
            return children;
        }
    }

    public static interface ModelTypeBasedChildrenSupplier
    extends Function<Class<?>, Function<Model, Collection<Model>>> {
    }
}

