/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.datatype.validation;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Pair;

public class PropertyConstraintMappingValidation {
    private String errorMsg = "Constraint cannot apply on this property's datatype";
    private final String[] intervalArr = new String[]{"MAX", "MIN", "SCALING", "DEFAULT"};
    private final String[] boolArr = new String[]{"DEFAULT"};
    private final String[] strArr = new String[]{"STRLEN", "REGEX", "DEFAULT"};
    private final String[] mimeArr = new String[]{"MIMETYPE"};
    private final String[] byteArr = (String[])Conversions.unwrapArray(Iterables.concat((Iterable)Conversions.doWrapArray(this.intervalArr), (Iterable)Conversions.doWrapArray(this.mimeArr)), String.class);
    private final HashMap<String, String[]> valueTypeMap = CollectionLiterals.newHashMap(Pair.of("int", this.intervalArr), Pair.of("byte", this.byteArr), Pair.of("float", this.intervalArr), Pair.of("long", this.intervalArr), Pair.of("short", this.intervalArr), Pair.of("double", this.intervalArr), Pair.of("dateTime", this.intervalArr), Pair.of("string", this.strArr), Pair.of("boolean", this.boolArr), Pair.of("base64Binary", this.mimeArr));

    public final boolean checkPropertyConstraints(PrimitiveType type, Constraint cons) {
        Object[] arr = this.valueTypeMap.get(type.getLiteral());
        boolean _equals = cons.getType().getLiteral().toUpperCase().equals("NULLABLE");
        if (_equals) {
            return true;
        }
        if (arr == null || !ArrayExtensions.contains(arr, cons.getType().getLiteral())) {
            this.setErrorMessage("Constraint cannot apply on this property's datatype");
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    private String setErrorMessage(String err) {
        this.errorMsg = err;
        return this.errorMsg;
    }
}

