/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.datatype.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class DatatypeValueConverter
extends DefaultTerminalConverters {
    @ValueConverter(rule="EnumLiteralName")
    public IValueConverter<String> EnumLiteralName() {
        return new IValueConverter<String>(){

            @Override
            public String toValue(String string, INode node) throws ValueConverterException {
                String[] namespaces = string.split("\\.");
                if (namespaces.length == 2) {
                    Map<String, String> importedModules = this.getImportedModules(node.getRootNode());
                    String fullName = String.valueOf(importedModules.get(namespaces[0])) + "." + string;
                    return fullName;
                }
                return string;
            }

            @Override
            public String toString(String value) throws ValueConverterException {
                String[] namespaces = value.split("\\.");
                if (namespaces.length > 1) {
                    return String.valueOf(namespaces[namespaces.length - 2]) + "." + namespaces[namespaces.length - 1];
                }
                return value;
            }

            public Map<String, String> getImportedModules(ICompositeNode rootNode) {
                HashMap<String, String> importedModules = new HashMap<String, String>();
                rootNode.getAsTreeIterable().forEach(new Csmr(importedModules));
                return importedModules;
            }

            class Csmr
            implements Consumer<INode> {
                private Map<String, String> importedModules = new HashMap<String, String>();

                public Csmr(Map<String, String> importedModules) {
                    this.importedModules = importedModules;
                }

                @Override
                public void accept(INode t) {
                    String[] components;
                    String textWithoutWhitespace = Strings.removeLeadingWhitespace(t.getText());
                    if (textWithoutWhitespace != null && textWithoutWhitespace.startsWith("using") && (components = textWithoutWhitespace.split("\\s+")).length > 1) {
                        String[] namespace = components[1].split("\\.");
                        this.importedModules.put(namespace[namespace.length - 1], String.join((CharSequence)".", Arrays.copyOfRange(namespace, 0, namespace.length - 1)));
                    }
                }
            }
        };
    }
}

