/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.template.plugin;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class GeneratorMainTemplate
implements IFileTemplate<InformationModel> {
    private String serviceKey;

    public GeneratorMainTemplate(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    @Override
    public String getFileName(InformationModel context) {
        String _firstUpper = StringExtensions.toFirstUpper(this.serviceKey);
        return _firstUpper + "Generator.xtend";
    }

    @Override
    public String getPath(InformationModel context) {
        String _lowerCase = this.serviceKey.toLowerCase();
        String _plus = "generator-parent/generator-" + _lowerCase;
        return _plus + "/src/main/java/com/mycompany/plugin";
    }

    @Override
    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package com.mycompany.plugin");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import com.mycompany.plugin.templates.HelloWorldTemplate");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.vorto.codegen.api.GenerationResultZip");
        _builder.newLine();
        _builder.append("import org.eclipse.vorto.codegen.api.GeneratorInfo");
        _builder.newLine();
        _builder.append("import org.eclipse.vorto.codegen.api.GeneratorTaskFromFileTemplate");
        _builder.newLine();
        _builder.append("import org.eclipse.vorto.codegen.api.IVortoCodeGenProgressMonitor");
        _builder.newLine();
        _builder.append("import org.eclipse.vorto.codegen.api.IVortoCodeGenerator");
        _builder.newLine();
        _builder.append("import org.eclipse.vorto.codegen.api.InvocationContext");
        _builder.newLine();
        _builder.append("import org.eclipse.vorto.codegen.api.VortoCodeGeneratorException");
        _builder.newLine();
        _builder.append("import org.eclipse.vorto.core.api.model.informationmodel.InformationModel");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ");
        String _firstUpper = StringExtensions.toFirstUpper(this.serviceKey.toLowerCase());
        _builder.append(_firstUpper);
        _builder.append("Generator implements IVortoCodeGenerator {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("override generate(InformationModel infomodel, InvocationContext context,");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var output = new GenerationResultZip(infomodel,getServiceKey());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var helloworldTemplate = new GeneratorTaskFromFileTemplate(new HelloWorldTemplate())");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("helloworldTemplate.generate(infomodel,context,output)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return output");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("override getServiceKey() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return \"");
        String _lowerCase = this.serviceKey.toLowerCase();
        _builder.append(_lowerCase, "\t\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("override getInfo() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return GeneratorInfo.basicInfo(\"");
        _builder.append(this.serviceKey, "\t\t");
        _builder.append("\",\"");
        String _firstUpper_1 = StringExtensions.toFirstUpper(this.serviceKey);
        _builder.append(_firstUpper_1, "\t\t");
        _builder.append(" Generator description\",\"Vendor XY\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }
}

