/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.openapi.templates;

import com.google.common.base.Objects;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.openapi.Utils;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.ConstraintRule;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Event;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.PrimitiveParam;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.IFileTemplate;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class OpenAPITemplate
implements IFileTemplate<InformationModel> {
    @Override
    public String getFileName(InformationModel model) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = model.getName();
        _builder.append(_name);
        _builder.append("-openapi-v3.yml");
        return _builder.toString();
    }

    @Override
    public String getPath(InformationModel context) {
        return null;
    }

    @Override
    public String getContent(InformationModel infomodel, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("### Generated by Eclipse Vorto OpenAPI Generator from Model '");
        String _namespace = infomodel.getNamespace();
        _builder.append(_namespace);
        _builder.append(":");
        String _name = infomodel.getName();
        _builder.append(_name);
        _builder.append(":");
        String _version = infomodel.getVersion();
        _builder.append(_version);
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("openapi: 3.0.0");
        _builder.newLine();
        _builder.append("info:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("title: Bosch IoT Things HTTP API for ");
        String _name_1 = infomodel.getName();
        _builder.append(_name_1, "  ");
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Bosch IoT Things enables applications to manage digital twins of IoT device assets in a simple, convenient, robust, and secure way.");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("These descriptions focus on the JSON-based, REST-like API of the <a href=\"https://vorto.eclipse.org/#/details/");
        String _namespace_1 = infomodel.getNamespace();
        _builder.append(_namespace_1, "    ");
        _builder.append(":");
        String _name_2 = infomodel.getName();
        _builder.append(_name_2, "    ");
        _builder.append(":");
        String _version_1 = infomodel.getVersion();
        _builder.append(_version_1, "    ");
        _builder.append("\">");
        String _name_3 = infomodel.getName();
        _builder.append(_name_3, "    ");
        _builder.append("</a> Vorto Model.");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("For more details on concepts, please consult the full [documentation](https://things.eu-1.bosch-iot-suite.com/dokuwiki/).");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("version: \"");
        String _version_2 = infomodel.getVersion();
        _builder.append(_version_2, "  ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("servers:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("- url: https://things.eu-1.bosch-iot-suite.com/api/2");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("description: \"Bosch IoT Things Service\"");
        _builder.newLine();
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("- name: Things");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("description: Manage every Thing");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("- name: Features");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("description: Features of your ");
        String _name_4 = infomodel.getName();
        _builder.append(_name_4, "    ");
        _builder.append(" things");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("- name: Things-Search");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("description: Find every Thing");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("- name: Messages");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("description: Send messages to / Receive event messages from ");
        String _name_5 = infomodel.getName();
        _builder.append(_name_5, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("security:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("- bearerAuth: []");
        _builder.newLine();
        _builder.append("paths:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("###");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("### Things");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("###");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("'/things':");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("get:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("summary: Retrieve multiple Things with specified IDs");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Returns all things passed in by the required parameter `ids`, which you (the authorized subject) are allowed to read.");
        _builder.newLine();
        _builder.append("      ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Optionally, if you want to retrieve only some of the thing's fields, you can use the specific field selectors (see parameter `fields`) .");
        _builder.newLine();
        _builder.append("      ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Tip: If you don't know the thing IDs, start with the search resource.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- Things");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("parameters:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- name: ids");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("in: query");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Contains a comma-separated list of `thingId`s to retrieve in one single request.");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("required: true");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/thingFieldsQueryParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'200':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The successfully completed request contains as its result the first 200 things, ");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("for which the user has at least read permission. The list is sorted by the `thingId`.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("type: array");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("items:");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("$ref: '#/components/schemas/Thing'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'400':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed. At least one of the defined");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("query parameters was invalid.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'401':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: The request could not be completed due to missing authentication.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'403':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed due to a missing or invalid API");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("Token.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'414':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed due to an URI length exceeding 8k");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("characters.");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("'/things/{thingId}':");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("get:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("summary: Retrieve a specific Thing");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Returns the thing identified by the `thingId` path parameter. The");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("response includes details about the thing.");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Optionally, you can use the field selectors (see parameter `fields`) to only get specific");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("fields, which you are interested in.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- Things");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("parameters:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/thingFieldsQueryParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/ifMatchHeaderParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/ifNoneMatchHeaderParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'200':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: The request successfully returned the specific Thing.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("headers:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("ETag:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("The (current server-side) ETag for this (sub-)resource. For top-level resources it is in the format");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("\"rev:[revision]\", for sub-resources it has the format \"hash:[calculated-hash]\".");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/Thing'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'304':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '#/components/responses/notModified'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'400':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed. Possible reasons:");
        _builder.newLine();
        _builder.append("            ");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("* the `thingId` does not conform to the namespaced entity ID notation (see [Ditto documentation on namespaced entity IDs](https://www.eclipse.org/ditto/basic-namespaces-and-names.html#namespaced-id))");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("* at least one of the defined query parameters is invalid");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'401':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: The request could not be completed due to missing authentication.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'403':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed due to a missing or invalid API");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("Token.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'404':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("The request could not be completed. The Thing with the given ID was");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("not found.");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("'412':");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '#/components/responses/preconditionFailed'");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("###");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("### Things-Search");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("###");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("'/search/things':");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("get:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("summary: Search for Things");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("This resource can be used to search for things.");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* The query parameter `filter` is not mandatory. If it is not set, the");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("result contains all things which the logged in user is allowed to read.");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* The search is case sensitive. In case you don't know how exactly the");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("spelling of the namespace, name, attribute, feature etc. is, use the *like*");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("notation for filtering");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* The search result is limited to the things within the namespace (or namespaces)");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("the solution is configured for. You can explicitly search in specific namespaces");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("by including them in the query via the *namespaces* parameter.");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* The resource supports sorting and paging. If paging is not explicitly");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("specified by means of the `size` option, a default count of `25`");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("documents is returned.");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* The internal search index is \"eventually consistent\".  Consistency with the latest");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("thing updates should recover within milliseconds.");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("parameters:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/searchFilter'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/namespacesFilter'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/thingFieldsQueryParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- name: option");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("in: query");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Possible values for the parameter:");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("#### Sort operations");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* ```sort([+|-]{property})```");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* ```sort([+|-]{property},[+|-]{property},...)```");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("#### Paging operations");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* ```size({page-size})```  Maximum allowed page size is `200`. Default page size is `25`.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* ```cursor({cursor-id})```  Start the search from the cursor location. Specify the cursor ID without");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("quotation marks. Cursor IDs are given in search responses and mark the position after the last entry of");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("the previous search. The meaning of cursor IDs is unspecified and may change without notice.");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("The paging option `limit({offset},{count})` is deprecated.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("It may result in slow queries or timeouts and will be removed eventually.");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("#### Examples:");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* ```sort(+thingId)```");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* ```sort(-attributes/manufacturer)```");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* ```sort(+thingId,-attributes/manufacturer)```");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* ```size(10)``` return 10 results");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* ```cursor(LOREMIPSUM)```  return results after the position of the cursor `LOREMIPSUM`.");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("#### Combine:");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("If you need to specify multiple options, when using the swagger UI just write each option in a new line.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("When using the plain REST API programmatically,");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("you will need to separate the options using a comma (,) character.");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("```size(200),cursor(LOREMIPSUM)```");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("The deprecated paging option `limit` may not be combined with the other paging options `size` and `cursor`.");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("required: false");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: array");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("items:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- Things-Search");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'200':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: An array of the matching things.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/SearchResultThings'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'400':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The request could not be completed. A provided parameter is in a");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("wrong format.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'401':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The request could not be completed due to missing authentication.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'403':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The request could not be completed due to an invalid authentication.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'504':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The request ran out of time to execute on the the back-end. Optimize your query and try again.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("'/search/things/count':");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("get:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("summary: Count Things");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("This resource can be used to count things.");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The query parameter `filter` is not mandatory. If it is not set there is");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("returned the total amount of things which the logged in user is allowed");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("to read.");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("To search for nested properties, we use JSON Pointer notation");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("(RFC-6901). See the following example how to search for the sub property");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("`location` of the parent property `attributes` with a forward slash as");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("separator:");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("```eq(attributes/location,\"kitchen\")```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The search result is limited to the Things within the namespace (or namespaces) the solution is configured");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("for. You can explicitly search in other namespaces by including them in the query via the `namespaces`");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("parameter.");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("parameters:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/searchFilter'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/namespacesFilter'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- Things-Search");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'200':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: A number indicating the amount of matched things");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/SearchResultThingsCount'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'400':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The request could not be completed. A provided parameter is in a");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("wrong format.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'401':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The request could not be completed due to missing authentication.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'403':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The request could not be completed due to an invalid authentication.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'504':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The request ran out of time to execute on the the back-end. Optimize your query and try again.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("###");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("### ");
        String _name_6 = infomodel.getName();
        _builder.append(_name_6, "  ");
        _builder.append(" Features");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("###");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("'/things/{thingId}/features':");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("get:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("summary: List all features of a ");
        String _name_7 = infomodel.getName();
        _builder.append(_name_7, "      ");
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Returns all features of the ");
        String _name_8 = infomodel.getName();
        _builder.append(_name_8, "        ");
        _builder.append(" thing identified by the `thingId` path parameter.");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("tags:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- Features");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("parameters:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/featuresFieldsQueryParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/ifMatchHeaderParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- $ref: '#/components/parameters/ifNoneMatchHeaderParam'");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'200':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The list of features of the ");
        String _name_9 = infomodel.getName();
        _builder.append(_name_9, "            ");
        _builder.append(" were successfully retrieved.");
        _builder.newLineIfNotEmpty();
        _builder.append("          ");
        _builder.append("headers:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("ETag:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("The (current server-side) ETag for this (sub-)resource. For top-level resources it is in the format");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("\"rev:[revision]\", for sub-resources it has the format \"hash:[calculated-hash]\".");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/");
        String _name_10 = infomodel.getName();
        _builder.append(_name_10, "                ");
        _builder.append("Features'");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("'304':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("$ref: '#/components/responses/notModified'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'400':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The request could not be completed. The `thingId` either");
        _builder.newLine();
        _builder.append("            ");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("* does not conform to RFC-2396 (URI)");
        _builder.newLine();
        _builder.append("              ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("Or at least one of the defined query parameters was invalid.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'401':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The request could not be completed due to missing authentication.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'404':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The request could not be completed. The Thing with the given ID was not found or the Features have not");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("been defined.");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("'412':");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("$ref: '#/components/responses/preconditionFailed'");
        _builder.newLine();
        EList<FunctionblockProperty> _properties = infomodel.getProperties();
        for (FunctionblockProperty functionblockProperty : _properties) {
            _builder.append("  ");
            _builder.append("'/things/{thingId}/features/");
            String _name_11 = functionblockProperty.getName();
            _builder.append(_name_11, "  ");
            _builder.append("':");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("  ");
            _builder.append("get:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("summary: Retrieve the ");
            String _name_12 = functionblockProperty.getName();
            _builder.append(_name_12, "      ");
            _builder.append(" of the ");
            String _name_13 = infomodel.getName();
            _builder.append(_name_13, "      ");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("description: |-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("Returns the specific feature `");
            String _name_14 = functionblockProperty.getName();
            _builder.append(_name_14, "        ");
            _builder.append("`");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("of the thing identified by the `thingId` path parameter.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("tags:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- Features");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("parameters:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/featureFieldsQueryParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/ifMatchHeaderParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/ifNoneMatchHeaderParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("responses:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'200':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: The ");
            String _name_15 = functionblockProperty.getName();
            _builder.append(_name_15, "          ");
            _builder.append(" was successfully retrieved.");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/");
            String _name_16 = functionblockProperty.getType().getName();
            _builder.append(_name_16, "                ");
            _builder.append("Feature'");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'304':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("$ref: '#/components/responses/notModified'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'400':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: |-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("The request could not be completed. The `thingId` either");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("* does not conform to RFC-2396 (URI)");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("Or at least one of the defined query parameters was invalid.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'401':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: The request could not be completed due to missing authentication.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'404':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: |-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("The request could not be completed. The Thing with the given ID or the Feature with the specified");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("`featureId` was not found.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'412':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("$ref: '#/components/responses/preconditionFailed'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("'/things/{thingId}/features/");
            String string = functionblockProperty.getName();
            _builder.append(string, "  ");
            _builder.append("/properties':");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("  ");
            _builder.append("get:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("summary: Retrieve the properties of ");
            String _name_18 = functionblockProperty.getName();
            _builder.append(_name_18, "      ");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("description: |-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("Returns all properties of the feature `");
            String _name_19 = functionblockProperty.getName();
            _builder.append(_name_19, "        ");
            _builder.append("` identified by the `thingId` path parameter.");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("tags:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- Features");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("parameters:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/propertiesFieldsQueryParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/ifMatchHeaderParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/ifNoneMatchHeaderParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("responses:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'200':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: The ");
            String _name_20 = functionblockProperty.getName();
            _builder.append(_name_20, "          ");
            _builder.append(" was successfully retrieved.");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/");
            String _name_21 = functionblockProperty.getType().getName();
            _builder.append(_name_21, "                ");
            _builder.append("Properties'");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'304':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("$ref: '#/components/responses/notModified'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'400':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: |-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("The request could not be completed. The `thingId` either");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("* does not conform to RFC-2396 (URI)");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("Or at least one of the defined query parameters was invalid.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'401':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: The request could not be completed due to missing authentication.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'404':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: |-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("The request could not be completed. The Thing with the given ID or the Feature with the specified");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("`featureId` was not found.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'412':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("$ref: '#/components/responses/preconditionFailed'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("'/things/{thingId}/features/");
            String _name_22 = functionblockProperty.getName();
            _builder.append(_name_22, "  ");
            _builder.append("/properties/{propertyPath}':");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("  ");
            _builder.append("get:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("summary: Retrieve a specific property of ");
            String _name_23 = functionblockProperty.getName();
            _builder.append(_name_23, "      ");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("description: |-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("Returns the specific property path of the feature `");
            String _name_24 = functionblockProperty.getName();
            _builder.append(_name_24, "        ");
            _builder.append("` identified by the `thingId` path parameter.");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("      \t");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("The property (JSON) can be referenced");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("hierarchically, by applying JSON Pointer notation (RFC-6901)");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("tags:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- Features");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("parameters:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/propertyPathPathParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/ifMatchHeaderParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/parameters/ifNoneMatchHeaderParam'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("    ");
            _builder.append("responses:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'200':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: The Property was successfully retrieved.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("headers:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("ETag:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("description: |-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("The (current server-side) ETag for this (sub-)resource. For top-level resources it is in the format");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("\"rev:[revision]\", for sub-resources it has the format \"hash:[calculated-hash]\".");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("type: string");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'304':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("$ref: '#/components/responses/notModified'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'400':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: |-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("The request could not be completed. The `thingId` either");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("* does not conform to RFC-2396 (URI)");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("Or at least one of the defined query parameters was invalid.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'401':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: The request could not be completed due to missing authentication.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'404':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("description: |-");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("The request could not be completed. The Thing with the given ID or the Feature with the specified");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("`featureId` was not found.");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("content:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("          ");
            _builder.append("application/json:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("            ");
            _builder.append("schema:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("              ");
            _builder.append("$ref: '#/components/schemas/AdvancedError'");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("      ");
            _builder.append("'412':");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("        ");
            _builder.append("$ref: '#/components/responses/preconditionFailed'\t\t          ");
            _builder.newLine();
            if (functionblockProperty.getType().getFunctionblock().getConfiguration() != null && !functionblockProperty.getType().getFunctionblock().getConfiguration().getProperties().isEmpty()) {
                EList<Property> _properties_1 = functionblockProperty.getType().getFunctionblock().getConfiguration().getProperties();
                for (Property configurationProperty : _properties_1) {
                    _builder.append("  ");
                    _builder.append("'/things/{thingId}/features/");
                    String _name_25 = functionblockProperty.getName();
                    _builder.append(_name_25, "  ");
                    _builder.append("/properties/configuration/");
                    String _name_26 = configurationProperty.getName();
                    _builder.append(_name_26, "  ");
                    _builder.append("':");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("  ");
                    _builder.append("put:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("summary: Sets the device configuration property ");
                    String _name_27 = configurationProperty.getName();
                    _builder.append(_name_27, "      ");
                    _builder.append(" of the ");
                    String _name_28 = functionblockProperty.getName();
                    _builder.append(_name_28, "      ");
                    _builder.append(" feature");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("description: |-");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("Sets the ");
                    String _name_29 = configurationProperty.getName();
                    _builder.append(_name_29, "        ");
                    _builder.append(" of the ");
                    String _name_30 = functionblockProperty.getName();
                    _builder.append(_name_30, "        ");
                    _builder.append(" feature, identified by the");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("`thingId` path parameter. The set configuration property is transmitted to the device, once the device is connected.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("tags:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("- Features");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("parameters:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("responses:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'204':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: The Property was successfully updated.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'400':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: |-");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("The request could not be completed. The `thingId` either");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("* does not conform to RFC-2396 (URI)");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("Or the JSON was invalid.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("schema:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("              ");
                    _builder.append("$ref: '#/components/schemas/AdvancedError'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'401':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: The request could not be completed due to missing authentication.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("schema:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("              ");
                    _builder.append("$ref: '#/components/schemas/AdvancedError'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'402':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: The request could not be completed due to exceeded data volume.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("schema:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("              ");
                    _builder.append("$ref: '#/components/schemas/AdvancedError'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'403':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: |-");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("The request could not be completed. Either");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("* due to a missing or invalid API Token.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("* as the caller had insufficient permissions.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("For creating/updating a Property of an existing Feature `WRITE` permission is required.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("schema:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("              ");
                    _builder.append("$ref: '#/components/schemas/AdvancedError'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'404':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("description: |-");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("The request could not be completed. The Thing or the Feature with");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("the given ID was not found.");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("          ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("            ");
                    _builder.append("schema:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("              ");
                    _builder.append("$ref: '#/components/schemas/AdvancedError'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'412':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("$ref: '#/components/responses/preconditionFailed'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("'413':");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("$ref: '#/components/responses/entityTooLarge'");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("    ");
                    _builder.append("requestBody:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("      ");
                    _builder.append("$ref: '#/components/requestBodies/");
                    String _name_31 = functionblockProperty.getType().getName();
                    _builder.append(_name_31, "        ");
                    String _firstUpper = StringExtensions.toFirstUpper(configurationProperty.getName());
                    _builder.append(_firstUpper, "        ");
                    _builder.append("ConfigurationValue'");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("  ");
            _builder.append("###");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("### Messages");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("###");
            _builder.newLine();
            EList<Event> _events = functionblockProperty.getType().getFunctionblock().getEvents();
            for (Event event : _events) {
                _builder.append("  ");
                _builder.append("'/things/{thingId}/features/");
                String _name_32 = functionblockProperty.getName();
                _builder.append(_name_32, "  ");
                _builder.append("/outbox/messages/");
                String _name_33 = event.getName();
                _builder.append(_name_33, "  ");
                _builder.append("':");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("post:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("summary: Send a message FROM a specific Feature `");
                String _name_34 = functionblockProperty.getName();
                _builder.append(_name_34, "      ");
                _builder.append("` of a specific Thing.");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("Send a message with the subject `");
                String _name_35 = event.getName();
                _builder.append(_name_35, "        ");
                _builder.append("` **from** the feature");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("specified by the featureId `");
                String _name_36 = functionblockProperty.getName();
                _builder.append(_name_36, "        ");
                _builder.append("` and `thingId` path parameter. The request");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("body contains the message payload and the `Content-Type` header defines");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("its type.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("The HTTP request blocks until a response to the message is available");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("or until the `timeout` is expired. If many clients respond to");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("the issued message, the first response will complete the HTTP request.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("In order to handle the message in a fire and forget manner, add");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("a query-parameter `timeout=0` to the request.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("### Who");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("You will need `WRITE` permission on the root \"message:/\" resource, or at least");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("the resource `message:/features/featureId/outbox/messages/messageSubject`.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("Such permission is managed  within the policy which controls the access on the thing.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("tags:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("- Messages");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("parameters:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("- $ref: '#/components/parameters/messageTimeoutParam'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("responses:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'202':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: The message was sent (fire and forget).");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'400':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("The request could not be completed. The `thingId` either");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* does not contain the mandatory namespace prefix (java package notation + `:` colon)");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* does not conform to RFC-2396 (URI)");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("Or at least one of the defined path parameters was invalid.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'401':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: The request could not be completed due to missing authentication.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'403':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("The request could not be completed. Either");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* due to a missing or invalid API Token.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* as the caller does not have `WRITE` permission on the resource message:/outbox/messages/`messageSubject`.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'413':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("$ref: '#/components/responses/messageTooLarge'");
                _builder.newLine();
                boolean _isEmpty = event.getProperties().isEmpty();
                boolean _not = !_isEmpty;
                if (!_not) continue;
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("requestBody:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("$ref: '#/components/requestBodies/");
                String _name_37 = functionblockProperty.getType().getName();
                _builder.append(_name_37, "        ");
                String _firstUpper_1 = StringExtensions.toFirstUpper(event.getName());
                _builder.append(_firstUpper_1, "        ");
                _builder.append("EventPayload'");
                _builder.newLineIfNotEmpty();
            }
            EList<Operation> _operations = functionblockProperty.getType().getFunctionblock().getOperations();
            for (Operation operation : _operations) {
                boolean _tripleNotEquals_1;
                boolean _tripleNotEquals;
                _builder.append("  ");
                _builder.append("'/things/{thingId}/features/");
                String _name_38 = functionblockProperty.getName();
                _builder.append(_name_38, "  ");
                _builder.append("/inbox/messages/");
                String _name_39 = operation.getName();
                _builder.append(_name_39, "  ");
                _builder.append("':");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("post:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("summary: Executes the ");
                String _name_40 = operation.getName();
                _builder.append(_name_40, "      ");
                _builder.append(" on the device");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                String _description = operation.getDescription();
                boolean bl = _tripleNotEquals = _description != null;
                if (_tripleNotEquals) {
                    String _description_1 = operation.getDescription();
                    _builder.append(_description_1, "        ");
                } else {
                    _builder.append("Executes the ");
                    String _name_41 = operation.getName();
                    _builder.append(_name_41, "        ");
                    _builder.append(" on the device.");
                }
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("    ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("Send a message with the messageSubject `");
                String _name_42 = operation.getName();
                _builder.append(_name_42, "        ");
                _builder.append("` **to** the feature specified by the featureId `");
                String _name_43 = functionblockProperty.getName();
                _builder.append(_name_43, "        ");
                _builder.append("` ");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("and thingId path parameter. The request body contains the message payload and the Content-Type header defines its type. ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("The API does not provide any kind of acknowledgement that the message was received by the feature.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("The HTTP request blocks until a response to the message is available");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("or until the `timeout` is expired. If many clients respond to");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("the issued message, the first response will complete the HTTP request.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("In order to handle the message in a fire and forget manner, add");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("a query-parameter `timeout=0` to the request.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("### Who");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("You will need `WRITE` permission on the root \"message:/\" resource, or at least");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("the resource `message:/outbox/messages/messageSubject`.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("Such permission is managed  within the policy which controls the access on the thing.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("tags:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("- Messages");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("parameters:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("- $ref: '#/components/parameters/thingIdPathParam'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("- $ref: '#/components/parameters/messageTimeoutParam'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("responses:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'202':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("The message was sent but not necessarily received by the Feature");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("(fire and forget).");
                _builder.newLine();
                ReturnType _returnType = operation.getReturnType();
                boolean bl2 = _tripleNotEquals_1 = _returnType != null;
                if (_tripleNotEquals_1) {
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("  ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("        ");
                    _builder.append("    ");
                    _builder.append("schema:");
                    _builder.newLine();
                    ReturnType _returnType_1 = operation.getReturnType();
                    if (_returnType_1 instanceof ReturnPrimitiveType) {
                        _builder.append("  ");
                        _builder.append("        ");
                        _builder.append("      ");
                        ReturnType _returnType_2 = operation.getReturnType();
                        ReturnType _returnType_3 = operation.getReturnType();
                        CharSequence _wrapIfMultiple = this.wrapIfMultiple(this.getPrimitive(((ReturnPrimitiveType)_returnType_2).getReturnType()).toString(), ((ReturnPrimitiveType)_returnType_3).isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple, "                ");
                        _builder.newLineIfNotEmpty();
                    } else {
                        ReturnType _returnType_4 = operation.getReturnType();
                        if (_returnType_4 instanceof ReturnObjectType) {
                            _builder.append("  ");
                            _builder.append("        ");
                            _builder.append("      ");
                            ReturnType _returnType_5 = operation.getReturnType();
                            String _name_44 = ((ReturnObjectType)_returnType_5).getReturnType().getName();
                            String _plus = "$ref: '#/components/schemas/" + _name_44;
                            String _plus_1 = _plus + "'";
                            ReturnType _returnType_6 = operation.getReturnType();
                            CharSequence _wrapIfMultiple_1 = this.wrapIfMultiple(_plus_1, ((ReturnObjectType)_returnType_6).isMultiplicity());
                            _builder.append((Object)_wrapIfMultiple_1, "                ");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'400':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("The request could not be completed. Possible reasons:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("* the `thingId` does not conform to the namespaced entity ID notation (see [Ditto documentation on namespaced entity IDs](https://www.eclipse.org/ditto/basic-namespaces-and-names.html#namespaced-id)).");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("* at least one of the defined path parameters is invalid.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'401':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: The request could not be completed due to missing authentication.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'403':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("description: |-");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("The request could not be completed. Possible reasons:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          \t");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* the API Token is missing or invalid");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("* the caller has insufficient permissions");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("You need `WRITE` permission on the resource `message:/features/{featureId}/inbox/messages/{messageSubject}`.");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("          ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("            ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("              ");
                _builder.append("$ref: '#/components/schemas/AdvancedError'");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("      ");
                _builder.append("'413':");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("        ");
                _builder.append("$ref: '#/components/responses/messageTooLarge'");
                _builder.newLine();
                boolean _isEmpty_1 = operation.getParams().isEmpty();
                boolean _not_1 = !_isEmpty_1;
                if (!_not_1) continue;
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("requestBody:");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("$ref: '#/components/requestBodies/");
                String _name_45 = functionblockProperty.getType().getName();
                _builder.append(_name_45, "        ");
                String _firstUpper_2 = StringExtensions.toFirstUpper(operation.getName());
                _builder.append(_firstUpper_2, "        ");
                _builder.append("Payload'");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("components:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("schemas:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("AdvancedError:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("properties:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("status:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: integer");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The HTTP status of the error");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("error:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The error code of the occurred exception");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("message:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The message of the error - what went wrong");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("description:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: A description how to fix the error or more details");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("href:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: A link to further information about the error and how to fix it");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- status");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- error");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- message");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Thing:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("type: object");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- thingId");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- policyId");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- attributes");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("- features");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("properties:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("thingId:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: Unique identifier representing the thing");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("policyId:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: The policy ID used for controlling access to this thing, managed by resource `/policies/{policyId}`");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("attributes:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("$ref: '#/components/schemas/Attributes'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("features:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("$ref: '#/components/schemas/");
        String _name_46 = infomodel.getName();
        _builder.append(_name_46, "          ");
        _builder.append("Features'");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("Attributes:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("type: object");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: An arbitrary JSON object describing the attributes of a Thing.");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("SearchResultThings:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("properties:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("items:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: array");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("items:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '#/components/schemas/Thing'");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("cursor:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("SearchResultThingsCount:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("type: integer");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("FeatureDefinition:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("type: array");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("minItems: 1");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("uniqueItems: true");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("items:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("description: \"A single fully qualified identifier of a Feature Definition in the form 'namespace:name:version'\"");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("pattern: ([_a-zA-Z0-9\\-.]+):([_a-zA-Z0-9\\-.]+):([_a-zA-Z0-9\\-.]+)");
        _builder.newLine();
        EList<FunctionblockModel> _referencedFunctionBlocks = Utils.getReferencedFunctionBlocks(infomodel);
        for (FunctionblockModel fb : _referencedFunctionBlocks) {
            boolean _tripleNotEquals_2;
            Configuration _configuration = fb.getFunctionblock().getConfiguration();
            boolean bl = _tripleNotEquals_2 = _configuration != null;
            if (_tripleNotEquals_2) {
                EList<Property> _properties_2 = fb.getFunctionblock().getConfiguration().getProperties();
                for (Property configurationProperty_1 : _properties_2) {
                    _builder.append("    ");
                    String string = fb.getName();
                    _builder.append(string, "    ");
                    String _firstUpper_3 = StringExtensions.toFirstUpper(configurationProperty_1.getName());
                    _builder.append(_firstUpper_3, "    ");
                    _builder.append("ConfigurationValue:");
                    _builder.newLineIfNotEmpty();
                    PropertyType _type = configurationProperty_1.getType();
                    if (_type instanceof PrimitivePropertyType) {
                        _builder.append("    ");
                        _builder.append("  ");
                        PropertyType _type_1 = configurationProperty_1.getType();
                        CharSequence _wrapIfMultiple_2 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_1).getType()).toString(), configurationProperty_1.isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_2, "      ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule = configurationProperty_1.getConstraintRule();
                        boolean _tripleNotEquals_3 = _constraintRule != null;
                        if (!_tripleNotEquals_3) continue;
                        _builder.append("    ");
                        _builder.append("  ");
                        CharSequence _handleConstraints = this.handleConstraints(configurationProperty_1.getConstraintRule());
                        _builder.append((Object)_handleConstraints, "      ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_2 = configurationProperty_1.getType();
                    if (!(_type_2 instanceof ObjectPropertyType)) continue;
                    _builder.append("    ");
                    _builder.append("  ");
                    PropertyType _type_3 = configurationProperty_1.getType();
                    String _name_48 = ((ObjectPropertyType)_type_3).getType().getName();
                    String _plus_2 = "$ref: '#/components/schemas/" + _name_48;
                    String _plus_3 = _plus_2 + "'";
                    CharSequence _wrapIfMultiple_3 = this.wrapIfMultiple(_plus_3, configurationProperty_1.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_3, "      ");
                    _builder.newLineIfNotEmpty();
                }
            }
            EList<Operation> _operations_1 = fb.getFunctionblock().getOperations();
            for (Operation operation_1 : _operations_1) {
                boolean _isEmpty_2 = operation_1.getParams().isEmpty();
                boolean _not_2 = !_isEmpty_2;
                if (!_not_2) continue;
                _builder.append("    ");
                String string = fb.getName();
                _builder.append(string, "    ");
                String _firstUpper_4 = StringExtensions.toFirstUpper(operation_1.getName());
                _builder.append(_firstUpper_4, "    ");
                _builder.append("Payload:");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("properties:");
                _builder.newLine();
                EList<Param> _params = operation_1.getParams();
                for (Param param : _params) {
                    boolean _tripleNotEquals_4;
                    _builder.append("    ");
                    _builder.append("    ");
                    String _name_50 = param.getName();
                    _builder.append(_name_50, "        ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    String _description_2 = param.getDescription();
                    boolean bl3 = _tripleNotEquals_4 = _description_2 != null;
                    if (_tripleNotEquals_4) {
                        _builder.append("description: ");
                        String _description_3 = param.getDescription();
                        _builder.append(_description_3, "          ");
                    }
                    _builder.newLineIfNotEmpty();
                    if (param instanceof PrimitiveParam) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        CharSequence _wrapIfMultiple_4 = this.wrapIfMultiple(this.getPrimitive(((PrimitiveParam)param).getType()).toString(), ((PrimitiveParam)param).isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_4, "          ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_1 = ((PrimitiveParam)param).getConstraintRule();
                        boolean _tripleNotEquals_5 = _constraintRule_1 != null;
                        if (!_tripleNotEquals_5) continue;
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        CharSequence _handleConstraints_1 = this.handleConstraints(((PrimitiveParam)param).getConstraintRule());
                        _builder.append((Object)_handleConstraints_1, "          ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    if (!(param instanceof RefParam)) continue;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    String _name_51 = ((RefParam)param).getType().getName();
                    String _plus_4 = "$ref: '#/components/schemas/" + _name_51;
                    String _plus_5 = _plus_4 + "'";
                    CharSequence _wrapIfMultiple_5 = this.wrapIfMultiple(_plus_5, ((RefParam)param).isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_5, "          ");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("    ");
            String _name_52 = fb.getName();
            _builder.append(_name_52, "    ");
            _builder.append("Properties:");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("type: object");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("description: ");
            String _name_53 = fb.getName();
            _builder.append(_name_53, "      ");
            _builder.append(" properties of ");
            String _name_54 = infomodel.getName();
            _builder.append(_name_54, "      ");
            _builder.newLineIfNotEmpty();
            if (fb.getFunctionblock().getStatus() != null && !fb.getFunctionblock().getStatus().getProperties().isEmpty() || fb.getFunctionblock().getConfiguration() != null && !fb.getFunctionblock().getConfiguration().getProperties().isEmpty()) {
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("properties:");
                _builder.newLine();
            }
            if (fb.getFunctionblock().getStatus() != null && !fb.getFunctionblock().getStatus().getProperties().isEmpty()) {
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("status:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("properties:");
                _builder.newLine();
                EList<Property> _properties_3 = fb.getFunctionblock().getStatus().getProperties();
                for (Property property : _properties_3) {
                    boolean _tripleNotEquals_6;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    String _name_55 = property.getName();
                    _builder.append(_name_55, "            ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    String _description_4 = property.getDescription();
                    boolean bl4 = _tripleNotEquals_6 = _description_4 != null;
                    if (_tripleNotEquals_6) {
                        _builder.append("description: ");
                        String _description_5 = property.getDescription();
                        _builder.append(_description_5, "              ");
                    }
                    _builder.newLineIfNotEmpty();
                    PropertyType _type_4 = property.getType();
                    if (_type_4 instanceof PrimitivePropertyType) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        PropertyType _type_5 = property.getType();
                        CharSequence _wrapIfMultiple_6 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_5).getType()).toString(), property.isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_6, "              ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_2 = property.getConstraintRule();
                        boolean _tripleNotEquals_7 = _constraintRule_2 != null;
                        if (!_tripleNotEquals_7) continue;
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        CharSequence _handleConstraints_2 = this.handleConstraints(property.getConstraintRule());
                        _builder.append((Object)_handleConstraints_2, "              ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_6 = property.getType();
                    if (!(_type_6 instanceof ObjectPropertyType)) continue;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    PropertyType _type_7 = property.getType();
                    String _name_56 = ((ObjectPropertyType)_type_7).getType().getName();
                    String _plus_6 = "$ref: '#/components/schemas/" + _name_56;
                    String _plus_7 = _plus_6 + "'";
                    CharSequence _wrapIfMultiple_7 = this.wrapIfMultiple(_plus_7, property.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_7, "              ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                CharSequence _calculateRequired = Utils.calculateRequired(fb.getFunctionblock().getStatus().getProperties());
                _builder.append((Object)_calculateRequired, "          ");
                _builder.newLineIfNotEmpty();
            }
            if (fb.getFunctionblock().getConfiguration() != null && !fb.getFunctionblock().getConfiguration().getProperties().isEmpty()) {
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("configuration:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("properties:");
                _builder.newLine();
                EList<Property> _properties_4 = fb.getFunctionblock().getConfiguration().getProperties();
                for (Property property : _properties_4) {
                    boolean _tripleNotEquals_8;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    String _name_57 = property.getName();
                    _builder.append(_name_57, "            ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    String _description_6 = property.getDescription();
                    boolean bl5 = _tripleNotEquals_8 = _description_6 != null;
                    if (_tripleNotEquals_8) {
                        _builder.append("description: ");
                        String _description_7 = property.getDescription();
                        _builder.append(_description_7, "              ");
                    }
                    _builder.newLineIfNotEmpty();
                    PropertyType _type_8 = property.getType();
                    if (_type_8 instanceof PrimitivePropertyType) {
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        PropertyType _type_9 = property.getType();
                        CharSequence _wrapIfMultiple_8 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_9).getType()).toString(), property.isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_8, "              ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_3 = property.getConstraintRule();
                        boolean _tripleNotEquals_9 = _constraintRule_3 != null;
                        if (!_tripleNotEquals_9) continue;
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("    ");
                        _builder.append("  ");
                        CharSequence _handleConstraints_3 = this.handleConstraints(property.getConstraintRule());
                        _builder.append((Object)_handleConstraints_3, "              ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_10 = property.getType();
                    if (!(_type_10 instanceof ObjectPropertyType)) continue;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    PropertyType _type_11 = property.getType();
                    String _name_58 = ((ObjectPropertyType)_type_11).getType().getName();
                    String _plus_8 = "$ref: '#/components/schemas/" + _name_58;
                    String _plus_9 = _plus_8 + "'";
                    CharSequence _wrapIfMultiple_9 = this.wrapIfMultiple(_plus_9, property.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_9, "              ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                CharSequence _calculateRequired_1 = Utils.calculateRequired(fb.getFunctionblock().getConfiguration().getProperties());
                _builder.append((Object)_calculateRequired_1, "          ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            String _name_59 = fb.getName();
            _builder.append(_name_59, "    ");
            _builder.append("Feature:");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("type: object");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("properties:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("definition:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("      ");
            _builder.append("$ref: '#/components/schemas/FeatureDefinition'");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("      ");
            _builder.append("description: The Definition of this ");
            String _name_60 = fb.getName();
            _builder.append(_name_60, "          ");
            _builder.append(" Feature");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("properties:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("      ");
            _builder.append("$ref: '#/components/schemas/");
            String string = fb.getName();
            _builder.append(string, "          ");
            _builder.append("Properties'");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("      ");
            _builder.append("description: The Properties of this ");
            String _name_62 = fb.getName();
            _builder.append(_name_62, "          ");
            _builder.append(" feature");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        String _name_63 = infomodel.getName();
        _builder.append(_name_63, "    ");
        _builder.append("Features:");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("type: object");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("List all Features of the ");
        String string = infomodel.getName();
        _builder.append(string, "        ");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("properties:");
        _builder.newLine();
        EList<FunctionblockProperty> _properties_5 = infomodel.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_5) {
            boolean _tripleNotEquals_10;
            _builder.append("        ");
            String _name_65 = fbProperty_1.getName();
            _builder.append(_name_65, "        ");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("  ");
            String _description_8 = fbProperty_1.getDescription();
            boolean bl = _tripleNotEquals_10 = _description_8 != null;
            if (_tripleNotEquals_10) {
                _builder.append("description: ");
                String string2 = fbProperty_1.getDescription();
                _builder.append(string2, "          ");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("  ");
            _builder.append("allOf:");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("- $ref: '#/components/schemas/");
            String _name_66 = fbProperty_1.getType().getName();
            _builder.append(_name_66, "            ");
            _builder.append("Feature'");
            _builder.newLineIfNotEmpty();
        }
        Set<Entity> _referencedEntities = Utils.getReferencedEntities(infomodel);
        for (Entity entity : _referencedEntities) {
            _builder.append("    ");
            String _name_67 = entity.getName();
            _builder.append(_name_67, "    ");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("type: object");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("properties:");
            _builder.newLine();
            EList<Property> _properties_6 = entity.getProperties();
            for (Property property : _properties_6) {
                boolean _tripleNotEquals_11;
                _builder.append("    ");
                _builder.append("    ");
                String _name_68 = property.getName();
                _builder.append(_name_68, "        ");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                String _description_10 = property.getDescription();
                boolean bl = _tripleNotEquals_11 = _description_10 != null;
                if (_tripleNotEquals_11) {
                    _builder.append("description: ");
                    String _description_11 = property.getDescription();
                    _builder.append(_description_11, "          ");
                }
                _builder.newLineIfNotEmpty();
                PropertyType _type_12 = property.getType();
                if (_type_12 instanceof PrimitivePropertyType) {
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    PropertyType _type_13 = property.getType();
                    CharSequence _wrapIfMultiple_10 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_13).getType()).toString(), property.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_10, "          ");
                    _builder.newLineIfNotEmpty();
                    ConstraintRule _constraintRule_4 = property.getConstraintRule();
                    boolean _tripleNotEquals_12 = _constraintRule_4 != null;
                    if (!_tripleNotEquals_12) continue;
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("  ");
                    CharSequence _handleConstraints_4 = this.handleConstraints(property.getConstraintRule());
                    _builder.append((Object)_handleConstraints_4, "          ");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                PropertyType _type_14 = property.getType();
                if (!(_type_14 instanceof ObjectPropertyType)) continue;
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("  ");
                PropertyType _type_15 = property.getType();
                String _name_69 = ((ObjectPropertyType)_type_15).getType().getName();
                String _plus_10 = "$ref: '#/components/schemas/" + (String)_name_69;
                String _plus_11 = _plus_10 + "'";
                CharSequence _wrapIfMultiple_11 = this.wrapIfMultiple(_plus_11, property.isMultiplicity());
                _builder.append((Object)_wrapIfMultiple_11, "          ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            _builder.append("  ");
            CharSequence _calculateRequired_2 = Utils.calculateRequired(entity.getProperties());
            _builder.append((Object)_calculateRequired_2, "      ");
            _builder.newLineIfNotEmpty();
        }
        EList<Enum> _referencedEnums = Utils.getReferencedEnums(infomodel);
        for (Enum enumeration : _referencedEnums) {
            _builder.append("    ");
            String _name_70 = enumeration.getName();
            _builder.append(_name_70, "    ");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("type: string");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("enum: [");
            EList<EnumLiteral> _enums = enumeration.getEnums();
            boolean _hasElements = false;
            Iterator iterator = _enums.iterator();
            while (iterator.hasNext()) {
                EnumLiteral literal = (EnumLiteral)iterator.next();
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate(",", "      ");
                }
                String _name_71 = literal.getName();
                _builder.append(_name_71, "      ");
            }
            _builder.append("]");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("  ");
        _builder.newLine();
        _builder.append("  ");
        boolean _hasRequestBodiesContent = this.hasRequestBodiesContent(infomodel);
        if (_hasRequestBodiesContent) {
            _builder.append("requestBodies:");
        }
        _builder.newLineIfNotEmpty();
        EList<FunctionblockModel> _referencedFunctionBlocks_1 = Utils.getReferencedFunctionBlocks(infomodel);
        for (FunctionblockModel fb_1 : _referencedFunctionBlocks_1) {
            boolean _tripleNotEquals_15;
            EList<Event> _events_1 = fb_1.getFunctionblock().getEvents();
            for (Event event_1 : _events_1) {
                boolean bl = event_1.getProperties().isEmpty();
                boolean _not_3 = !bl;
                if (!_not_3) continue;
                _builder.append("    ");
                String _name_72 = fb_1.getName();
                _builder.append(_name_72, "    ");
                String _firstUpper_5 = StringExtensions.toFirstUpper(event_1.getName());
                _builder.append(_firstUpper_5, "    ");
                _builder.append("EventPayload:");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("      ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("properties:");
                _builder.newLine();
                EList<Property> _properties_7 = event_1.getProperties();
                for (Property eventProperty : _properties_7) {
                    boolean _tripleNotEquals_13;
                    _builder.append("    ");
                    _builder.append("          ");
                    String _name_73 = eventProperty.getName();
                    _builder.append(_name_73, "              ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("          ");
                    _builder.append("  ");
                    String _description_12 = eventProperty.getDescription();
                    boolean bl6 = _tripleNotEquals_13 = _description_12 != null;
                    if (_tripleNotEquals_13) {
                        _builder.append("description: ");
                        String _description_13 = eventProperty.getDescription();
                        _builder.append(_description_13, "                ");
                    }
                    _builder.newLineIfNotEmpty();
                    PropertyType _type_16 = eventProperty.getType();
                    if (_type_16 instanceof PrimitivePropertyType) {
                        _builder.append("    ");
                        _builder.append("          ");
                        _builder.append("  ");
                        PropertyType _type_17 = eventProperty.getType();
                        CharSequence _wrapIfMultiple_12 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_17).getType()).toString(), eventProperty.isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_12, "                ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_5 = eventProperty.getConstraintRule();
                        boolean _tripleNotEquals_14 = _constraintRule_5 != null;
                        if (!_tripleNotEquals_14) continue;
                        _builder.append("    ");
                        _builder.append("          ");
                        _builder.append("  ");
                        CharSequence _handleConstraints_5 = this.handleConstraints(eventProperty.getConstraintRule());
                        _builder.append((Object)_handleConstraints_5, "                ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_18 = eventProperty.getType();
                    if (!(_type_18 instanceof ObjectPropertyType)) continue;
                    _builder.append("    ");
                    _builder.append("          ");
                    _builder.append("  ");
                    PropertyType _type_19 = eventProperty.getType();
                    String _name_74 = ((ObjectPropertyType)_type_19).getType().getName();
                    String _plus_12 = "$ref: '#/components/schemas/" + _name_74;
                    String _plus_13 = _plus_12 + "'";
                    CharSequence _wrapIfMultiple_13 = this.wrapIfMultiple(_plus_13, eventProperty.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_13, "                ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("        ");
                CharSequence _calculateRequired_3 = Utils.calculateRequired(event_1.getProperties());
                _builder.append((Object)_calculateRequired_3, "            ");
                _builder.newLineIfNotEmpty();
            }
            Configuration _configuration_1 = fb_1.getFunctionblock().getConfiguration();
            boolean bl = _tripleNotEquals_15 = _configuration_1 != null;
            if (_tripleNotEquals_15) {
                EList<Property> _properties_8 = fb_1.getFunctionblock().getConfiguration().getProperties();
                for (Property configurationProperty_2 : _properties_8) {
                    _builder.append("    ");
                    String _name_75 = fb_1.getName();
                    _builder.append(_name_75, "    ");
                    String _firstUpper_6 = StringExtensions.toFirstUpper(configurationProperty_2.getName());
                    _builder.append(_firstUpper_6, "    ");
                    _builder.append("ConfigurationValue:");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("  ");
                    _builder.append("content:");
                    _builder.newLine();
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("application/json:");
                    _builder.newLine();
                    _builder.append("    ");
                    _builder.append("      ");
                    _builder.append("schema:");
                    _builder.newLine();
                    PropertyType _type_20 = configurationProperty_2.getType();
                    if (_type_20 instanceof PrimitivePropertyType) {
                        _builder.append("    ");
                        _builder.append("        ");
                        PropertyType _type_21 = configurationProperty_2.getType();
                        CharSequence _wrapIfMultiple_14 = this.wrapIfMultiple(this.getPrimitive(((PrimitivePropertyType)_type_21).getType()).toString(), configurationProperty_2.isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_14, "            ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_6 = configurationProperty_2.getConstraintRule();
                        boolean _tripleNotEquals_16 = _constraintRule_6 != null;
                        if (!_tripleNotEquals_16) continue;
                        _builder.append("    ");
                        _builder.append("        ");
                        CharSequence _handleConstraints_6 = this.handleConstraints(configurationProperty_2.getConstraintRule());
                        _builder.append((Object)_handleConstraints_6, "            ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    PropertyType _type_22 = configurationProperty_2.getType();
                    if (!(_type_22 instanceof ObjectPropertyType)) continue;
                    _builder.append("    ");
                    _builder.append("        ");
                    PropertyType _type_23 = configurationProperty_2.getType();
                    String _name_76 = ((ObjectPropertyType)_type_23).getType().getName();
                    String _plus_14 = "$ref: '#/components/schemas/" + _name_76;
                    String _plus_15 = _plus_14 + "'";
                    CharSequence _wrapIfMultiple_15 = this.wrapIfMultiple(_plus_15, configurationProperty_2.isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_15, "            ");
                    _builder.newLineIfNotEmpty();
                }
            }
            EList<Operation> _operations_2 = fb_1.getFunctionblock().getOperations();
            for (Operation operation_2 : _operations_2) {
                boolean bl7 = operation_2.getParams().isEmpty();
                boolean _not_4 = !bl7;
                if (!_not_4) continue;
                _builder.append("    ");
                String _name_77 = fb_1.getName();
                _builder.append(_name_77, "    ");
                String _firstUpper_7 = StringExtensions.toFirstUpper(operation_2.getName());
                _builder.append(_firstUpper_7, "    ");
                _builder.append("Payload:");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("content:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("application/json:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("      ");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("        ");
                _builder.append("properties:");
                _builder.newLine();
                EList<Param> _params_1 = operation_2.getParams();
                for (Param param_1 : _params_1) {
                    boolean _tripleNotEquals_17;
                    _builder.append("    ");
                    _builder.append("          ");
                    String _name_78 = param_1.getName();
                    _builder.append(_name_78, "              ");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("          ");
                    _builder.append("  ");
                    String _description_14 = param_1.getDescription();
                    boolean bl8 = _tripleNotEquals_17 = _description_14 != null;
                    if (_tripleNotEquals_17) {
                        _builder.append("description: ");
                        String _description_15 = param_1.getDescription();
                        _builder.append(_description_15, "                ");
                    }
                    _builder.newLineIfNotEmpty();
                    if (param_1 instanceof PrimitiveParam) {
                        _builder.append("    ");
                        _builder.append("          ");
                        _builder.append("  ");
                        CharSequence _wrapIfMultiple_16 = this.wrapIfMultiple(this.getPrimitive(((PrimitiveParam)param_1).getType()).toString(), ((PrimitiveParam)param_1).isMultiplicity());
                        _builder.append((Object)_wrapIfMultiple_16, "                ");
                        _builder.newLineIfNotEmpty();
                        ConstraintRule _constraintRule_7 = ((PrimitiveParam)param_1).getConstraintRule();
                        boolean _tripleNotEquals_18 = _constraintRule_7 != null;
                        if (!_tripleNotEquals_18) continue;
                        _builder.append("    ");
                        _builder.append("          ");
                        _builder.append("  ");
                        CharSequence _handleConstraints_7 = this.handleConstraints(((PrimitiveParam)param_1).getConstraintRule());
                        _builder.append((Object)_handleConstraints_7, "                ");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    if (!(param_1 instanceof RefParam)) continue;
                    _builder.append("    ");
                    _builder.append("          ");
                    _builder.append("  ");
                    String _name_79 = ((RefParam)param_1).getType().getName();
                    String _plus_16 = "$ref: '#/components/schemas/" + _name_79;
                    String _plus_17 = _plus_16 + "'";
                    CharSequence _wrapIfMultiple_17 = this.wrapIfMultiple(_plus_17, ((RefParam)param_1).isMultiplicity());
                    _builder.append((Object)_wrapIfMultiple_17, "                ");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.append("  ");
        _builder.append("responses:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("entityTooLarge:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The created or modified entity is larger than the accepted limit of 100 kB.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("messageTooLarge:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The size of the send message is larger than the accepted limit of 250 kB.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("notModified:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The (sub-)resource has not been modified. This happens when you specified a If-None-Match header which");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("matches the current ETag of the (sub-)resource.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("headers:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("ETag:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The (current server-side) ETag for this (sub-)resource. For top-level resources it is in the format");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("\"rev:[revision]\", for sub-resources it has the format \"hash:[calculated-hash]\".");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("preconditionFailed:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("A precondition for reading or writing the (sub-)resource failed. This will happen for write requests, when you");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("specified an If-Match or If-None-Match header which fails the precondition check against the current ETag of");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("the (sub-)resource. For read requests, this error may only happen for a failing If-Match header. In case of a");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("failing If-None-Match header for a read request, status 304 will be returned instead.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("headers:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("ETag:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("The (current server-side) ETag for this (sub-)resource. For top-level resources it is in the format");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("\"rev:[revision]\", for sub-resources it has the format \"hash:[calculated-hash]\".");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("content:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("application/json:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("$ref: '#/components/schemas/AdvancedError'");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("parameters:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("ifMatchHeaderParam:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: If-Match");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: header");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description:  |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The `If-Match` header, which has to conform to RFC-7232 (Conditional Requests). Common usages are:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* optimistic locking by specifying the `ETag` from a previous GET response, e.g. `If-Match: \"rev:4711\"`");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* retrieving or modifying a resource only if it already exists, e.g. `If-Match: *`");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: false");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("ifNoneMatchHeaderParam:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: If-None-Match");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: header");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description:  |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The `If-None-Match` header, which has to conform to RFC-7232 (Conditional Requests). A common usage scenario is to");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("modify a resource only if it does not yet exist, thus to create it, by specifying `If-None-Match: *`.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: false");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("messageTimeoutParam:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: timeout");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: query");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Contains an optional timeout (in seconds) of how long to wait for the message response and therefore block the");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("HTTP request. Default value (if omitted): 10 seconds. Maximum value: 60 seconds. A value of 0 seconds applies");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("fire and forget semantics for the message.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: false");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: integer");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("thingIdPathParam:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: thingId");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: path");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The ID of a thing needs to follow the namespaced entity ID notation (see [Ditto documentation on namespaced entity IDs](https://www.eclipse.org/ditto/basic-namespaces-and-names.html#namespaced-id)).");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The namespace needs to be registered for your solution.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: true");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("propertyPathPathParam:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: propertyPath");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: path");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: The path to the Property");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: true");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("thingFieldsQueryParam:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: fields");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: query");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Contains a comma-separated list of fields to be included in the returned");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("JSON. Attributes can be selected in the same manner.");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Selectable fields");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `thingId`");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `policyId`");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `attributes`");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("           ");
        _builder.append("Supports selecting arbitrary sub-fields by using a comma-separated list:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("* several attribute paths can be passed as a comma-separated list of JSON pointers (RFC-6901)");
        _builder.newLine();
        _builder.append("            ");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("For example:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("* `?fields=attributes/model` would select only `model` attribute value (if present)");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("* `?fields=attributes/model,attributes/location` would select only `model` and");
        _builder.newLine();
        _builder.append("                   ");
        _builder.append("`location` attribute values (if present)");
        _builder.newLine();
        _builder.append("                   ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Supports selecting arbitrary sub-fields of objects by wrapping sub-fields inside parentheses `( )`:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("* a comma-separated list of sub-fields (a sub-field is a JSON pointer (RFC-6901)");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("separated with `/`) to select");
        _builder.newLine();
        _builder.append("              ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("* sub-selectors can be used to request only specific sub-fields by placing expressions");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("in parentheses `( )` after a selected subfield");
        _builder.newLine();
        _builder.append("              ");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("For example:");
        _builder.newLine();
        _builder.append("               ");
        _builder.append("* `?fields=attributes(model,location)` would select only `model`");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("and `location` attribute values (if present)");
        _builder.newLine();
        _builder.append("               ");
        _builder.append("* `?fields=attributes(coffeemaker/serialno)` would select the `serialno` value");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("inside the `coffeemaker` object");
        _builder.newLine();
        _builder.append("               ");
        _builder.append("* `?fields=attributes/address/postal(city,street)` would select the `city` and");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("`street` values inside the `postal` object inside the `address` object");
        _builder.newLine();
        _builder.append("                  ");
        _builder.newLine();
        _builder.append("                  ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `features`");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Supports selecting arbitrary fields in features similar to `attributes` (see also Features documentation for more details)");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `_namespace`");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Specifically selects the namespace also contained in the `thingId`");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `_revision`");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Specifically selects the revision of the Thing. The revision is a counter, which is incremented on each modification of a Thing.");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `_modified`");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Specifically selects the modified timestamp of the Thing in ISO-8601 UTC format. The timestamp is set on each modification of a Thing.");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `_policy`");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Specifically selects the content of the policy associated to the thing. (By default, only the policyId is returned.)");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Examples");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `?fields=thingId,attributes,features`");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `?fields=attributes(model,manufacturer),features`");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: false");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("searchFilter:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: filter");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: query");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("      ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Filter predicates:");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```eq({property},{value})```  (i.e. equal to the given value)");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```ne({property},{value})```  (i.e. not equal to the given value)");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```gt({property},{value})```  (i.e. greater than the given value)");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```ge({property},{value})```  (i.e. equal to the given value or greater than it)");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```lt({property},{value})```  (i.e. lower than the given value or equal to it)");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```le({property},{value})```  (i.e. lower than the given value)");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```in({property},{value},{value},...)```  (i.e. contains at least one of the values listed)");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```like({property},{value})```  (i.e. contains values similar to the expressions listed)");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```exists({property})```  (i.e. all things in which the given path exists)");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Note: When using filter operations, only things with the specified properties are returned.");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("For example, the filter `ne(attributes/owner, \"SID123\")` will only return things that do have");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("the `owner` attribute.");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Logical operations:");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```and({query},{query},...)```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```or({query},{query},...)```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```not({query})```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Examples:");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```eq(attributes/location,\"kitchen\")```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```ge(thingId,\"myThing1\")```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```exists(features/featureId)```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```and(eq(attributes/location,\"kitchen\"),eq(attributes/color,\"red\"))```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```or(eq(attributes/location,\"kitchen\"),eq(attributes/location,\"living-room\"))```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```like(attributes/key1,\"known-chars-at-start*\")```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```like(attributes/key1,\"*known-chars-at-end\")```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```like(attributes/key1,\"*known-chars-in-between*\")```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* ```like(attributes/key1,\"just-som?-char?-unkn?wn\")```");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("The `like` filters with the wildcard `*` at the beginning can slow down your search request.");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: false");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("namespacesFilter:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: namespaces");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: query");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("A comma-separated list of namespaces. This list is used to limit the query to things in the given namespaces");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("only. If this parameter is omitted, all registered namespaces of your solution will be queried. The solution is");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("determined by the API token sent with the request.");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Examples:");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `?namespaces=com.example.namespace`");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `?namespaces=com.example.namespace1,com.example.namespace2`");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: false");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("propertiesFieldsQueryParam:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: fields");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: query");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Contains a comma-separated list of fields from the properties to be");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("included in the returned JSON.");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Selectable fields");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Supports selecting arbitrary sub-fields as defined in the properties by");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("using a comma-separated list:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* several properties paths can be passed as a comma-separated list of JSON pointers (RFC-6901)");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("For example:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("* `?fields=temperature` would select only `temperature` property value (if present)");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("* `?fields=temperature,humidity` would select only `temperature` and `humidity` property values (if present)");
        _builder.newLine();
        _builder.append("              ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Supports selecting arbitrary sub-fields of objects by wrapping sub-fields");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("inside parentheses `( )`:");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* a comma-separated list of sub-fields (a sub-field is a JSON pointer (RFC-6901) separated with `/`) to select");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* sub-selectors can be used to request only specific sub-fields by placing expressions in parentheses `( )` after a selected subfield");
        _builder.newLine();
        _builder.append("          ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("For example:");
        _builder.newLine();
        _builder.append("             ");
        _builder.append("* `?fields=location(longitude,latitude)` would select the `longitude` and `latitude` value inside the `location` property");
        _builder.newLine();
        _builder.append("             ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Examples");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `?fields=temperature,humidity,location(longitude,latitude)`");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `?fields=configuration,status(powerConsumption/watts)`");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: false");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("featuresFieldsQueryParam:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: fields");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: query");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Contains a comma-separated list of fields from one or more Features to be");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("included in the returned JSON.");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Selectable fields");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `{featureId}` The ID of the Feature to select properties in");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("* `properties`");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("Supports selecting arbitrary sub-fields by using a comma-separated list:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("* several properties paths can be passed as a comma-separated list of JSON pointers (RFC-6901)");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("For example:");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("* `?fields={featureId}/properties/color` would select only `color` property value (if present) of the Feature identified with `{featureId}`");
        _builder.newLine();
        _builder.append("                  ");
        _builder.append("* `?fields={featureId}/properties/color,properties/brightness` would select only `color` and `brightness` property values (if present) of the Feature identified with `{featureId}`");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("Supports selecting arbitrary sub-fields of objects by wrapping sub-fields inside parentheses `( )`:");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("* a comma-separated list of sub-fields (a sub-field is a JSON pointer (RFC-6901) separated with `/`) to select");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("* sub-selectors can be used to request only specific sub-fields by placing expressions in parentheses `( )` after a selected subfield");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("For example:");
        _builder.newLine();
        _builder.append("                 ");
        _builder.append("* `?fields={featureId}/properties(color,brightness)` would select only `color` and `brightness` property values (if present) of the Feature identified with `{featureId}`");
        _builder.newLine();
        _builder.append("                 ");
        _builder.append("* `?fields={featureId}/properties(location/longitude)` would select the `longitude` value inside the `location` object of the Feature identified with `{featureId}`");
        _builder.newLine();
        _builder.append("                 ");
        _builder.newLine();
        _builder.append("                 ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Examples");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `?fields=EnvironmentScanner/properties(temperature,humidity)`");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `?fields=EnvironmentScanner/properties(temperature,humidity),Vehicle/properties/configuration`");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: false");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("featureFieldsQueryParam:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("name: fields");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("in: query");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("Contains a comma-separated list of fields from the selected Feature to be");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("included in the returned JSON.");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Selectable fields");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `properties`");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Supports selecting arbitrary sub-fields by using a comma-separated list:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("* several properties paths can be passed as a comma-separated list of JSON pointers (RFC-6901)");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("For example:");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("* `?fields=properties/color` would select only `color` property value (if present)");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("* `?fields=properties/color,properties/brightness` would select only `color` and `brightness` property values (if present)");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("Supports selecting arbitrary sub-fields of objects by wrapping sub-fields inside parentheses `( )`:");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("* a comma-separated list of sub-fields (a sub-field is a JSON pointer (RFC-6901) separated with `/`) to select");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("* sub-selectors can be used to request only specific sub-fields by placing expressions in parentheses `( )` after a selected subfield");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("For example:");
        _builder.newLine();
        _builder.append("               ");
        _builder.append("* `?fields=properties(color,brightness)` would select only `color` and `brightness` property values (if present)");
        _builder.newLine();
        _builder.append("               ");
        _builder.append("* `?fields=properties(location/longitude)` would select the `longitude` value inside the `location` object");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("#### Examples");
        _builder.newLine();
        _builder.append("  ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("* `?fields=properties(color,brightness)`");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("required: false");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("schema:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("type: string");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("securitySchemes:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("bearerAuth:");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("type: http");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("scheme: bearer");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("bearerFormat: JWT");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("description: |-");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("A JSON Web Token issued by a supported OAuth 2.0 Identity Provider.");
        _builder.newLine();
        return _builder.toString();
    }

    public boolean hasRequestBodiesContent(InformationModel infomodel) {
        boolean flag = false;
        EList<FunctionblockModel> _referencedFunctionBlocks = Utils.getReferencedFunctionBlocks(infomodel);
        for (FunctionblockModel fb : _referencedFunctionBlocks) {
            EList<Event> _events = fb.getFunctionblock().getEvents();
            for (Event event : _events) {
                boolean _isEmpty = event.getProperties().isEmpty();
                boolean _not = !_isEmpty;
                if (!_not) continue;
                flag = true;
            }
            if (fb.getFunctionblock().getConfiguration() != null && !fb.getFunctionblock().getConfiguration().getProperties().isEmpty()) {
                flag = true;
            }
            EList<Operation> _operations = fb.getFunctionblock().getOperations();
            for (Operation operation : _operations) {
                boolean _isEmpty_1 = operation.getParams().isEmpty();
                boolean _not_1 = !_isEmpty_1;
                if (!_not_1) continue;
                flag = true;
            }
        }
        return flag;
    }

    public CharSequence handleConstraints(ConstraintRule rule) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Constraint> _constraints = rule.getConstraints();
        for (Constraint constraint : _constraints) {
            String _constraint = this.getConstraint(constraint.getType());
            _builder.append(_constraint);
            String _constraintValues = constraint.getConstraintValues();
            _builder.append(_constraintValues);
            _builder.newLineIfNotEmpty();
            ConstraintIntervalType _type = constraint.getType();
            boolean _equals = Objects.equal(_type, ConstraintIntervalType.MAX);
            if (!_equals) continue;
            _builder.append("example: ");
            String _constraintValues_1 = constraint.getConstraintValues();
            _builder.append(_constraintValues_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence wrapIfMultiple(String type, boolean isArray) {
        StringConcatenation _builder = new StringConcatenation();
        if (isArray) {
            _builder.append("type: array");
            _builder.newLine();
            _builder.append("items:");
            _builder.newLine();
            _builder.append("  ");
            _builder.append(type, "  ");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(type);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence getPrimitive(PrimitiveType primitiveType) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _equals = Objects.equal(primitiveType, PrimitiveType.BASE64_BINARY);
        if (_equals) {
            _builder.append("type: string");
            _builder.newLine();
        } else {
            boolean _equals_1 = Objects.equal(primitiveType, PrimitiveType.BOOLEAN);
            if (_equals_1) {
                _builder.append("type: boolean");
                _builder.newLine();
            } else {
                boolean _equals_2 = Objects.equal(primitiveType, PrimitiveType.BYTE);
                if (_equals_2) {
                    _builder.append("type: string");
                    _builder.newLine();
                } else {
                    boolean _equals_3 = Objects.equal(primitiveType, PrimitiveType.DATETIME);
                    if (_equals_3) {
                        _builder.append("type: string");
                        _builder.newLine();
                    } else {
                        boolean _equals_4 = Objects.equal(primitiveType, PrimitiveType.DOUBLE);
                        if (_equals_4) {
                            _builder.append("type: number");
                            _builder.newLine();
                        } else {
                            boolean _equals_5 = Objects.equal(primitiveType, PrimitiveType.FLOAT);
                            if (_equals_5) {
                                _builder.append("type: number");
                                _builder.newLine();
                            } else {
                                boolean _equals_6 = Objects.equal(primitiveType, PrimitiveType.INT);
                                if (_equals_6) {
                                    _builder.append("type: integer");
                                    _builder.newLine();
                                } else {
                                    boolean _equals_7 = Objects.equal(primitiveType, PrimitiveType.LONG);
                                    if (_equals_7) {
                                        _builder.append("type: number");
                                        _builder.newLine();
                                    } else {
                                        boolean _equals_8 = Objects.equal(primitiveType, PrimitiveType.SHORT);
                                        if (_equals_8) {
                                            _builder.append("type: integer");
                                            _builder.newLine();
                                        } else {
                                            _builder.append("type: string");
                                            _builder.newLine();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return _builder;
    }

    public String getConstraint(ConstraintIntervalType type) {
        boolean _equals = Objects.equal(type, ConstraintIntervalType.STRLEN);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("maxLength: ");
            return _builder.toString();
        }
        boolean _equals_1 = Objects.equal(type, ConstraintIntervalType.REGEX);
        if (_equals_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("pattern: ");
            return _builder_1.toString();
        }
        boolean _equals_2 = Objects.equal(type, ConstraintIntervalType.MIN);
        if (_equals_2) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("minimum: ");
            return _builder_2.toString();
        }
        boolean _equals_3 = Objects.equal(type, ConstraintIntervalType.MAX);
        if (_equals_3) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("maximum: ");
            return _builder_3.toString();
        }
        boolean _equals_4 = Objects.equal(type, ConstraintIntervalType.SCALING);
        if (_equals_4) {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("multipleOf: ");
            return _builder_4.toString();
        }
        boolean _equals_5 = Objects.equal(type, ConstraintIntervalType.DEFAULT);
        if (_equals_5) {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("default: ");
            return _builder_5.toString();
        }
        return null;
    }
}

