/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.openapi;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class Utils {
    public static EList<FunctionblockModel> getReferencedFunctionBlocks(InformationModel infomodel) {
        BasicEList<FunctionblockModel> fbs = new BasicEList<FunctionblockModel>();
        EList<FunctionblockProperty> _properties = infomodel.getProperties();
        for (FunctionblockProperty property : _properties) {
            Functions.Function1<FunctionblockModel, Boolean> _function = it -> EcoreUtil.equals(it, property.getType());
            boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.filter(fbs, _function));
            if (!_isEmpty) continue;
            fbs.add(property.getType());
        }
        return fbs;
    }

    public static Set<Entity> getReferencedEntities(InformationModel infomodel) {
        HashSet<Entity> entities = new HashSet<Entity>();
        EList<FunctionblockProperty> _properties = infomodel.getProperties();
        for (FunctionblockProperty property : _properties) {
            EList<Entity> _referencedEntities = org.eclipse.vorto.plugin.utils.Utils.getReferencedEntities(property.getType().getFunctionblock());
            for (Entity entity : _referencedEntities) {
                Functions.Function1<Entity, Boolean> _function = it -> Utils.createModelId(it).equals(Utils.createModelId(entity));
                boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.filter(entities, _function));
                if (!_isEmpty) continue;
                entities.add(entity);
            }
        }
        return entities;
    }

    public static ModelId createModelId(Model model) {
        String _name = model.getName();
        String _namespace = model.getNamespace();
        String _version = model.getVersion();
        return new ModelId(_name, _namespace, _version);
    }

    public static EList<Enum> getReferencedEnums(InformationModel infomodel) {
        BasicEList<Enum> enums = new BasicEList<Enum>();
        EList<FunctionblockProperty> _properties = infomodel.getProperties();
        for (FunctionblockProperty property : _properties) {
            EList<Enum> _referencedEnums = org.eclipse.vorto.plugin.utils.Utils.getReferencedEnums(property.getType().getFunctionblock());
            for (Enum enumeration : _referencedEnums) {
                Functions.Function1<Enum, Boolean> _function = it -> EcoreUtil.equals(it, enumeration);
                boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.filter(enums, _function));
                if (!_isEmpty) continue;
                enums.add(enumeration);
            }
        }
        return enums;
    }

    public static CharSequence calculateRequired(List<Property> properties) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1<Property, Boolean> _function = it -> it.getPresence() != null && it.getPresence().isMandatory();
        boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.filter(properties, _function));
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("required: [");
            Functions.Function1<Property, Boolean> _function_1 = it -> it.getPresence() != null && it.getPresence().isMandatory();
            Iterable<Property> _filter = IterableExtensions.filter(properties, _function_1);
            boolean _hasElements = false;
            for (Property property : _filter) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate(",", "");
                }
                String _name = property.getName();
                _builder.append(_name);
            }
            _builder.append("]");
        }
        return _builder;
    }
}

