/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java.service.hono;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.hono.java.Utils;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.IFileTemplate;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class HonoDataService
implements IFileTemplate<InformationModel> {
    @Override
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("HonoDataService.java");
        return _builder.toString();
    }

    @Override
    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _javaPackageBasePath = Utils.getJavaPackageBasePath(context);
        _builder.append(_javaPackageBasePath);
        _builder.append("/service/hono");
        return _builder.toString();
    }

    @Override
    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _javaPackage = Utils.getJavaPackage(element);
        _builder.append(_javaPackage);
        _builder.append(".service.hono;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.Objects;");
        _builder.newLine();
        _builder.newLine();
        EList<ModelReference> _references = element.getReferences();
        for (ModelReference reference : _references) {
            ModelId modelId = ModelIdFactory.newInstance(ModelType.Functionblock, reference);
            _builder.newLineIfNotEmpty();
            _builder.append("import ");
            String _javaPackage_1 = Utils.getJavaPackage(element);
            _builder.append(_javaPackage_1);
            _builder.append(".model.");
            String _name = modelId.getName();
            _builder.append(_name);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("import ");
        String _javaPackage_2 = Utils.getJavaPackage(element);
        _builder.append(_javaPackage_2);
        _builder.append(".service.IDataService;");
        _builder.newLineIfNotEmpty();
        _builder.append("import com.google.gson.Gson;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Data Service Implementation that sends device data to Eclipse Hono MQTT Endpoint");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public class HonoDataService implements IDataService {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String mqttHostUrl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String honoTenant;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String dittoTopic;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String authId;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String deviceId;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String password;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Map<String, HonoMqttClient> deviceClients = new HashMap<String, HonoMqttClient>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Gson gson = new Gson();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public HonoDataService(String mqttHostUrl, String honoTenant, String dittoTopic, String deviceId, String authId, String password) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.mqttHostUrl = Objects.requireNonNull(mqttHostUrl);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.honoTenant = Objects.requireNonNull(honoTenant);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.dittoTopic = Objects.requireNonNull(dittoTopic);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.deviceId = Objects.requireNonNull(deviceId);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.authId = Objects.requireNonNull(authId);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.password = Objects.requireNonNull(password);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        EList<FunctionblockProperty> _properties = element.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append("\t");
            _builder.append("public void publish");
            String _firstUpper = StringExtensions.toFirstUpper(fbProperty.getName());
            _builder.append(_firstUpper, "\t");
            _builder.append("(String resourceId, ");
            String _name_1 = fbProperty.getType().getName();
            _builder.append(_name_1, "\t");
            _builder.append(" ");
            String _name_2 = fbProperty.getName();
            _builder.append(_name_2, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("getConnectedHonoClient(resourceId).send(\"telemetry/\" + honoTenant + \"/\" + resourceId, gson.toJson(wrap(");
            String _name_3 = fbProperty.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append(".getStatusProperties(),");
            String _name_4 = fbProperty.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append(".getConfigurationProperties(),\"");
            String _name_5 = fbProperty.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append("\")));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private <T> Map<String, Object> wrap(T StatusProperties, T ConfigurationProperties, String featureName) {\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Map<String, Object> headers = new HashMap<String, Object>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("headers.put(\"response-required\", Boolean.FALSE);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Map<String, Object> wrapper = new HashMap<String, Object>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("wrapper.put(\"topic\", dittoTopic + \"/things/twin/commands/modify\");");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("wrapper.put(\"path\", \"/features/\"+featureName+\"/properties\");");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("wrapper.put(\"value\", createValue(StatusProperties,ConfigurationProperties));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("wrapper.put(\"headers\", headers);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return wrapper; ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private <T> Map<String, Object> createValue(T StatusProperties, T ConfigurationProperties) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Map<String, Object> properties = new HashMap<String, Object>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("properties.put(\"status\",StatusProperties);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("properties.put(\"configuration\",ConfigurationProperties);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return properties;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private HonoMqttClient getConnectedHonoClient(String resourceId) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("HonoMqttClient client = deviceClients.get(resourceId);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (client == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("client = new HonoMqttClient(mqttHostUrl, resourceId, authId, password);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("deviceClients.put(resourceId, client);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (!client.isConnected()) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("client.connect();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return client;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }
}

