/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java.model;

import org.eclipse.vorto.codegen.hono.java.Utils;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.plugin.generator.utils.AbstractTemplateGeneratorTask;
import org.eclipse.vorto.plugin.generator.utils.ITemplate;
import org.eclipse.vorto.plugin.generator.utils.javatemplates.JavaClassFieldGetterTemplate;
import org.eclipse.vorto.plugin.generator.utils.javatemplates.JavaClassFieldSetterTemplate;
import org.eclipse.vorto.plugin.generator.utils.javatemplates.JavaClassFieldTemplate;
import org.eclipse.vorto.plugin.generator.utils.javatemplates.JavaEntityTemplate;

public class JavaClassGeneratorTask
extends AbstractTemplateGeneratorTask<Entity> {
    private String javaFileExtension = ".java";
    private String getterPrefix = "get";
    private String setterPrefix = "set";
    private InformationModel infomodel;

    public JavaClassGeneratorTask(InformationModel infomodel) {
        this.infomodel = infomodel;
    }

    @Override
    public String getFileName(Entity entity) {
        return entity.getName() + this.javaFileExtension;
    }

    @Override
    public String getPath(Entity entity) {
        return Utils.getJavaPackageBasePath(this.infomodel) + "/model/datatypes";
    }

    @Override
    public ITemplate<Entity> getTemplate() {
        JavaClassFieldTemplate fieldTemplate = new JavaClassFieldTemplate();
        JavaClassFieldGetterTemplate getterTemplate = new JavaClassFieldGetterTemplate(this.getterPrefix);
        JavaClassFieldSetterTemplate setterTemplate = new JavaClassFieldSetterTemplate(this.setterPrefix);
        return new JavaEntityTemplate(Utils.getJavaPackage(this.infomodel) + ".model.datatypes", fieldTemplate, getterTemplate, setterTemplate);
    }
}

