/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java;

import org.eclipse.vorto.codegen.hono.java.AppTemplate;
import org.eclipse.vorto.codegen.hono.java.Log4jTemplate;
import org.eclipse.vorto.codegen.hono.java.PomFileTemplate;
import org.eclipse.vorto.codegen.hono.java.model.FunctionblockTemplate;
import org.eclipse.vorto.codegen.hono.java.model.InformationModelTemplate;
import org.eclipse.vorto.codegen.hono.java.model.JavaClassGeneratorTask;
import org.eclipse.vorto.codegen.hono.java.model.JavaEnumGeneratorTask;
import org.eclipse.vorto.codegen.hono.java.service.IDataServiceTemplate;
import org.eclipse.vorto.codegen.hono.java.service.hono.HonoDataService;
import org.eclipse.vorto.codegen.hono.java.service.hono.HonoMqttClientTemplate;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.plugin.generator.GeneratorException;
import org.eclipse.vorto.plugin.generator.GeneratorPluginInfo;
import org.eclipse.vorto.plugin.generator.ICodeGenerator;
import org.eclipse.vorto.plugin.generator.IGenerationResult;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.ChainedCodeGeneratorTask;
import org.eclipse.vorto.plugin.generator.utils.GenerationResultBuilder;
import org.eclipse.vorto.plugin.generator.utils.GenerationResultZip;
import org.eclipse.vorto.plugin.generator.utils.GeneratorTaskFromFileTemplate;
import org.eclipse.vorto.plugin.generator.utils.IGeneratedWriter;
import org.eclipse.vorto.plugin.utils.Utils;

public class EclipseHonoJavaGenerator
implements ICodeGenerator {
    @Override
    public IGenerationResult generate(InformationModel model, InvocationContext context) throws GeneratorException {
        GenerationResultZip output = new GenerationResultZip(model, "hono-java");
        GenerationResultBuilder result = GenerationResultBuilder.from(output);
        result.append(this.generateJava(model, context));
        return output;
    }

    private IGenerationResult generateJava(InformationModel infomodel, InvocationContext context) {
        GenerationResultZip output = new GenerationResultZip(infomodel, "hono-java");
        ChainedCodeGeneratorTask<InformationModel> generator = new ChainedCodeGeneratorTask<InformationModel>();
        generator.addTask(new GeneratorTaskFromFileTemplate<InformationModel>(new PomFileTemplate()));
        generator.addTask(new GeneratorTaskFromFileTemplate<InformationModel>(new Log4jTemplate()));
        generator.addTask(new GeneratorTaskFromFileTemplate<InformationModel>(new AppTemplate()));
        generator.addTask(new GeneratorTaskFromFileTemplate<InformationModel>(new IDataServiceTemplate()));
        generator.addTask(new GeneratorTaskFromFileTemplate<InformationModel>(new HonoDataService()));
        generator.addTask(new GeneratorTaskFromFileTemplate<InformationModel>(new HonoMqttClientTemplate()));
        generator.addTask(new GeneratorTaskFromFileTemplate<InformationModel>(new InformationModelTemplate()));
        generator.generate(infomodel, context, (IGeneratedWriter)output);
        for (FunctionblockProperty fbProperty : infomodel.getProperties()) {
            new GeneratorTaskFromFileTemplate<FunctionblockModel>(new FunctionblockTemplate(infomodel)).generate(fbProperty.getType(), context, (IGeneratedWriter)output);
            FunctionBlock fb = fbProperty.getType().getFunctionblock();
            for (Entity entity : Utils.getReferencedEntities(fb)) {
                this.generateForEntity(infomodel, entity, output);
            }
            for (Enum en : Utils.getReferencedEnums(fb)) {
                this.generateForEnum(infomodel, en, output);
            }
        }
        return output;
    }

    private void generateForEntity(InformationModel infomodel, Entity entity, IGeneratedWriter outputter) {
        new JavaClassGeneratorTask(infomodel).generate(entity, (InvocationContext)null, outputter);
    }

    private void generateForEnum(InformationModel infomodel, Enum en, IGeneratedWriter outputter) {
        new JavaEnumGeneratorTask(infomodel).generate(en, (InvocationContext)null, outputter);
    }

    @Override
    public GeneratorPluginInfo getMeta() {
        return (GeneratorPluginInfo)GeneratorPluginInfo.Builder("hono-java").withVendor("Eclipse Hono Team").withName("Eclipse Hono").withDescription("Creates Java code that sends telemetry data to Hono MQTT Connector.").withDocumentationUrl("https://www.eclipse.org/hono").build();
    }
}

