/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.message;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.http.apache.utils.ApacheUtils;
import com.amazonaws.services.sns.message.HttpException;
import com.amazonaws.services.sns.model.ConfirmSubscriptionResult;
import com.amazonaws.services.sns.model.transform.ConfirmSubscriptionResultStaxUnmarshaller;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;

@SdkInternalApi
final class Utils {
    private Utils() {
    }

    public static URL createUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new SdkClientException("Could not create URL: " + url, e);
        }
    }

    static ConfirmSubscriptionResult confirmSubscription(HttpClient httpClient, String subscribeUrl) {
        try {
            HttpGet request = new HttpGet(subscribeUrl);
            HttpResponse response = httpClient.execute(request);
            if (ApacheUtils.isRequestSuccessful(response)) {
                return (ConfirmSubscriptionResult)((AmazonWebServiceResponse)new StaxResponseHandler<ConfirmSubscriptionResult>(ConfirmSubscriptionResultStaxUnmarshaller.getInstance()).handle(ApacheUtils.createResponse(null, request, response, null))).getResult();
            }
            throw new HttpException("Could not confirm subscription", response);
        }
        catch (Exception e) {
            throw new SdkClientException(e);
        }
    }
}

