/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchemas;
import com.amazonaws.services.dynamodbv2.datamodeling.ConvertibleType;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperModelFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverterFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;

@SdkInternalApi
final class StandardModelFactories {
    private static final Log LOG = LogFactory.getLog(StandardModelFactories.class);

    StandardModelFactories() {
    }

    static final DynamoDBMapperModelFactory of(S3Link.Factory s3Links) {
        return new StandardModelFactory(s3Links);
    }

    private static final <T> RuleFactory<T> rulesOf(DynamoDBMapperConfig config, S3Link.Factory s3Links, DynamoDBMapperModelFactory models) {
        Rules factory;
        boolean ver1 = config.getConversionSchema() == ConversionSchemas.V1;
        boolean ver2 = config.getConversionSchema() == ConversionSchemas.V2;
        boolean v2Compatible = config.getConversionSchema() == ConversionSchemas.V2_COMPATIBLE;
        DynamoDBTypeConverterFactory.Builder scalars = config.getTypeConverterFactory().override();
        scalars.with(String.class, S3Link.class, s3Links);
        Rules rules = factory = new Rules(scalars.build());
        rules.getClass();
        factory.add(rules.new Rules.NativeType(!ver1));
        Rules rules2 = factory;
        rules2.getClass();
        factory.add(rules2.new Rules.V2CompatibleBool(v2Compatible));
        Rules rules3 = factory;
        rules3.getClass();
        factory.add(rules3.new Rules.NativeBool(ver2));
        Rules rules4 = factory;
        rules4.getClass();
        factory.add(rules4.new Rules.StringScalar(true));
        Rules rules5 = factory;
        rules5.getClass();
        factory.add(rules5.new Rules.DateToEpochRule(true));
        Rules rules6 = factory;
        rules6.getClass();
        factory.add(rules6.new Rules.NumberScalar(true));
        Rules rules7 = factory;
        rules7.getClass();
        factory.add(rules7.new Rules.BinaryScalar(true));
        Rules rules8 = factory;
        rules8.getClass();
        factory.add(rules8.new Rules.NativeBoolSet(ver2));
        Rules rules9 = factory;
        rules9.getClass();
        factory.add(rules9.new Rules.StringScalarSet(true));
        Rules rules10 = factory;
        rules10.getClass();
        factory.add(rules10.new Rules.NumberScalarSet(true));
        Rules rules11 = factory;
        rules11.getClass();
        factory.add(rules11.new Rules.BinaryScalarSet(true));
        Rules rules12 = factory;
        rules12.getClass();
        factory.add(rules12.new Rules.ObjectSet(ver2));
        Rules rules13 = factory;
        rules13.getClass();
        factory.add(rules13.new Rules.ObjectStringSet(!ver2));
        Rules rules14 = factory;
        rules14.getClass();
        factory.add(rules14.new Rules.ObjectList(!ver1));
        Rules rules15 = factory;
        rules15.getClass();
        factory.add(rules15.new Rules.ObjectMap(!ver1));
        Rules rules16 = factory;
        rules16.getClass();
        factory.add(rules16.new Rules.ObjectDocumentMap(!ver1, models, config));
        return factory;
    }

    static interface RuleFactory<T> {
        public Rule<T> getRule(ConvertibleType<T> var1);
    }

    static interface Rule<T> {
        public boolean isAssignableFrom(ConvertibleType<?> var1);

        public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> var1);

        public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType();
    }

    private static abstract class AbstractRule<S, T>
    extends DynamoDBTypeConverter.AbstractConverter<AttributeValue, S>
    implements DynamoDBMapperFieldModel.Reflect<AttributeValue, S>,
    Rule<T> {
        protected final DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType;
        protected final boolean supported;

        protected AbstractRule(DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType, boolean supported) {
            this.attributeType = attributeType;
            this.supported = supported;
        }

        @Override
        public boolean isAssignableFrom(ConvertibleType<?> type) {
            return type.attributeType() == null ? this.supported : type.attributeType() == this.attributeType;
        }

        @Override
        public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
            return this.attributeType;
        }

        @Override
        public AttributeValue convert(S o) {
            AttributeValue value = new AttributeValue();
            this.set(value, o);
            return value;
        }

        @Override
        public S unconvert(AttributeValue o) {
            Object value = this.get(o);
            if (value == null && o.isNULL() == null) {
                throw new DynamoDBMappingException("expected " + (Object)((Object)this.attributeType) + " in value " + o);
            }
            return (S)value;
        }
    }

    private static final class Rules<T>
    implements RuleFactory<T> {
        private final Set<Rule<T>> rules = new LinkedHashSet<Rule<T>>();
        private final DynamoDBTypeConverterFactory scalars;

        private Rules(DynamoDBTypeConverterFactory scalars) {
            this.scalars = scalars;
        }

        private void add(Rule<?> rule) {
            this.rules.add(rule);
        }

        @Override
        public Rule<T> getRule(ConvertibleType<T> type) {
            for (Rule<T> rule : this.rules) {
                if (!rule.isAssignableFrom(type)) continue;
                return rule;
            }
            return new NotSupported();
        }

        private <S> DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, ConvertibleType<T> type) {
            return this.scalars.getConverter(sourceType, type.targetType());
        }

        private DynamoDBTypeConverter<AttributeValue, T> getConverter(ConvertibleType<T> type) {
            return new DynamoDBTypeConverter.DelegateConverter<AttributeValue, T>(this.getRule(type).newConverter(type)){

                @Override
                public final AttributeValue convert(T o) {
                    return o == null ? new AttributeValue().withNULL(true) : (AttributeValue)super.convert(o);
                }
            };
        }

        private class NotSupported
        extends AbstractRule<T, T> {
            private NotSupported() {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.NULL, false);
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this;
            }

            @Override
            public T get(AttributeValue value) {
                throw new DynamoDBMappingException("not supported; requires @DynamoDBTyped or @DynamoDBTypeConverted");
            }

            @Override
            public void set(AttributeValue value, T o) {
                throw new DynamoDBMappingException("not supported; requires @DynamoDBTyped or @DynamoDBTypeConverted");
            }
        }

        private class ObjectDocumentMap
        extends AbstractRule<Map<String, AttributeValue>, T> {
            private final DynamoDBMapperModelFactory models;
            private final DynamoDBMapperConfig config;

            private ObjectDocumentMap(boolean supported, DynamoDBMapperModelFactory models, DynamoDBMapperConfig config) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.M, supported);
                this.models = models;
                this.config = config;
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return type.attributeType() == this.getAttributeType() && this.supported && !type.is(StandardTypeConverters.Vector.MAP);
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(final ConvertibleType<T> type) {
                return this.joinAll(new DynamoDBTypeConverter<Map<String, AttributeValue>, T>(){

                    @Override
                    public final Map<String, AttributeValue> convert(T o) {
                        return ObjectDocumentMap.this.models.getTableFactory(ObjectDocumentMap.this.config).getTable(type.targetType()).convert(o);
                    }

                    @Override
                    public final T unconvert(Map<String, AttributeValue> o) {
                        return ObjectDocumentMap.this.models.getTableFactory(ObjectDocumentMap.this.config).getTable(type.targetType()).unconvert(o);
                    }
                }, type.typeConverter());
            }

            @Override
            public Map<String, AttributeValue> get(AttributeValue value) {
                return value.getM();
            }

            @Override
            public void set(AttributeValue value, Map<String, AttributeValue> o) {
                value.setM(o);
            }
        }

        private class ObjectMap
        extends AbstractRule<Map<String, AttributeValue>, Map<String, T>> {
            private ObjectMap(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.M, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.param(1) != null && type.is(StandardTypeConverters.Vector.MAP) && type.param(0).is(StandardTypeConverters.Scalar.STRING);
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Map<String, T>> newConverter(ConvertibleType<Map<String, T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.MAP.join(Rules.this.getConverter(type.param(1))), type.typeConverter());
            }

            @Override
            public Map<String, AttributeValue> get(AttributeValue value) {
                return value.getM();
            }

            @Override
            public void set(AttributeValue value, Map<String, AttributeValue> o) {
                value.setM(o);
            }
        }

        private class ObjectList
        extends AbstractRule<List<AttributeValue>, List<T>> {
            private ObjectList(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.L, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.param(0) != null && type.is(StandardTypeConverters.Vector.LIST);
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, List<T>> newConverter(ConvertibleType<List<T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.LIST.join(Rules.this.getConverter(type.param(0))), type.typeConverter());
            }

            @Override
            public List<AttributeValue> get(AttributeValue value) {
                return value.getL();
            }

            @Override
            public void set(AttributeValue value, List<AttributeValue> o) {
                value.setL(o);
            }
        }

        private class NativeBoolSet
        extends ObjectSet {
            private NativeBoolSet(boolean supported) {
                super(supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.param(0).is(StandardTypeConverters.Scalar.BOOLEAN);
            }

            @Override
            public List<AttributeValue> unconvert(AttributeValue o) {
                if (o.getL() == null && o.getNS() != null) {
                    return StandardTypeConverters.Vector.LIST.convert(o.getNS(), new NativeBool(true).join(Rules.this.scalars.getConverter(Boolean.class, String.class)));
                }
                return (List)super.unconvert(o);
            }
        }

        private class ObjectSet
        extends AbstractRule<List<AttributeValue>, Collection<T>> {
            private ObjectSet(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.L, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.param(0) != null && type.is(StandardTypeConverters.Vector.SET);
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<T>> newConverter(ConvertibleType<Collection<T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.SET.join(Rules.this.getConverter(type.param(0))), type.typeConverter());
            }

            @Override
            public List<AttributeValue> get(AttributeValue value) {
                return value.getL();
            }

            @Override
            public void set(AttributeValue value, List<AttributeValue> o) {
                value.setL(o);
            }
        }

        private class V2CompatibleBool
        extends AbstractRule<String, T> {
            private V2CompatibleBool(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.N, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.is(StandardTypeConverters.Scalar.BOOLEAN);
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(Rules.this.getConverter(String.class, type), type.typeConverter());
            }

            @Override
            public String get(AttributeValue o) {
                if (o.getBOOL() != null) {
                    return o.getBOOL() != false ? "1" : "0";
                }
                return o.getN();
            }

            @Override
            public void set(AttributeValue o, String value) {
                o.setN(value);
            }
        }

        private class NativeBool
        extends AbstractRule<Boolean, T> {
            private NativeBool(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.BOOL, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && type.is(StandardTypeConverters.Scalar.BOOLEAN);
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(Rules.this.getConverter(Boolean.class, type), type.typeConverter());
            }

            @Override
            public Boolean get(AttributeValue o) {
                return o.getBOOL();
            }

            @Override
            public void set(AttributeValue o, Boolean value) {
                o.setBOOL(value);
            }

            @Override
            public Boolean unconvert(AttributeValue o) {
                if (o.getBOOL() == null && o.getN() != null) {
                    return (Boolean)StandardTypeConverters.Scalar.BOOLEAN.convert(o.getN());
                }
                return (Boolean)super.unconvert(o);
            }
        }

        private class ObjectStringSet
        extends StringScalarSet {
            private ObjectStringSet(boolean supported) {
                super(supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return type.attributeType() == null && this.supported && type.is(StandardTypeConverters.Vector.SET);
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<T>> newConverter(ConvertibleType<Collection<T>> type) {
                LOG.warn("Marshaling a set of non-String objects to a DynamoDB StringSet. You won't be able to read these objects back out of DynamoDB unless you REALLY know what you're doing: it's probably a bug. If you DO know what you're doing feelfree to ignore this warning, but consider using a custom marshaler for this instead.");
                return this.joinAll(StandardTypeConverters.Vector.SET.join(Rules.this.scalars.getConverter(String.class, StandardTypeConverters.Scalar.DEFAULT.type())), type.typeConverter());
            }
        }

        private class BinaryScalarSet
        extends AbstractRule<List<ByteBuffer>, Collection<T>> {
            private BinaryScalarSet(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.BS, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.B, StandardTypeConverters.Vector.SET));
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<T>> newConverter(ConvertibleType<Collection<T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.SET.join(Rules.this.getConverter(ByteBuffer.class, type.param(0))), type.typeConverter());
            }

            @Override
            public List<ByteBuffer> get(AttributeValue value) {
                return value.getBS();
            }

            @Override
            public void set(AttributeValue value, List<ByteBuffer> o) {
                value.setBS(o);
            }
        }

        private class NumberScalarSet
        extends AbstractRule<List<String>, Collection<T>> {
            private NumberScalarSet(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.NS, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.N, StandardTypeConverters.Vector.SET));
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<T>> newConverter(ConvertibleType<Collection<T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.SET.join(Rules.this.getConverter(String.class, type.param(0))), type.typeConverter());
            }

            @Override
            public List<String> get(AttributeValue value) {
                return value.getNS();
            }

            @Override
            public void set(AttributeValue value, List<String> o) {
                value.setNS(o);
            }
        }

        private class StringScalarSet
        extends AbstractRule<List<String>, Collection<T>> {
            private StringScalarSet(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.SS, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.S, StandardTypeConverters.Vector.SET));
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<T>> newConverter(ConvertibleType<Collection<T>> type) {
                return this.joinAll(StandardTypeConverters.Vector.SET.join(Rules.this.getConverter(String.class, type.param(0))), type.typeConverter());
            }

            @Override
            public List<String> get(AttributeValue value) {
                return value.getSS();
            }

            @Override
            public void set(AttributeValue value, List<String> o) {
                value.setSS(o);
            }
        }

        private class BinaryScalar
        extends AbstractRule<ByteBuffer, T> {
            private BinaryScalar(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.B, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.B));
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(Rules.this.getConverter(ByteBuffer.class, type), type.typeConverter());
            }

            @Override
            public ByteBuffer get(AttributeValue value) {
                return value.getB();
            }

            @Override
            public void set(AttributeValue value, ByteBuffer o) {
                value.setB(o);
            }
        }

        private class DateToEpochRule
        extends AbstractRule<Long, T> {
            private DateToEpochRule(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.N, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return !(!type.is(Date.class) && !type.is(Calendar.class) && !type.is(DateTime.class) || !super.isAssignableFrom(type) || type.attributeType() == null && !type.is(ScalarAttributeType.N));
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(Rules.this.getConverter(Long.class, type), type.typeConverter());
            }

            @Override
            public Long get(AttributeValue value) {
                return Long.valueOf(value.getN());
            }

            @Override
            public void set(AttributeValue value, Long o) {
                value.setN(String.valueOf(o));
            }
        }

        private class NumberScalar
        extends AbstractRule<String, T> {
            private NumberScalar(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.N, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.N));
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(Rules.this.getConverter(String.class, type), type.typeConverter());
            }

            @Override
            public String get(AttributeValue value) {
                return value.getN();
            }

            @Override
            public void set(AttributeValue value, String o) {
                value.setN(o);
            }
        }

        private class StringScalar
        extends AbstractRule<String, T> {
            private StringScalar(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.S, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return super.isAssignableFrom(type) && (type.attributeType() != null || type.is(ScalarAttributeType.S));
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(Rules.this.getConverter(String.class, type), type.typeConverter());
            }

            @Override
            public String get(AttributeValue value) {
                return value.getS();
            }

            @Override
            public void set(AttributeValue value, String o) {
                value.setS(o);
            }

            @Override
            public AttributeValue convert(String o) {
                return o.length() == 0 ? null : super.convert(o);
            }
        }

        private class NativeType
        extends AbstractRule<AttributeValue, T> {
            private NativeType(boolean supported) {
                super(DynamoDBMapperFieldModel.DynamoDBAttributeType.NULL, supported);
            }

            @Override
            public boolean isAssignableFrom(ConvertibleType<?> type) {
                return this.supported && type.is(AttributeValue.class);
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConvertibleType<T> type) {
                return this.joinAll(type.typeConverter());
            }

            @Override
            public AttributeValue get(AttributeValue o) {
                return o;
            }

            @Override
            public void set(AttributeValue value, AttributeValue o) {
                value.withS(o.getS()).withN(o.getN()).withB(o.getB()).withSS(o.getSS()).withNS(o.getNS()).withBS(o.getBS()).withBOOL(o.getBOOL()).withL(o.getL()).withM(o.getM()).withNULL(o.getNULL());
            }
        }
    }

    private static final class FieldBuilder<T, V>
    extends DynamoDBMapperFieldModel.Builder<T, V> {
        private FieldBuilder(Class<T> clazz, StandardBeanProperties.Bean<T, V> bean, Rule<V> rule) {
            super(clazz, bean.properties());
            if (bean.type().attributeType() != null) {
                this.with(bean.type().attributeType());
            } else {
                this.with(rule.getAttributeType());
            }
            this.with(rule.newConverter(bean.type()));
            this.with(bean.reflect());
        }
    }

    private static final class TableBuilder<T>
    extends DynamoDBMapperTableModel.Builder<T> {
        private TableBuilder(Class<T> clazz, StandardBeanProperties.Beans<T> beans, RuleFactory<Object> rules) {
            super(clazz, beans.properties());
            for (StandardBeanProperties.Bean<T, Object> bean : beans.map().values()) {
                try {
                    this.with(new FieldBuilder(clazz, bean, rules.getRule(bean.type())).build());
                }
                catch (RuntimeException e) {
                    throw new DynamoDBMappingException(String.format("%s[%s] could not be mapped for type %s", clazz.getSimpleName(), bean.properties().attributeName(), bean.type()), e);
                }
            }
        }

        private TableBuilder(Class<T> clazz, RuleFactory<Object> rules) {
            this(clazz, StandardBeanProperties.of(clazz), rules);
        }
    }

    private static final class StandardTableFactory
    implements DynamoDBMapperModelFactory.TableFactory {
        private final ConcurrentMap<Class<?>, DynamoDBMapperTableModel<?>> cache = new ConcurrentHashMap();
        private final RuleFactory<Object> rules;

        private StandardTableFactory(RuleFactory<Object> rules) {
            this.rules = rules;
        }

        @Override
        public <T> DynamoDBMapperTableModel<T> getTable(Class<T> clazz) {
            if (!this.cache.containsKey(clazz)) {
                this.cache.putIfAbsent(clazz, new TableBuilder(clazz, this.rules).build());
            }
            return (DynamoDBMapperTableModel)this.cache.get(clazz);
        }
    }

    private static final class StandardModelFactory
    implements DynamoDBMapperModelFactory {
        private final ConcurrentMap<ConversionSchema, DynamoDBMapperModelFactory.TableFactory> cache = new ConcurrentHashMap<ConversionSchema, DynamoDBMapperModelFactory.TableFactory>();
        private final S3Link.Factory s3Links;

        private StandardModelFactory(S3Link.Factory s3Links) {
            this.s3Links = s3Links;
        }

        @Override
        public DynamoDBMapperModelFactory.TableFactory getTableFactory(DynamoDBMapperConfig config) {
            ConversionSchema schema = config.getConversionSchema();
            if (!this.cache.containsKey(schema)) {
                ConversionSchemas.ItemConverterRuleFactory rules = StandardModelFactories.rulesOf(config, this.s3Links, this);
                rules = new ConversionSchemas.ItemConverterRuleFactory(config, this.s3Links, rules);
                this.cache.putIfAbsent(schema, new StandardTableFactory(rules));
            }
            return (DynamoDBMapperModelFactory.TableFactory)this.cache.get(schema);
        }
    }
}

