/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cognitoidentity.model.IdentityDescription;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class IdentityDescriptionMarshaller {
    private static final MarshallingInfo<String> IDENTITYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityId").build();
    private static final MarshallingInfo<List> LOGINS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Logins").build();
    private static final MarshallingInfo<Date> CREATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").timestampFormat("unixTimestamp").build();
    private static final IdentityDescriptionMarshaller instance = new IdentityDescriptionMarshaller();

    public static IdentityDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(IdentityDescription identityDescription, ProtocolMarshaller protocolMarshaller) {
        if (identityDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(identityDescription.getIdentityId(), IDENTITYID_BINDING);
            protocolMarshaller.marshall(identityDescription.getLogins(), LOGINS_BINDING);
            protocolMarshaller.marshall(identityDescription.getCreationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall(identityDescription.getLastModifiedDate(), LASTMODIFIEDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

