/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.testutils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipInputStream;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.api.VortoCodeGeneratorException;
import org.eclipse.vorto.codegen.testutils.GeneratorTestException;
import org.eclipse.vorto.codegen.testutils.ZipDiff;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.ModelConversionUtils;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.model.ModelType;
import org.eclipse.vorto.utilities.reader.IModelWorkspace;
import org.eclipse.vorto.utilities.reader.ModelWorkspaceReader;

@Deprecated
public class GeneratorTest {
    private IVortoCodeGenerator generatorUnderTest;
    private IModelWorkspace modelWorkspace;
    private InformationModel informationModel;
    private IGenerationResult generatorResult;

    public static GeneratorTest withGenerator(IVortoCodeGenerator generator) {
        return new GeneratorTest(Objects.requireNonNull(generator));
    }

    private GeneratorTest(IVortoCodeGenerator generatorUnderTest) {
        this.generatorUnderTest = generatorUnderTest;
    }

    public GeneratorTest andModels(ModelEntry ... modelEntries) throws GeneratorTestException {
        ModelWorkspaceReader modelWorkspaceReader = IModelWorkspace.newReader();
        for (ModelEntry modelEntry : modelEntries) {
            if (modelEntry.modelDsl == null || modelEntry.modelType == null) {
                throw new GeneratorTestException("Cannot read model");
            }
            modelWorkspaceReader.addFile((InputStream)new ByteArrayInputStream(modelEntry.modelDsl.getBytes(StandardCharsets.UTF_8)), modelEntry.modelType);
        }
        this.modelWorkspace = modelWorkspaceReader.read();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneratorTest useModel(String modelName) throws GeneratorTestException {
        Optional<Model> maybeModel = this.modelWorkspace.get().stream().filter(p -> p.getName().equals(modelName)).findFirst();
        if (!maybeModel.isPresent()) throw new GeneratorTestException("No model of the name: " + modelName);
        Model model = maybeModel.get();
        if (model instanceof InformationModel) {
            this.informationModel = (InformationModel)model;
            return this;
        } else {
            if (!(model instanceof FunctionblockModel)) throw new GeneratorTestException("No information model or functionblock of the name: " + modelName);
            this.informationModel = Utils.wrapFunctionBlock((FunctionblockModel)model);
        }
        return this;
    }

    public GeneratorTest thenGenerate(InvocationContext invocationContext) throws VortoCodeGeneratorException {
        this.generatorResult = this.generatorUnderTest.generate(ModelConversionUtils.convertToFlatHierarchy((InformationModel)this.informationModel), invocationContext, null);
        return this;
    }

    public ZipDiff.Result andCompare(ZipInputStream zipComparison) {
        return new ZipDiff().diff(new ZipInputStream(new ByteArrayInputStream(this.generatorResult.getContent())), zipComparison);
    }

    public static class ModelEntry {
        private ModelType modelType;
        private String modelDsl;

        public ModelEntry(ModelType modelType, String modelDsl) {
            this.modelType = modelType;
            this.modelDsl = modelDsl;
        }
    }
}

