/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;

@Deprecated
public class ApiGatewayResponse {
    private final int statusCode;
    private final String body;
    private final Map<String, String> headers;
    private final boolean isBase64Encoded;

    public ApiGatewayResponse(int statusCode, String body, Map<String, String> headers, boolean isBase64Encoded) {
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers;
        this.isBase64Encoded = isBase64Encoded;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isIsBase64Encoded() {
        return this.isBase64Encoded;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final Logger LOG = Logger.getLogger(Builder.class);
        private static final ObjectMapper objectMapper = new ObjectMapper();
        private int statusCode = 200;
        private Map<String, String> headers = Collections.emptyMap();
        private String rawBody;
        private Object objectBody;
        private byte[] binaryBody;
        private boolean base64Encoded;

        public Builder setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setRawBody(String rawBody) {
            this.rawBody = rawBody;
            return this;
        }

        public Builder setObjectBody(Object objectBody) {
            this.objectBody = objectBody;
            return this;
        }

        public Builder setBinaryBody(byte[] binaryBody) {
            this.binaryBody = binaryBody;
            this.setBase64Encoded(true);
            return this;
        }

        public Builder setBase64Encoded(boolean base64Encoded) {
            this.base64Encoded = base64Encoded;
            return this;
        }

        public ApiGatewayResponse build() {
            String body = null;
            if (this.rawBody != null) {
                body = this.rawBody;
            } else if (this.objectBody != null) {
                try {
                    body = objectMapper.writeValueAsString(this.objectBody);
                }
                catch (JsonProcessingException e) {
                    LOG.error((Object)"could not serialize object to json", (Throwable)e);
                    throw new RuntimeException(e);
                }
            } else if (this.binaryBody != null) {
                body = new String(Base64.getEncoder().encode(this.binaryBody), StandardCharsets.UTF_8);
            }
            return new ApiGatewayResponse(this.statusCode, body, this.headers, this.base64Encoded);
        }
    }
}

