/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.api;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.vorto.codegen.api.EclipseProjectParserHandler;
import org.eclipse.vorto.codegen.api.Generated;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ZipContentExtractCodeGeneratorTask
implements ICodeGeneratorTask<ModelId> {
    private static final String MAVEN_POM = "pom.xml";
    private static final String ECLIPSE_PROJECT = ".project";
    private static final String[] PATH = new String[]{"projectDescription", "name"};
    private byte[] zipContent;
    private boolean isMavenContent = false;
    private String eclipseProjectName = null;
    private final EclipseProjectParserHandler handler = new EclipseProjectParserHandler(PATH);
    private SoftReference<SAXParser> parser = null;

    public ZipContentExtractCodeGeneratorTask(byte[] zipContent) {
        this.zipContent = zipContent;
    }

    @Override
    public void generate(ModelId infoModelId, InvocationContext context, IGeneratedWriter outputter) {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(this.zipContent));
        try {
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.isDirectory()) {
                    outputter.write(new Generated(null, ze.getName(), new byte[0]));
                    continue;
                }
                int indexOfLastSlash = ze.getName().lastIndexOf("/");
                String fileName = null;
                String folderName = null;
                if (indexOfLastSlash > -1) {
                    fileName = ze.getName().substring(indexOfLastSlash + 1);
                    folderName = ze.getName().substring(0, indexOfLastSlash);
                } else {
                    fileName = ze.getName();
                }
                outputter.write(new Generated(fileName, folderName, new String(this.copyStream(zis), "utf-8")));
                if (!fileName.equalsIgnoreCase(MAVEN_POM)) continue;
                this.isMavenContent = true;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private byte[] copyStream(InputStream in) throws IOException {
        int size;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        BufferedOutputStream bos = new BufferedOutputStream(out);
        while ((size = in.read(buffer, 0, buffer.length)) != -1) {
            bos.write(buffer, 0, size);
        }
        bos.flush();
        bos.close();
        return out.toByteArray();
    }

    public boolean isMavenContent() {
        return this.isMavenContent;
    }

    public String getEclipseProjectName() {
        return this.eclipseProjectName;
    }

    public void preprocess() {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(this.zipContent));
        try {
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                int mPos = name.length() - MAVEN_POM.length() - 1;
                int ePos = name.length() - ECLIPSE_PROJECT.length() - 1;
                if (MAVEN_POM.equals(name) || mPos > 0 && (name.charAt(mPos) == '/' || name.charAt(mPos) == '\\')) {
                    this.isMavenContent = true;
                    continue;
                }
                if (!ECLIPSE_PROJECT.equals(name) && (ePos <= 0 || name.charAt(mPos) != '/' && name.charAt(ePos) != '\\')) continue;
                if (this.parser == null || this.parser.get() == null) {
                    this.parser = new SoftReference<SAXParser>(SAXParserFactory.newInstance().newSAXParser());
                }
                this.parser.get().parse((InputStream)zis, (DefaultHandler)this.handler);
                this.eclipseProjectName = this.handler.getValue();
                this.handler.reset();
            }
        }
        catch (IOException | SAXException exception) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }
}

