/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.utils;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.datatype.BooleanPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.BooleanPropertyAttributeType;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteralPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteralPropertyAttributeType;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModelFactory;
import org.eclipse.vorto.core.api.model.model.ModelFactory;
import org.eclipse.vorto.core.api.model.model.ModelReference;

public class Utils {
    public static String getReturnType(ReturnType type) {
        if (type instanceof ReturnPrimitiveType) {
            return ((ReturnPrimitiveType)type).getReturnType().getName();
        }
        if (type instanceof ReturnObjectType) {
            return ((ReturnObjectType)type).getReturnType().getName();
        }
        return null;
    }

    public static String getPropertyType(Property property) {
        if (property.getType() instanceof PrimitivePropertyType) {
            return ((PrimitivePropertyType)property.getType()).getType().getName();
        }
        if (property.getType() instanceof ObjectPropertyType) {
            return ((ObjectPropertyType)property.getType()).getType().getName();
        }
        return null;
    }

    public static InformationModel wrapFunctionBlock(FunctionblockModel fbModel) {
        InformationModel infomodel = InformationModelFactory.eINSTANCE.createInformationModel();
        infomodel.setCategory(fbModel.getCategory());
        infomodel.setDescription(fbModel.getDescription());
        infomodel.setDisplayname(fbModel.getDisplayname());
        infomodel.setName(fbModel.getName() + "IM");
        infomodel.setNamespace(fbModel.getNamespace());
        infomodel.setVersion(fbModel.getVersion());
        FunctionblockProperty property = InformationModelFactory.eINSTANCE.createFunctionblockProperty();
        property.setType(fbModel);
        property.setName(fbModel.getName().toLowerCase());
        infomodel.getProperties().add((Object)property);
        ModelReference reference = ModelFactory.eINSTANCE.createModelReference();
        reference.setImportedNamespace(fbModel.getNamespace() + "." + fbModel.getName());
        reference.setVersion(fbModel.getVersion());
        infomodel.getReferences().add((Object)reference);
        return infomodel;
    }

    public static boolean isSimpleNumeric(Property property) {
        if (property.getType() instanceof PrimitivePropertyType) {
            PrimitiveType primitiveType = ((PrimitivePropertyType)property.getType()).getType();
            if (primitiveType == PrimitiveType.INT) {
                return true;
            }
            if (primitiveType == PrimitiveType.FLOAT) {
                return true;
            }
            if (primitiveType == PrimitiveType.DOUBLE) {
                return true;
            }
            if (primitiveType == PrimitiveType.LONG) {
                return true;
            }
            if (primitiveType == PrimitiveType.SHORT) {
                return true;
            }
        }
        return false;
    }

    public static String getMinConstraint(Property property) {
        if (property.getConstraintRule() != null && property.getConstraintRule().getConstraints() != null && property.getConstraintRule() != null && property.getConstraintRule().getConstraints().size() > 0) {
            for (Constraint constraint : property.getConstraintRule().getConstraints()) {
                if (constraint.getType() != ConstraintIntervalType.MIN) continue;
                return constraint.getConstraintValues();
            }
        }
        return "";
    }

    public static String getMaxConstraint(Property property) {
        if (property.getConstraintRule() != null && property.getConstraintRule().getConstraints() != null && property.getConstraintRule() != null && property.getConstraintRule().getConstraints().size() > 0) {
            for (Constraint constraint : property.getConstraintRule().getConstraints()) {
                if (constraint.getType() != ConstraintIntervalType.MAX) continue;
                return constraint.getConstraintValues();
            }
        }
        return "";
    }

    public static String getMeasurementUnit(Property property) {
        EnumLiteral literal = Utils.getEnumLiteralPropertyAttribute(property, EnumLiteralPropertyAttributeType.MEASUREMENT_UNIT);
        if (literal != null) {
            return literal.getName();
        }
        return "";
    }

    public static boolean isReadable(Property property) {
        return Utils.getBooleanPropertyAttribute(property, BooleanPropertyAttributeType.READABLE);
    }

    public static boolean isWritable(Property property) {
        return Utils.getBooleanPropertyAttribute(property, BooleanPropertyAttributeType.WRITABLE);
    }

    public static boolean isEventable(Property property) {
        return Utils.getBooleanPropertyAttribute(property, BooleanPropertyAttributeType.EVENTABLE);
    }

    public static boolean getBooleanPropertyAttribute(Property property, BooleanPropertyAttributeType type) {
        if (property.getPropertyAttributes() != null && property.getPropertyAttributes().size() > 0) {
            for (PropertyAttribute pA : property.getPropertyAttributes()) {
                BooleanPropertyAttribute bPA;
                if (!(pA instanceof BooleanPropertyAttribute) || (bPA = (BooleanPropertyAttribute)pA).getType() != type || !bPA.isValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static EnumLiteral getEnumLiteralPropertyAttribute(Property property, EnumLiteralPropertyAttributeType type) {
        if (property.getPropertyAttributes() != null && property.getPropertyAttributes().size() > 0) {
            for (PropertyAttribute pA : property.getPropertyAttributes()) {
                EnumLiteralPropertyAttribute bPA;
                if (!(pA instanceof EnumLiteralPropertyAttribute) || (bPA = (EnumLiteralPropertyAttribute)pA).getType() != type) continue;
                return bPA.getValue();
            }
        }
        return null;
    }

    public static EList<Entity> getReferencedEntities(FunctionBlock fb) {
        BasicEList entities = new BasicEList();
        for (Type type : Utils.getReferencedTypes(fb)) {
            if (!(type instanceof Entity) || entities.contains((Object)((Entity)type))) continue;
            entities.add((Object)((Entity)type));
        }
        return entities;
    }

    public static EList<Enum> getReferencedEnums(FunctionBlock fb) {
        BasicEList enums = new BasicEList();
        for (Type type : Utils.getReferencedTypes(fb)) {
            if (!(type instanceof Enum) || enums.contains((Object)((Enum)type))) continue;
            enums.add((Object)((Enum)type));
        }
        return enums;
    }

    public static EList<Type> getReferencedTypes(Type type) {
        BasicEList types = new BasicEList();
        types.add((Object)type);
        if (type instanceof Entity) {
            Entity entityType = (Entity)type;
            for (Property property : entityType.getProperties()) {
                types.addAll(Utils.getReferencedTypes(property));
            }
            types.add((Object)entityType.getSuperType());
        }
        return types;
    }

    public static EList<Type> getReferencedTypes(Property property) {
        BasicEList types = new BasicEList();
        if (property.getType() instanceof ObjectPropertyType) {
            ObjectPropertyType objectType = (ObjectPropertyType)property.getType();
            types.add((Object)objectType.getType());
            if (objectType.getType() instanceof Entity) {
                types.addAll(Utils.getReferencedTypes((Type)((Entity)objectType.getType())));
            }
        }
        return types;
    }

    public static EList<Type> getReferencedTypes(FunctionBlock fb) {
        BasicEList types = new BasicEList();
        if (fb != null) {
            if (fb.getStatus() != null) {
                for (Property property : fb.getStatus().getProperties()) {
                    types.addAll(Utils.getReferencedTypes(property));
                }
            }
            if (fb.getConfiguration() != null) {
                for (Property property : fb.getConfiguration().getProperties()) {
                    types.addAll(Utils.getReferencedTypes(property));
                }
            }
            if (fb.getFault() != null) {
                for (Property property : fb.getFault().getProperties()) {
                    types.addAll(Utils.getReferencedTypes(property));
                }
            }
            for (Operation op : fb.getOperations()) {
                if (op.getReturnType() instanceof ReturnObjectType) {
                    types.addAll(Utils.getReferencedTypes(((ReturnObjectType)op.getReturnType()).getReturnType()));
                }
                for (Param param : op.getParams()) {
                    if (!(param instanceof RefParam)) continue;
                    types.addAll(Utils.getReferencedTypes(((RefParam)param).getType()));
                }
            }
        }
        return types;
    }
}

