/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.SelectPerspectiveDialog;

public final class ShowPerspectiveHandler
extends AbstractHandler {
    private static final String PARAMETER_NAME_VIEW_ID = "org.eclipse.ui.perspectives.showPerspective.perspectiveId";

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        Map parameters = event.getParameters();
        Object value = parameters.get(PARAMETER_NAME_VIEW_ID);
        if (value == null) {
            this.openOther(window);
        } else {
            this.openPerspective((String)value, window);
        }
        return null;
    }

    private final void openOther(IWorkbenchWindow activeWorkbenchWindow) throws ExecutionException {
        SelectPerspectiveDialog dialog = new SelectPerspectiveDialog(activeWorkbenchWindow.getShell(), WorkbenchPlugin.getDefault().getPerspectiveRegistry());
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        IPerspectiveDescriptor descriptor = dialog.getSelection();
        if (descriptor != null) {
            this.openPerspective(descriptor.getId(), activeWorkbenchWindow);
        }
    }

    private final void openPerspective(String perspectiveId, IWorkbenchWindow activeWorkbenchWindow) throws ExecutionException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IAdaptable input = null;
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage != null) {
            input = activePage.getInput();
        }
        try {
            workbench.showPerspective(perspectiveId, activeWorkbenchWindow, input);
        }
        catch (WorkbenchException e) {
            throw new ExecutionException("Perspective could not be opened.", (Throwable)((Object)e));
        }
    }
}

